/*
 *
 * rcatdvi -- send stdin to catdvi on remote
 * machine, get stdout and stderr back.  Invoked as
 * "rcatdvi [-h host] [catdvioptions], runs setuid to make
 * connection, then does a setreuid(getuid, getuid) to go back
 * to being the "real" user.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <pwd.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/wait.h>
#include <signal.h>
#include <errno.h>

#define LINESIZ 133
#define BUFSIZE 1024

char	**args;
char	*strcpy(), *strcat();
FILE 	*infile, *outfile;
int	errfd, iofd, pid1, pid2;
extern	int errno;

main(argc,argv)
int	argc;
char	*argv[];
{
	char	cmdline[LINESIZ], *host = NULL;
	struct	servent	*serv, rserv;
	int	i, firstarg, uid;
	int	reapchild();

	(void) signal(SIGCHLD, reapchild);
	args = argv;
	if((serv=getservbyname("shell","tcp"))==NULL) {
		perror("rcatdvi:getservbyname");
		exit(-1);
	}
	rserv = *serv;	/* copy data so we don't overwrite later */
	if (strcmp("-h",argv[1])==0) {
		host=argv[2];
		firstarg=3;
	}
	else
		firstarg=1;
	(void) strcat(cmdline,"/usr/local/bin/catdvi");
	if (argc>(firstarg-1)) {
		for (i=firstarg;i<argc;i++) {
			(void) strcat(cmdline," ");
			(void) strcat(cmdline,argv[i]);
#ifdef DEBUG
	fprintf(stderr, "added ' %s' to cmd line (arg %d of %d)\n",
		argv[i], i, argc);
#endif
		}
	}
#ifdef DEBUG
	fprintf(stderr, "command line is '%s'\n", cmdline);
#endif
	if (host == NULL) {
		/*
		 * since the user didn't tell us where to go,
		 * let's find the host with the least load and
		 * go to it.
		 */
		struct	hostent *fhent, sfhent, *gethost();
		char	hname[512];

		fhent = (struct hostent *)gethost("/etc/rcathosts");
		if (fhent == NULL) {
			fprintf(stderr, "rcatdvi: remote hostent unknown\n");
			exit (1);
		}
		(void) strcpy(hname, fhent->h_name);
		sfhent = *fhent;
		sfhent.h_name = hname;
		if (islocalhost(&sfhent))
			dolocalexec();
		if((iofd=rcmd(&sfhent.h_name, rserv.s_port, "rtroff",
			"rtroff", cmdline, &errfd))<0) {
			perror("rcatdvi: rcmd");
			fprintf(stderr,"Host %s down - try again later\n",
				sfhent.h_name);
			exit (1);
		}
	} else if((iofd=rcmd(&host, rserv.s_port, "rtroff",
		"rtroff", cmdline, &errfd))<0) {
			perror("rcatdvi: rcmd");
			exit(-1);
		}
	uid = getuid();
	(void) setreuid(uid, uid);	/* become the real user */
	/*
	 * Now we fork off the processes to handle sending
	 * and receiving.
	 */
	if ((pid1 = fork()) < 0) {
		perror("rcatdvi: fork");
		exit(1);
	}
	if (pid1 == 0) {
		/*
		 * Then we are child #1 and will be sending input
		 * to the other side.
		 */
		if (( outfile = fdopen (iofd,"w")) == NULL) {
			perror("rcatdvi: can't fdopen socket for output");
			exit(1);
		}
		sendstdin(outfile);
		(void) fflush(outfile);
		(void) shutdown(iofd, 1);
		(void) fclose(outfile);
#ifdef DEBUG
	fprintf(stderr, "rcatdvi: send process finished normally\n");
#endif
		exit(0);
	}
	/*
	 * Parent.
	 */
	if ((pid2 = fork()) < 0) {
		perror("rcatdvi: fork");
		(void) kill(pid1, SIGTERM);
		exit(1);
	}
	if (pid2 == 0) {
		/*
		 * Then we are the second child and will
		 * be reading results from the other side.
		 */
		if (( infile = fdopen(iofd,"r")) == NULL) {
			perror("rcatdvi: can't fdopen socket for input");
			(void) kill(pid1, SIGTERM);
			exit(1);
		}
		getresults(infile);
		(void) fclose(infile);
#ifdef DEBUG
	fprintf(stderr, "rcatdvi: recv process finished normally\n");
#endif
		exit(0);
	}
	/*
	 * Parent again -- read errors and wait for kids to exit.
	 */
	geterrsandwait(errfd);
	(void) close(errfd);
	exit(0);
}

sendstdin(fl)
	register FILE *fl;
{
	register int nread;
	char	buf[BUFSIZE];

	while((nread = fread(buf, sizeof(char), sizeof(buf), stdin)) > 0)
		if (fwrite(buf, sizeof(char), nread, fl) != nread) {
			perror("rcatdvi: fwrite");
			(void) shutdown(iofd, 1); /* cause SIGPIPE sometime */
			exit(23);
		}
}

getresults(fl)
	register FILE *fl;
{
	register int nread;
	char	buf[BUFSIZE];

	while ((nread = fread(buf, sizeof(char), sizeof(buf), fl)) > 0)
		if (fwrite(buf, sizeof(char), nread, stdout) != nread) {
			perror("rcatdvi: fwrite to stdout");
			(void) kill(pid1, SIGTERM);
			exit(23);
		}
}

geterrsandwait(skt)
	register int skt;
{
	register int nread;
	char buf[BUFSIZE];
	union wait status;

	while ((nread = read(skt, buf, sizeof(buf))) != 0) {
		if (nread < 0)
			if (errno == EINTR) /* SIGCHLD got us */
				continue;
			else
				break;
		(void) write(2, buf, nread);
	}
	/*
	 * Now we wait for the kids to finish.
	 */
	while (wait(&status) >= 0)
		;
}

reapchild()
{
	struct rusage rusage;
	union wait status;

	while (wait3(&status, WNOHANG, &rusage) > 0)
#ifdef DEBUG
	fprintf(stderr, "rcatdvi: wait3: got one kid\n");
#else
		;
#endif
}

dolocalexec()
{
	int uid;

	uid = getuid();
	(void) setreuid(uid, uid);
	execv("/usr/local/bin/catdvi", args);
	perror("rcatdvi: exec of catdvi");
	exit (1);
}

