#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/time.h>
#include <errno.h>
#include <fcntl.h>
#include <sysexits.h>
#include <nlist.h>
#include "rload.h"
/*
 * the fixify macro turns a float or a double into the fixed-point
 * notation we use for everything.
 */
#define fixify(a)	((long) ((a) * 256.0))
#define	unfixify(a)	((float) ((a) / 256.0))

#ifdef FD_SETSIZE
#define BSD4_3
#endif

struct	rl_node {
    struct rload r_load;
    struct in_addr r_host;
    struct rl_node *r_next;
} *rl_head = NULL;

char	*malloc();

struct	hostent *
gethost(hostfile)
    char	*hostfile;
{
    struct in_addr addr, getminav();
    struct hostent *localhost;

    getrloads(hostfile);
    addr = getminav(rl_head);
#ifdef DEBUG
    fprintf(stderr, "addr is %lx\n", ntohl(addr.s_addr));
#endif
    localhost = gethostbyaddr((char *)&addr, sizeof(addr), AF_INET);
#ifdef DEBUG
    fprintf(stderr, "host with the least load is %s\n",localhost->h_name);
#endif
    return(localhost);
}

/*
 * Open a UDP socket to the load daemons on all the machines in
 * the file named in hostfile, and insert their loads into the
 * load list so we can later find the address of the machine
 * with the minimum load.
 */

getrloads(hostfile)
    char	*hostfile;
{
    int skt, nready;
#ifdef BSD4_3
    struct fd_set readfds, readyrd;
#else
    int readfds, readyrd;
#endif
    FILE *hosts;
    char hostname[40];
    struct timeval timeout;
    struct sockaddr_in laddr, faddr;
    struct rl_node *r;
    struct servent *serv;

    serv = getservbyname("load", "udp");
    if (serv == NULL) {
	fprintf(stderr,"getloads: load/udp: unknown service\n");
	return;
    }
    skt = socket (AF_INET, SOCK_DGRAM, 0);
    if (skt < 0) {
	perror ("getloads: couldn't get socket");
	return;
    }

    laddr.sin_family = AF_INET;
    laddr.sin_port = 0;
    laddr.sin_addr.s_addr = 0;	/* for grins */
    if (bind (skt, &laddr, sizeof (laddr)) < 0) {
	perror ("getloads: bind");
	(void) close (skt);
	return;
    }

    /* 
     * Now that the socket is set up, we open and read the hostfile
     * to get the machines we can (maybe) go to.  For each machine,
     * we poll it for its load, then put the load in the list
     * (until we hit eof).
     */

    hosts = fopen (hostfile, "r");
    if (hosts == NULL) {
	perror ("getloads: fopen of hostfile");
	(void) close (skt);
	return;
    }
    while (fgets (hostname, 40, hosts) != NULL) {
	char   *pos, *index();
	struct hostent  *h_ent;

	pos = index (hostname, '\n');
	if (pos != NULL)
	    *pos = '\0';
	h_ent = gethostbyname (hostname);
	if (h_ent == NULL) {
	    fprintf (stderr, "getloads: host %s unknown\n", hostname);
	    continue;
	}

	faddr.sin_family = AF_INET;
	faddr.sin_port = serv->s_port;
	bcopy(h_ent->h_addr, (char *)&faddr.sin_addr.s_addr, h_ent->h_length);
	if (sendto (skt, "l", 1, 0, (struct sockaddr *)&faddr,
            sizeof(faddr)) != 1) {
	        perror ("getloads: sendto");
	        continue;
	}

        /* 
         * And now we get the response and put it in our
         * load list.
         */
#ifdef BSD4_3
	FD_ZERO(&readfds);
	FD_SET(skt, &readfds);	/* turn on proper bit in set readfds */
#else
	readfds = 1 << skt;
#endif
	timeout.tv_sec = 5;
	timeout.tv_usec = 0;	/* 5 second */
  	readyrd = readfds;
#ifdef BSD4_3
#define MKSET(n)	((struct fd_set *) (n))
	nready = select (32, &readyrd, MKSET(NULL), MKSET(NULL), &timeout);
#else
	nready = select (32, &readyrd, (int *)NULL, (int *)NULL, &timeout);
#endif
	if (nready < 0) {
	    perror ("getloads: select");
	    (void) close (skt);
	    return;
	}
#ifdef BSD4_3
	if (FD_ISSET(skt, &readyrd)) {
#else
	if (readyrd & readfds) {
#endif

	    struct sockaddr_in raddr;
	    int rsize = sizeof (raddr);
	    int	nbytes, i;

	    r = (struct rl_node *) malloc (sizeof (struct rl_node));
	    if (r == NULL) {
		fprintf(stderr, "getloads: malloc failed\n");
		(void) close(skt);
		return;
	    }
	    if ((nbytes = recvfrom (skt, (char *)(&r->r_load),
		sizeof(struct rload), 0, (struct sockaddr *)&raddr, &rsize))
		!= sizeof(struct rload)) {
		    perror("getloads: recvfrom");
		    fprintf(stderr, "getloads: out of data from %lx (%d/%d bytes)\n",
			ntohl(raddr.sin_addr.s_addr), nbytes,
			sizeof(r->r_load));
		    free((char *)r);
		    continue;
	    };
#ifdef DEBUG
	    fprintf(stderr, "got reply from host %lx\n",
		ntohl(raddr.sin_addr.s_addr));
#endif
	    for (i=0; i<=2; i++)
		r->r_load.avgs[i] = ntohl((u_long)r->r_load.avgs[i]);
	    r->r_load.cpuumph = ntohl((u_long)r->r_load.cpuumph);
	    r->r_host = raddr.sin_addr;
	    r->r_next = rl_head;
	    rl_head = r;
	}
    }
    (void) fclose(hosts);
    return;
}

#define	RELAVG(v)	((float) (((v)->r_load.avgs[0] * 1.0) / \
	(v)->r_load.cpuumph))


struct	in_addr
getminav(rlp)
    struct rl_node *rlp;
{

    struct rl_node *minp;

    if (rlp == NULL) {
	fprintf(stderr, "getloads: no loads?!?\n");
	dolocalexec();
    }
    /*
     * find the first machine in the list that doesn't
     * have a zero umph factor (assume that those who do
     * don't want us to go there).
     */
    while (rlp && rlp->r_load.cpuumph == 0)
	rlp = rlp->r_next;
    if (rlp == NULL)	/* nowhere to go */
	dolocalexec();
    minp = rlp;
    rlp = rlp->r_next;
    while (rlp != NULL) {
#ifdef DEBUG
	fprintf(stderr, "getmin: looking at host %lx\n",
	    ntohl(rlp->r_host.s_addr));
#endif
	if (rlp->r_load.cpuumph != 0 && RELAVG(rlp) < RELAVG(minp))
	    /* skip host if no cpu power */
		minp = rlp;
	rlp = rlp->r_next;
    }
    return(minp->r_host);
}

/*
 * Return true iff h is a synonym for ourselves.
 */
islocalhost(h)
    register struct hostent *h;
{
    register struct hostent *thishost;
    register char **sp;
    char hname[512];
    int laddr, gethostid();	/* lint says it's int */

    if (h->h_length == 4) {
	laddr = gethostid();
#ifdef DEBUG
	fprintf(stderr, "laddr.s_addr = %lx\n", laddr);
#endif
	if (bcmp((char *)&laddr, h->h_addr, h->h_length) == 0)
	    return (1);
    }
    /*
     * gethostid doesn't always work, since no one need do
     * a sethostid to make the system run.
     */
    if (gethostname(hname, sizeof hname))/* don't know who I am?! */
	return (0);
#ifdef DEBUG
    fprintf(stderr, "comparing names: %s vs %s\n", hname, h->h_name);
#endif
    if (strcmp(hname, h->h_name) == 0)
	return (1);
    /*
     * Finally, try canonical version (look up our name in the
     * host table).
     */
    thishost = gethostbyname(hname);
    if (thishost == 0)
	return (0);
#ifdef DEBUG
    fprintf(stderr, "comparing name: %s\n", thishost->h_name);
#endif
    if (strcmp(thishost->h_name, h->h_name) == 0)
	return (1);
    for (sp = thishost->h_aliases; *sp; sp++) {
#ifdef DEBUG
	fprintf(stderr, "comparing alias: %s\n", *sp);
#endif
	if (strcmp(*sp, h->h_name) == 0)
	    return (1);
    }
    return (0);
}
