/*
 * $Header$
 *
 * defs.h - definitions for restricted shell
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * davy@intrepid.ecn.purdue.edu
 * August, 1987
 *
 * $Log$
 */
#define CONFDIR		"/usr/adm/resh"		/* configuration directory */
#define SHELLNAME	"/usr/ecn/resh"		/* where the shell lives   */

#define ABSIZ		10240			/* arg buffer size (glob)  */
#define TRESIZ		256			/* size of parse tree	   */
#define LINSIZ		1024			/* size of input line	   */
#define ARGSIZ		1024			/* size of arg buffer	   */
#define MAXARGS		1024			/* max no. of cmd args	   */
#define MAXCMDS		1024			/* max no. of rest. cmds   */
#define MAXENVIRON	1024			/* max no. of environ vars */

#define FAND		0x01			/* command backgrounded	   */
#define FCAT		0x02			/* output append (>>)	   */
#define FPIN		0x04			/* cmd has pipe for input  */
#define FPOU		0x08			/* cmd has pipe for output */
#define FPAR		0x10			/* parenthesized command   */
#define FINT		0x20			/* interactive command     */
#define FPRS		0x40

#define QUOTE		0200			/* argument quoted	   */

#define TCOM		1			/* command		   */
#define TPAR		2			/* parenthesized	   */
#define TFIL		3			/* redirect file argument  */
#define TLST		4			/* parenthsized list 	   */

#define DTYP		0			/* type of command	   */
#define DLEF		1			/* left arrow (<)	   */
#define DRIT		2			/* right arrow (>)	   */
#define DFLG		3			/* flag word		   */
#define DSPR		4			/* "spare"		   */
#define DCOM		5

#define SLOP		5
