/* CHK=0x5438 */
/*+-------------------------------------------------------------------------
	uxlst.h -- utility xlist - fast access to kernel /dev/kmem offsets

The uxlst file contains three records:
1.  struct stat xstat - stat buffer from /xenix at file creation time
2.  struct xlist uxlst - the structure of xlist'd information
3.  long unique - a unique identifier to help ensure correct uxlst length

NOTE: the xl_name pointers are INVALID in programs using /xenix.uxlst
--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:10-27-1988-11:07-wht-creation */

#define XENIX_KERNEL	"/xenix"
#define XENIX_UXLST		"/xenix.uxlst"
#define UXLST_UNIQUE	0xEFBC9A78L

#define procaddr (uxlst[0].xl_value)
#define	vaddr (uxlst[1].xl_value)

#ifdef DEFINE_UXLST
struct xlist	uxlst[] =
{
	{ 0,0,0,"_proc"},
	{ 0,0,0,"_v"},
	{ 0,0,0,(char *)0},
};
#else
extern struct xlist uxlst[];
#endif

/* vi: set tabstop=4 shiftwidth=4: */
