/* CHK=0x3487 */
/*+-------------------------------------------------------------------------
	libuxlst.c -- common runtime for uxlst users

  Defined functions:
	uxlst_error(err_indicator)
	uxlst_read()

--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:10-27-1988-11:44-wht-creation */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <a.out.h>

#define DEFINE_UXLST
#include "uxlst.h"

#include "libuxlst.h"

/*+-------------------------------------------------------------------------
	uxlst_error(err_indicator)
--------------------------------------------------------------------------*/
void
uxlst_error(err_indicator)
int		err_indicator;
{
	if(err_indicator < 0)
		perror(XENIX_UXLST);
	fprintf(stderr,"run uxlst against %s\n",XENIX_KERNEL);
	exit(1);
}	/* end of uxlst_error */

/*+-------------------------------------------------------------------------
	uxlst_read()
--------------------------------------------------------------------------*/
void
uxlst_read()
{
int		itmp;
int		fduxlst;
struct stat curstat;	/* current /xenix status */
struct stat xstat;		/* /xenix status at uxlst run time */
long	unique;

	if(stat(XENIX_KERNEL,&curstat) < 0)
	{
		fputs("cannot stat ",stderr);
		perror(XENIX_KERNEL);
		exit(1);
	}

	if((fduxlst = open(XENIX_UXLST,O_RDONLY,0)) < 0)
		uxlst_error(fduxlst);

	if((itmp = read(fduxlst,&xstat,sizeof(xstat))) != sizeof(xstat))
	{
		fprintf(stderr,"xstat error: ");
		uxlst_error(itmp);
	}

	if((itmp = read(fduxlst,uxlst,sizeof(uxlst))) != sizeof(uxlst))
	{
		fprintf("uxlst error: ");
		uxlst_error(itmp);
	}

	if((itmp = read(fduxlst,&unique,sizeof(unique))) != sizeof(unique))
	{
		fprintf("unique error: ");
		uxlst_error(itmp);
	}

	close(fduxlst);

	if( (unique != UXLST_UNIQUE) ||
		(xstat.st_ino != curstat.st_ino) ||
		(xstat.st_mtime != curstat.st_mtime) ||
		(xstat.st_size != curstat.st_size))
	{
		fprintf(stderr,"%s out of date\n",XENIX_UXLST);
		uxlst_error(0);
	}

}	/* end of uxlst_read */
