/* CHK=0x7937 */
/*+-------------------------------------------------------------------------
	libkmem.c -- /dev/kmem routines for SCO XENIX V/286 (maybe other *NIX)

  Defined functions:
	kinit(write_needed)
	kread(caddr,kaddr,len)
	kwrite(kaddr,caddr,len)

 routines were originally written by Mike "Ford" Ditto: kudos!!!
--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:10-27-1988-12:44-wht-creation of file */

#include <sys/types.h>
#include <fcntl.h>
#include "libkmem.h"

static int fdkmem;
off_t lseek();

/*+-------------------------------------------------------------------------
	kinit(write_needed)
--------------------------------------------------------------------------*/
void
kinit(write_needed)
int		write_needed;
{
	if((fdkmem=open("/dev/kmem",(write_needed) ? O_RDWR : O_RDONLY,0)) < 0)
	{
		perror("can't open /dev/kmem");
		exit(1);
	}

}	/* end of kinit */

/*+-------------------------------------------------------------------------
	kread(caddr,kaddr,len)
--------------------------------------------------------------------------*/
void
kread(caddr,kaddr,len)
caddr_t caddr;
off_t kaddr;
off_t len;
{
char	s80[80];

	if((lseek(fdkmem,kaddr,0) < 0L) ||
	    (read(fdkmem,caddr,(unsigned)len) != len))
	{
		sprintf(s80,"/dev/kmem read addr %08lx len %08lx",kaddr,len);
		perror(s80);
		exit(1);
	}
}	/* end of kread */

/*+-------------------------------------------------------------------------
	kwrite(kaddr,caddr,len)
--------------------------------------------------------------------------*/
void
kwrite(kaddr,caddr,len)
off_t kaddr;
caddr_t caddr;
off_t len;
{
char	s80[80];

	if((lseek(fdkmem,kaddr,0) < 0L) ||
	    (write(fdkmem,caddr,(unsigned int)len) != (unsigned int)len))
	{
		sprintf(s80,"/dev/kmem write addr %08lx len %08lx",kaddr,len);
		perror(s80);
		exit(1);
	}
}	/* end of kwrite */

/* vi: set tabstop=4 shiftwidth=4: */
