/* CHK=0x98BA */
/*+-------------------------------------------------------------------------
	renice.c -- SCO Xenix V/286

  Defined functions:
	kread(caddr,kaddr,nbytes)
	kwrite(kaddr,caddr,nbytes)
	main(argc,argv)
	renice(pid,value)
	kinit()
	usage()

--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:10-27-1988-11:15-wht-use uxlst facilities to speed up program */
/*:10-26-1988-08:56-wht-fix it */
/*
 * This program was written by me, Mike "Ford" Ditto, and
 * I hereby release it into the public domain in the interest
 * of promoting the development of free, quality software
 * for the hackers and users of the world.
 *
 * Feel free to use, copy, modify, improve, and redistribute
 * this program, but keep in mind the spirit of this
 * contribution; always provide source, and always allow
 * free redistribution (shareware is fine with me).  If
 * you use a significant part of this code in a program of
 * yours, I would appreciate being given the appropriate
 * amount of credit.
 *				-=] Ford [=-
 *
 *
 *	Modifications
 *	3/3/88	Ported to Plexus Unix System V	pigs!haugj@rpp386.uucp
 *	3/3/88	Ported to SCO Xenix System V	jfh@rpp386.uucp
 *	10/26/88 SCO Xenix V/286 and BSD 4 syntax wht
 ************************************************************/

#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/proc.h>
#include <sys/var.h>
#include <a.out.h>
#include "uxlst.h"
#include "libuxlst.h"
#include "libkmem.h"

long lseek();
void perror();
void exit();

void kread();
void kwrite();

char buf[BUFSIZ];

int myuid;
int NPROC;
struct proc proctab;
struct var v;

void
usage()
{
	fprintf(stderr,"usage: renice <nice> pid ...\n");
	fprintf(stderr,"<nice> must be in range of -20 through 19\n");
	exit(-1);
}


/* change the nice value of process (value from 0 to 39) */
int
renice(pid,value)
int pid,value;
{
	register i;
	int oldnice;
	long kaddr;

	if(value > 39)
		value = 39;
	if(value < 0)
		value = 0;

	for (i=0 ; i<NPROC ; ++i)
	{
	    kaddr = procaddr + (i * sizeof(struct proc));
		kread((char *)&proctab,kaddr,(long)sizeof(proctab));
		if(proctab.p_pid == pid)
		{
			if(myuid && ((myuid != proctab.p_uid) || (value < proctab.p_nice)))
			{
				errno = EACCES;
				sprintf(buf,"%d",pid);
				perror(buf);
				return(1);
			}

			oldnice = proctab.p_nice;
			proctab.p_nice = value;

			kaddr = procaddr + (i * sizeof(struct proc))
			    + ((char *)&proctab.p_nice - (char *)&proctab),
			kwrite(kaddr,(char *)&proctab.p_nice,(long)sizeof(proctab.p_nice));
			printf("%d: old priority %d, new priority %d\n",
				pid,oldnice - 20,value - 20);
			return(0);
		}
	}

	printf("%d: no such process\n",pid);
	return(1);
}

main(argc,argv)
int argc;
char **argv;
{
int		status = 0;
int		pid;
int		value;
int		iargv;

	uxlst_read();
	kinit(1);
	kread((char *)&v,vaddr,(long)sizeof(v));
	NPROC = v.v_proc;
	myuid = getuid();
	setuid(myuid);

	if(argc < 3)
		usage();

	value = atoi(argv[1]);
	if(value < -20)
		usage();
	if(value > 19)
		usage();

	value += 20;

	for(iargv = 2; iargv < argc; iargv++)
	{
		pid = atoi(argv[iargv]);
		renice(pid,value);
	}

	exit(0);
}

/* vi: set tabstop=4 shiftwidth=4: */
