/* CHK=0xE9C1 */
/*+-------------------------------------------------------------------------
	uxlst.c -- utility xlist - fast access to kernel /dev/kmem offsets
--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:10-27-1988-10:58-wht-creation */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <a.out.h>

#define DEFINE_UXLST
#include "uxlst.h"

/*+-------------------------------------------------------------------------
	uxlst_write_error()
--------------------------------------------------------------------------*/
void
uxlst_write_error()
{
	perror(XENIX_UXLST);
	exit(1);
}	/* end of uxlst_write_error */

/*+-------------------------------------------------------------------------
	main(argc,argv,envp)
--------------------------------------------------------------------------*/
main(argc,argv,envp)
int		argc;
char	**argv;
char	**envp;
{
register int itmp;
register struct xlist *xx;
struct stat xstat;		/* /xenix status at uxlst run time */
int		fduxlst;
int		xlist_error = 0;
long	unique;
FILE	*kludge;

	xlist(XENIX_KERNEL,uxlst);

	xx = uxlst;
	while(xx->xl_name)
	{
		if(xx->xl_type == 0)
		{
			printf("%s: can't xlist (try _%s ?)\n",
				xx->xl_name,xx->xl_name);
			xlist_error = 1;
			continue;
		}
		printf("%s  type: %04x seg: %04x value: %08lx\n",
			xx->xl_name,
			xx->xl_type,
			xx->xl_seg,
			xx->xl_value);
		xx++;
	}

	if(xlist_error)
	{
		fprintf(stderr,"%s NOT produced\n",XENIX_UXLST);
		exit(1);
	}

	if((kludge = fopen(XENIX_UXLST,"w")) == NULL)	/* scratch/create */
		uxlst_write_error(-1);
	fclose(kludge);

	if((fduxlst = open(XENIX_UXLST,O_WRONLY,0)) < 0)
		uxlst_write_error(fduxlst);

	if(stat(XENIX_KERNEL,&xstat) < 0)
	{
		fputs("cannot stat ",stderr);
		perror(XENIX_KERNEL);
		exit(1);
	}

	if((itmp = write(fduxlst,&xstat,sizeof(xstat))) != sizeof(xstat))
		uxlst_write_error(itmp);

	if((itmp = write(fduxlst,uxlst,sizeof(uxlst))) != sizeof(uxlst))
		uxlst_write_error(itmp);

	unique = UXLST_UNIQUE;
	if((itmp = write(fduxlst,&unique,sizeof(unique))) != sizeof(unique))
		uxlst_write_error(itmp);

	close(fduxlst);
	exit(0);
}	/* end of main */

/* vi: set tabstop=4 shiftwidth=4: */
