/*
 * Yesterday -- print out yesterday's date.
 */

# ifndef LINT
static char rcsid[] = "$Header: yesterday.c,v 1.3 88/01/25 22:57:34 roy Exp $";
# endif

/*
 * $Log:	yesterday.c,v $
 * Revision 1.3  88/01/25  22:57:34  roy
 * Removed copyright notice; code placed in public domain.
 * 
 * Revision 1.2  86/12/09  17:40:44  roy
 * Fixed typo (prerror->perror) and added missing arguments to printf.
 * 
 */

# include <sys/time.h>
# define SEC_PER_DAY	(60*60*24)	/* Let's see them change this one! */

char *months[] =
{
	"Jan", "Feb", "Mar", "Apr", "May", "Jun",
	"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};

char *days[] =
{
	"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
};

main ()
{
	register struct tm *timebuf;
	struct timeval t;
	struct timezone tz;
	long yesterday;
	int status;

	status = 0;
	if ((status = gettimeofday (&t, &tz)) < 0)
	{
		perror ("yesterday: gettimeofday failed");
		yesterday = 0;
	}
	else
	{
		yesterday = t.tv_sec - SEC_PER_DAY;
	}

	timebuf = localtime (&yesterday);

	printf ("%s %s %2d 19%02d\n",	days[timebuf->tm_wday],
					months[timebuf->tm_mon],
					timebuf->tm_mday,
					timebuf->tm_year);
	exit (status);
}
