#++
# NAME
#	sysv.make 
# SUMMARY
#	makefile for opcom.
# AUTHOR(S)
#
#      C.G.S.M. Braam
#      Eindhoven University of Technology
#      Computing Centre
#      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
# CREATION DATE
#	Thu Jan  5 10:41:57 MET 1989
# LAST MODIFICATION
#	Tue Jan 17 13:15:28 MET 1989
# VERSION/RELEASE
#	1.3
#--

# System dependent variables

CC = cc
CDEFS = -DSYSV
CFLAGS = -O
LFLAGS = -h -Ml
BINDIR = /usr/local/bin
MANDIR = /usr/local/man

# End system dependent variables

CSOURCES = opcom.c
HFILES = sysdep
SHELLS = config
MAKEFILES = bsd.make sysv.make
OPSOURCES = $(CSOURCES) $(HFILES) $(SHELLS) $(MAKEFILES) README
USOURCES = detab.c srctoman
SOURCES = $(OPSOURCES) $(USOURCES)

all:	opcom

sysdep.h: sysdep config
	sh config sysdep >sysdep.h

man:	opcom.8

opcom.8: opcom.c config detab
	sh srctoman -L opcom.c | sh config >opcom.8

# Lint.

lint:	sysdep.h
	lint $(LFLAGS) $(CDEFS) opcom.c


detab: detab.c
	$(CC) $(CFLAGS) $(CDEFS) detab.c -o detab

opcom: opcom.c sysdep.h
	$(CC) $(CFLAGS) $(CDEFS) opcom.c -o opcom

# Installation and update.

install: opcom
	cp opcom $(BINDIR)
	cd $(BINDIR); chown root opcom; chmod u+s opcom

installman: man
	 cp opcom.8 $(MANDIR)/man8
	 rm -f $(MANDIR)/cat8/opcom.8

archive: $(OPSOURCES)
	archive $(OPSOURCES)

release: $(OPSOURCES)
	modsource +1 $(CSOURCES)
	modsource +2 $(CSOURCES)
	modsource +1 -c $(HFILES)
	modsource +2 -c $(HFILES)
	modsource +1 -mk $(MAKEFILES) README
	modsource +2 -mk $(MAKEFILES) README
	modsource +1 - $(SHELLS)
	modsource +2 - $(SHELLS)
	archive $(OPSOURCES)

version: $(OPSOURCES)
	modsource -1 $(CSOURCES)
	modsource -1 -c $(HFILES)
	modsource -1 -mk $(MAKEFILES) README
	modsource -1 - $(SHELLS)
	archive $(OPSOURCES)

shar:	$(SOURCES)
	rm -f Part?? Part??.Z
	makekit $(SUBDIRS) $(SOURCES) $(DIRENT)

clean:
	-rm -f *.BAK *.o opcom detab opcom.8 tmp.* sysdep.h \
	nohup.out core Part?? Part??.Z
