.TH NEWGETTY 8 
.SH NAME
newgetty \- baud rate detecting version of getty (and more)
.SH SYNTAX
.B "getty b"
.br
.B "getty <anything else>"
.SH DESCRIPTION
.I newgetty
is a front end to
.IR /etc/getty .
It assumes that the old system supplied getty is in
.IR /etc/lib/getty ; if the argument is anything other than
.B b
it calls that program with the argument.
.PP
If the argument is
.BR b ,
it trys to open
.IR /etc/default/getty ,
which must contain a line like:
.RS
prompt=Any string that you want to output
.RE
.PP
For example,
.RS
prompt=<b>bs or <u>nix
.RE
It will then wait for a character (with a timeout, currently of 3 seconds),
at which point it will change baud rates (currently 9600/2400/1200/300),
and try again.
.PP
Eventually it will get a character, which it will then try to find a
line for in
.IR /etc/default/getty .
This line should contain the name of the program or shell script to execute.
As an example:
.RS
.nf
prompt=<b>bs or <u>nix
b=/bbs/login
B=/bbs/login
u=/etc/login
U=/etc/login
x=/etc/login
X=/etc/login
.fi
.RE
.PP
.I Newgetty
is smart enough to set the uppercase flag if an uppercase letter comes in;
other than that it assumes a normal (return/newline exchange, etc) terminal.
It does not do as much checking as the standard getty, but it's only looking
at one character.
.PP
.I Newgetty
assumes a fairly standard stdio, and uses one nonportable call.
The routine
.IR finkey ()
returns a single character from a standard I/O FILE; it uses
.IR rdchk ()
to see if a character is available.
BSD users can substitute FIONREAD; pure System\-5 users will have to change
the terminal codes used anyways, so they can put the timeout codes in.
V7 should just forget this.
