/* @(#)newgetty.c	2.2 4/18/88 17:55:29 ( 4/18/88 17:33:01 ) */
/* New getty program. If called with an argument other than 'b', it invokes
	the old getty program (assumed to be at /etc/lib/getty), otherwise
	it reads the default file (/etc/defaults/getty) for 'prompt=',
	displays the result, reads a character, loops if non-ascii, checks
	the default file for <char>=, executes that program if found, otherwise
	loops. */

/* 0.4 Sys 3 mods: set echo, cooked */
/* Gave up on getting it to work with the sys3 structures. Will work fine
for BSD systems, or Xenix systems. If you are pure USG, either link for
version 7 mode (the kernel still has the version 7 stuff hidden inside
for compatibility), or convert it yourself.
*/

#include <ctype.h>
#include <stdio.h>
#include <sgtty.h>

/* 0.3 Does not actually pass arg to next program */
/* Will not work at 2400 */
#define SPEED	(term.sg_ispeed >= B1200 ? "3":"5")
#define fnsleep(x)  (3)	/* Return time for sleep */

char *defread(), *mkstr();
main(argc, argv)
char *argv[];
{
	int c;
	char *x;
	struct sgttyb term;
	if (argc != 2 || strcmp (argv[1], "b") != 0)
error:		execv ("/etc/lib/getty", argv);
	if (defopen("/etc/default/getty") != 0)
	{
		perror("new getty:");
		goto error;
	}
	ioctl (1, TIOCGETP, &term);  
	term.sg_ispeed = term.sg_ospeed = B9600;
	term.sg_flags |= CBREAK | ECHO | CRMOD;
	term.sg_flags &= ~RAW;
	ioctl (1, TIOCNXCL);
	for (;;)
	{
		ioctl (1, TIOCSETP, &term);
		puts ("\r");
		fputs(defread("prompt="), stdout);
		/* Flush input */
		while ((c=finkey(stdin)) != '\0' && c!= EOF)
			;
		sleep(fnsleep(term.sg_ispeed));
		if (isalpha(c=finkey(stdin)) && (x=defread(mkstr(c))) !=NULL)
		{
			putchar('\n');
			term.sg_flags = term.sg_flags &~ CBREAK;
			if (isupper(c))
				term.sg_flags |= LCASE;
			ioctl (1, TIOCSETP, &term);
			/* No more alarm clock */
			execlp (x, x, NULL);
	/* Speed is no longer passed */
			perror (x);
			term.sg_flags |= CBREAK;
		}
		term.sg_ispeed = term.sg_ospeed = nextspeed (term.sg_ispeed);
					/* Change speed & try again */
	}
}

char *mkstr(c)
char c;
{
	static char chr[]="x=";
	chr[0]=c;
	return chr;
}

nextspeed(oldspeed)
{
	switch (oldspeed)
	{	case B300: return B9600;
		case B1200: return B300;
		case B2400: return B1200;
		case B9600: return B2400;
	}
}

/* @(#)inkey.c	1.1 4/18/88 17:57:48 ( 10/2/86 18:51:54 ) */
# include <stdio.h>
inkey(fd)
int fd;
{
	char c;
	int temp;
	if (temp=rdchk(fd) > 0)
		if (read (fd, &c, 1) >0)
			return c;
		else return (char) -1;
	else return (temp == 0 ? 0 : -1);
}

finkey(fp)
FILE *fp;
{
	if ((fp->_cnt > 0) || rdchk(fileno(fp)) > 0)
		return getc (fp);
	if feof(fp)
		return EOF;
	return 0;
}
