/* whom.c */

/*----------------------------------------------------------------------
 *	whom	displays users in Magpie
 *
 *	Change WHOFILE (below) to point to 'Who' in Magpie directory
 *
 *	Author: Steve Manes
 *----------------------------------------------------------------------*/

#include <stdio.h>
#include <sys/types.h>
#include "fcntl.h"
#include <time.h>

#define	WHOFILE	"/bbs/Who"		/* Magpie directory/Who */
#define	ERROR	-1

/*----------------------------------------------------------------------
 *	Who Structure (WHO)
 *----------------------------------------------------------------------*/
typedef struct {
	char		name[21];
	char		from[25];
	char		dev[16];
	long int	time;
	char		action[21];
} WHOREC;

char	*ctime();

/*----------------------------------------------------------------------
 *	show Magpie 'WHO' file.
 *----------------------------------------------------------------------*/
main()
{
	WHOREC	who;
	int	fid, count = 0;
	struct	tm *TM;
		
	if ((fid = open(WHOFILE, O_RDONLY)) == ERROR) 
		exit(0);

	while (read(fid, &who, sizeof(WHOREC)) > 0) {
		TM = localtime(&who.time);
		if (who.name[0]) {
			if (count == 0)
				puts("\n+Online Now+");
			printf("%s from %s at %d:%02d on %s  (%s)\n", who.name,
			   who.from, TM->tm_hour, TM->tm_min, who.dev,
			   who.action);
			count++;
		}
	}
	close(fid);
	exit(0);
}
