#! /bin/sh
# This is a shell archive, meaning:
# 1. Remove everything above the #! /bin/sh line.
# 2. Save the resulting text in a file.
# 3. Execute the file with /bin/sh (not csh) to create the files:
#	README
#	Makefile
#	chat.c
#	getline.c
#	lockchat.c
#	misc.c
#	term.c
#	chat.h
# This archive created: Mon May  9 13:48:35 1988
export PATH; PATH=/bin:$PATH
if test -f 'README'
then
	echo shar: will not over-write existing file "'README'"
else
cat << \SHAR_EOF > 'README'



     CCCCHHHHAAAATTTT((((1111))))		   RRRRooooxxxxyyyy	RRRReeeeccccoooorrrrddddeeeerrrrssss ((((NNNNYYYYCCCC))))		       CCCCHHHHAAAATTTT((((1111))))



			     Magpie Multi-Chat v1.0
			copyright (c)1988 by Steve Manes
			      Roxy Recorders, Inc.
		       648 Broadway, New York, N.Y. 10012


			    I N	T R O D	U C T I	O N
			    -----------------------


	  Magpie Chat was developed as a multiuser chat	program	for
	  use with the Magpie/UNIX BBS program,	however	it will	also
	  work as a stand-alone	multiple-party chat.  While there are
	  several chat programs	available for Unix and Xenix, Magpie
	  Chat was written to provide a	more complete multiuser	chat
	  environment for dedicated chat call-in applications or for
	  sysops of *ix	BBSes that need	a secure and auditable real-
	  time chat program.  This isn't an enhanced "write" or
	  "phone" utility but a	full-featured, multiuser chat utility.


	  Features:

	  Chat logging.	 Chat messages are appended to a shared	data
	  file rather than written to the users' tty hardware.	This
	  method provides a ready log of all chat activity readable by
	  the local honcho and eliminates problems with	device
	  permissions.	Every 24 hours,	Chat archives the current
	  chatfile for later auditing or for disposal and starts a new
	  one.

	  Full word-wrap of text on both input and output for users of
	  any terminal width (32-132 columns).	By default, every user
	  is assumed to	be on an 80-column screen but this may be
	  changed either on the	command	line or	interactively through
	  Chat by the user.  The maximum size of a chat	message	is 2k,
	  although you can increase/decrease this by changing the
	  value	MAXCHAT	in 'chat.h'.

	  Input	editor with cursor control/line	editing.  The editor
	  supports the following control codes:

	  Ctrl-A  back word	   Ctrl-F  forward word
	  Ctrl-B  back character   Ctrl-D  forward character
	  Ctrl-X  cancel line	   Ctrl-R  retype line

	  Private user->user messaging within chat.

	  Shell	access.	 This feature may be blocked by	the local
	  honcho if Chat is loaded via an "intelligent"	script file.

	  Chat timer.  By default, all chatters	have unlimited time.



     Page 1					     (printed 1/17/88)






     CCCCHHHHAAAATTTT((((1111))))		   RRRRooooxxxxyyyy	RRRReeeeccccoooorrrrddddeeeerrrrssss ((((NNNNYYYYCCCC))))		       CCCCHHHHAAAATTTT((((1111))))



	  However, a user's time limit in any one invocation of	Chat
	  may be fixed by the aforementioned script file.

	  External chat	summoner.  Summons other shell users to	Chat.

	  Chat lock-out.  Chat can be disabled whenever	necessary by
	  the local honcho.
















































     Page 2					     (printed 1/17/88)






     CCCCHHHHAAAATTTT((((1111))))		   RRRRooooxxxxyyyy	RRRReeeeccccoooorrrrddddeeeerrrrssss ((((NNNNYYYYCCCC))))		       CCCCHHHHAAAATTTT((((1111))))



			    D I	S T R I	B U T I	O N
			    ------------------------


	  This program is a copyrighted	work owned by Steve Manes and
	  Roxy Recorders, Inc of New York, NY.	All commercial and
	  distribution rights are likewise reserved by Steve Manes.
	  You are permitted to compile and use this software free of
	  charge under the following conditions:

	  1.  Copyright	notices	and internal prompts and strings
	  including the	program	name and author's credit are NOT
	  modified in any way.

	  2.  Modifications to the source must NOT delete the original
	  code.	 Just #ifdef out the old code and add your
	  replacement.	Also, please add any comments about your
	  modification and, while you're at it,	your name.  You	might
	  as well take credit for the improvement.

	  3.  That this	source file is distributed with	all included
	  files, including README, in the original 'shar' format.

	  4.  That these files are distributed to others FREE OF
	  CHARGE.  Chat	source and its executable may NOT be included
	  in any package for which a charge of money or	exchange of
	  services is requested	or demanded.

	  In addition, if these	files are uploaded to any system which
	  claims an automatic copyright	claim over such	uploads	this
	  will in no way invalidate the	author's original copyright or
	  legal	ownership of his property.


			       T H E   P I T C H
			       -----------------

	  If you find the program of value and wish to encourage this
	  author of humble means to continue his selfless investment
	  of energy for	the Greater Good of user-supported software,
	  please don't hesitate	to express your	appreciation!

	  Suggested donation is	$15 or whatever	your conscience	and
	  Dunn and Bradstreet says it's	worth to you.  Please send to:

	  Steve	Manes
	  Roxy Recorders, Inc.
	  648 Broadway
	  New York, NY 10012






     Page 3					     (printed 1/17/88)






     CCCCHHHHAAAATTTT((((1111))))		   RRRRooooxxxxyyyy	RRRReeeeccccoooorrrrddddeeeerrrrssss ((((NNNNYYYYCCCC))))		       CCCCHHHHAAAATTTT((((1111))))



			       I N T E R N A L S
			       -----------------

	  Chat File

	  Chat processes do not	communicate with each other directly
	  but by means of a common, shared file.  When a chat message
	  is entered, it is saved at the bottom	of the current
	  chatfile, from which all other users are constantly polling
	  about	once a second.	Besides	providing enhanced auditing
	  and reducing inter-process messaging,	this allows chatfiles
	  to be	archived, edited or posted to a	BBS or similar
	  messaging system.

	  Chat automatically restarts a	new chatfile at	midnight.
	  Users	who have entered Chat before midnight will be
	  automatically	moved to the new chatfile.

	  Chatfiles are	created	as 'chatMMDD' where MM=month and
	  DD=day.  Since Chat sets all users to	the effective user
	  'bin', and the files are set for r/w owner exclusive,	only a
	  superuser has	read privileges	to chatfiles offline.

	  Login/logout information as well as the text of Private
	  messages between users is also included in the chatfiles.


	  The Chat Editor

	  Chat incorporates the	Magpie BBS message editor line input
	  function, getline().	Along with instext(), this provides a
	  full word-wrapping editor.  Partial text lines are
	  automatically	joined by reformat() on	output to chatfile.
	  The formatter	can also be forced to insert newlines by
	  preceding a line of text with	a '.' or a space for tabular
	  information.	This also allows a 40-column user to read
	  messages entered at 80-columns with formatting for his
	  terminal width.


	  Chat Command Line Arguments

	  The command line contains arguments to change	defaults
	  within Chat.	They are mostly	effective if Chat is called
	  from another program,	such as	a BBS script file, to force
	  the desired environment on selected users.  By default,
	  everyone has unlimited Chat time, a username equal to	their
	  LOGNAME, an 80-column	screen and shell privs.







     Page 4					     (printed 1/17/88)






     CCCCHHHHAAAATTTT((((1111))))		   RRRRooooxxxxyyyy	RRRReeeeccccoooorrrrddddeeeerrrrssss ((((NNNNYYYYCCCC))))		       CCCCHHHHAAAATTTT((((1111))))



	  -n"name" option

	  By default, Chat will	use the	user's LOGNAME for Chat.  The
	  -n switch overrides this.

	  Example:  chat -n"Mr.	Foo"


	  -tNN timer option

	  The -t argument will set the user's maximum allowable	time
	  to NN	minutes.  If you're running a BBS with a limited
	  number of lines and/or an enforced user timer	this feature
	  will be particularly welcome.	 Just pass Chat	the user's
	  remaining timer on the BBS and Chat will automatically abort
	  when the time	limit is reached.

	  Example:  chat -t30


	  -cNN option

	  By default, all users	will log into Chat with	80 column
	  terminal settings.  The -c option will change	this to	any
	  terminal width from 32 to 132	columns, all with full word-
	  wrap on input	and output.  (Note: the	chatfile is internally
	  formatted at 78 columns for easier offline reading.)


	  -x[list] option

	  By default, all users	have full access to the	menu of	Chat
	  options.  The	-x option will allow you to shut off most
	  commands from	the user (all except except <Q>uit and
	  SPACEBAR).  Again, on	a BBS you would	probably want to
	  prohibit users access	to the <!>shell	command	and, possibly,
	  the external pager.  Any commands blocked by -x will also
	  not appear in	the user's help	menu.

	  Example:  chat -x!s















     Page 5					     (printed 1/17/88)






     CCCCHHHHAAAATTTT((((1111))))		   RRRRooooxxxxyyyy	RRRReeeeccccoooorrrrddddeeeerrrrssss ((((NNNNYYYYCCCC))))		       CCCCHHHHAAAATTTT((((1111))))



		  C O M	P I L I	N G    I N F O R M A T I O N
		   ------------------------------------------


	  To allow all users to	read and write to the same file	and to
	  provide general chatfile security Chat set's the user's
	  effective ID to 'bin'.  Therefore, Chat must be compiled by
	  superuser, or	'root'.

	  Set up file defaults in "chat.h".

	  type 'make' and then 'make install'


				    B U	G S
				    -------


	  Chat is fairly vanilla but it	has only been tested under
	  Microport Unix and SCO Xenix.	 If you	encounter any problems
	  with Chat under other	flavors	of *nix, and particularly if
	  you've got a fix, I would appreciate it if you would drop me
	  a line at any	of the below addresses (particularly Magpie-HQ
	  or UUCP).

	  If you have troubles compiling or running Chat you'll
	  probably find	your trouble in	either the 'lockchat.c'	record
	  locking/unlocking routines or	in the way your	system handles
	  signal() interrupts.	Unfortunately, the only	fix I can
	  suggest is to	find a guru for	your particular	flavor of *ix.

	  If your users	are prolific chatters, keep an eye on your
	  Chatfile directory.  A large multiuser system	can accumulate
	  a megabyte or	more of	chat per day!



	  Enjoy	-- Steve Manes


	  Magpie-HQ: (212)420-0527
	  UUCP:	     !{inhp4|uunet}!{pur-ee|iuvax}!bsu-cs!zoo-hq!manes
	  SmartMail: manes@magpie.MASA.COM












     Page 6					     (printed 1/17/88)



SHAR_EOF
fi # end of overwriting check
if test -f 'Makefile'
then
	echo shar: will not over-write existing file "'Makefile'"
else
cat << \SHAR_EOF > 'Makefile'
# @(#)	makefile for Magpie chat
#	by Steve Manes, Roxy Recorders, NYC
#
# Destination directory  -- should be a public directory
DESTDIR=/usr/lbin

# Owner and Group
OWNER=bbs
GROUP=bin

# Compiler flags
# If your compiler support the 'index' function rather than 'strchr'
# add '-DINDEX' to CFLAGS
# If your compiler doesn't support a 'void' type
# add '-DNOVOID' to CFLAGS
#
CFLAGS = -s

# this compile's for Xenix (comment out next line for SVR2)
OARG = -o chat -lx
# this one's for SVR2
# OARG = -o chat

CHATOBJ =	chat.o getline.o misc.o term.o lockchat.o

CHATSRC = 	chat.c getline.c misc.c term.c lockchat.c

all:	$(CHATOBJ)
	cc $(CFLAGS) $(CHATOBJ) $(OARG)

# must be run by 'root'
install:
	mv chat ${DESTDIR}
	chown ${OWNER} ${DESTDIR}/chat
	chgrp ${GROUP} ${DESTDIR}/chat
	chmod ug+s ${DESTDIR}/chat

SHAR_EOF
fi # end of overwriting check
if test -f 'chat.c'
then
	echo shar: will not over-write existing file "'chat.c'"
else
cat << \SHAR_EOF > 'chat.c'
/* @(#)	chat.c		-- Magpie Chat
 *
 *	Multi-chat program for Unix
 *	Copyright 1988	All Rights Reserved
 *	Steve Manes, Roxy Recorders, Inc., 648 Broadway, New York, NY 10012
 *	
 *	Originally developed as a multiuser chat facility for
 *	Magpie/UNIX BBS.
 *
 *	Args:
 *	-n"chat name"		chatter's handle (default: system uid)
 *	-tnn			time limit in minutes (default, no limit)
 *	-wnn			terminal width (default: 80 columns)
 *	-x[list]		chat commands to block from user (like !)
 *
 */

#include "chat.h"
#include <sys/stat.h>

WHOREC	my;

char	*prog = "\nMagpie MultiChat v1.0  by Steve Manes (c)1988\n\
-- Type '?' for help --";

int	mywidth = 80;			/* user's default terminal width */
struct	termio savterm, myterm;		/* terminal structure */
int	Chatfid;			/* chat file handle */
long	Chatpos;			/* chat file 'last-read' position */
int	Lockflag;			/* used by reqlock() */
long	TimesUp = -1;			/* user's chat time limit */
int	Today;				/* today's day */
char	workbuf[MAXLINE +1];		/* miscellaneous buffer */
char	ignore[10];			/* command keys to ignore */
char	*buff, *tail;			/* message input buffer */
char	*menu[] = {
	"\n\n",
	"------------------------------",
	"--        Chat Help         --",
	"------------------------------",
	"C         columns",
	"L         list logged-in users",
	"P         private to user",
	"Q         quit chat",
	"S         shell pager",
	"T         time left",		
	"W         who's in chat",
	"SPACEBAR  enter chat message",
	"?         help",
	"!         shell command",
	""
};
char	*use = "usage: -n\"user name\" -w[term width] -t[timer] -x[list]\n";

main(argc, argv)
char	*argv[];
{
	char	*cp;
	struct	stat Stat;
		
	/* check for chat-closed */
	if (stat(NOCHATFILE, &Stat) == SUCCESS) {
		puts("\nSorry -- chat unavailable now\n");
		exit(1);
	}
	/* set up CWHO defaults */
	strcpy(my.name, cuserid( (char *) 0) );
	strcpy(my.tty, ttyname(TTYIN));
	time(&my.login);
	ignore[0] = '\0';			/* all commands enabled */
	
	/* get args */
	while (--argc) {
		cp = *++argv;
		if (*cp++ == '-') {
			switch (*cp++) {

			case 'n':	/* chat name */
			strcpy(my.name, cp);
			break;
					
			case 'w':	/* user width */
			mywidth = atoi(cp);
			break;
				
			case 't':	/* time limit */
			TimesUp = my.login + (long)(atol(cp) * 60);
			break;
			
			case 'x':	/* ignore commands */
			strcpy(ignore, cp);
			break;
			
			default:	/* switch error */
			puts(use);
			exit(1);
			}
		}
	}			
	if (mywidth < 32)	mywidth = 32;
	if (mywidth > 132)	mywidth = 132;
	strupr(ignore);
		
	/* allocate buffer space */
	if (!(buff = (char *)malloc(BUFSIZE +100))) {
		puts("malloc error");
		exit(1);
	}
	/* open or create chat file */
	if (openchat() != SUCCESS) {
		free(buff);
		exit(1);
	}
	strupr(my.name);
	setterm();
	puts(prog);			/* show the ad */
	whozon();			/* display WHO file */
	if (addwho(&my) != SUCCESS) 	/* add name to CWHO */
		quit();
	signin();
	chat();
	quit();
}

/*----------------------------------------------------------------------
 *	chat()
 *	main routine for chat
 *	returns: ERROR (log out) or SUCCESS
 *----------------------------------------------------------------------*/
int	chat()
{
	long	ltime;
	struct	tm *TM;
	static	int warned;
				
	while (TRUE) {
		/* if user has a timer, check time left */
		if (TimesUp > -1) {
			time(&ltime);
			if (!warned && (ltime + 120) > TimesUp) {
				puts("\n** 2 minutes left **\n");
				warned = TRUE;
			}
			if (ltime > TimesUp) {
				puts("\n** Sorry, chat timer has expired **\n");
				quit();
			}
		}
		if (getcmd() == ERROR)		/* get a chat command */
			break;
		while (readchat() != ERROR)	/* display any chat waiting */
			;
	}
}

/*----------------------------------------------------------------------
 *	signin()
 *	logs user to chat
 *	returns: nothing
 *----------------------------------------------------------------------*/
void	signin()
{
	sprintf(workbuf, "%cIn ==> %s at %s", MSG, my.name, 
	   chattime(&my.login));
	append(workbuf, TRUE);
	Chatpos = lseek(Chatfid, 0L, 2);	/* set end-of-file */
}

/*----------------------------------------------------------------------
 *	openchat()
 *	composes chatfile name "CHATmm.dd" where 'mm' and 'dd' are
 *	today's month and day. 
 *	returns: ERROR or SUCCESS
 *----------------------------------------------------------------------*/
int	openchat()
{
	struct	tm *TM;
	char	chatfile[MAXPATH +1];		/* chat filename */
	long	ltime;
	
	time(&ltime);				/* set time now */
	TM = localtime(&ltime);			/* get structure */
	sprintf(chatfile, "%s%02d%02d", CHATFILE, TM->tm_mon +1, TM->tm_mday);
	if ((Chatfid = open(chatfile, O_RDWR | O_CREAT, 0x1b0)) == ERROR) {
		printf("Can't open %s\n", chatfile);
		return(ERROR);
	}
	Today = TM->tm_mday;
	return(SUCCESS);
}

/*----------------------------------------------------------------------
 *	quit()
 *	branches here to clean up and leave program
 *	returns: nothing
 *----------------------------------------------------------------------*/
void	quit()
{
	long	ltime;
	
	time(&ltime);
	sprintf(workbuf, "%cOut => %s at %s", MSG, my.name, 
	   chattime(&ltime));
	append(workbuf);
	unlock();
	close(Chatfid);
	ioctl(TTYIN, TCSETA, &savterm);
	killwho(&my);
	free(buff);
	exit(0);		
}

/*----------------------------------------------------------------------
 *	setterm()
 *	sets initial terminal and signal() defaults
 *	returns: ERROR OR SUCCESS
 *----------------------------------------------------------------------*/
int	setterm()
{
	ioctl(TTYIN, TCGETA, &savterm);		/* save current terminal */
	ioctl(TTYIN, TCGETA, &myterm);		/* working terminal */
	myterm.c_iflag = (IGNPAR | IGNBRK | ISTRIP | IXON | IXOFF);	
	myterm.c_lflag &= ~(ICANON | ECHO);
	myterm.c_cc[VMIN] = 1;
	myterm.c_cc[VTIME] = 0;
	myterm.c_cc[VINTR] = 255;	/* disable Ctrl-D for the editor */
	myterm.c_cc[VQUIT] = 255;	/* disable Ctrl-C .. use <Q>uit */
	if (ioctl(TTYIN, TCSETA, &myterm) == ERROR) {
		puts("Can't set terminal");
		return(ERROR);
	}
	setsigs();
	return(SUCCESS);
}

/*----------------------------------------------------------------------
 *	setsigs()
 *	set default signals
 *	returns: nothing
 *----------------------------------------------------------------------*/
void	setsigs()
{
	signal(SIGQUIT, quit);		/* exit */
	signal(SIGINT, 	quit);
	signal(SIGHUP, 	quit);	
	signal(SIGTERM, quit);
}

/*----------------------------------------------------------------------
 *	append(buff)
 *	write 'buff' to Chatfid.
 *	returns: nothing
 *----------------------------------------------------------------------*/
void	append(buff)
char	*buff;
{
	char	spec[3];
		
	if (reqlock() == ERROR)		/* get lock and set lseek to EOF */
		return;
	if (write(Chatfid, buff, strlen(buff)) == ERROR)
		puts("\n** File append error");
	write(Chatfid, "\n\n", 2);	/* append two newlines */
	unlock();
}

/*----------------------------------------------------------------------
 *	help()
 *	display help
 *	returns: nothing
 *----------------------------------------------------------------------*/
void	help()
{
	int	i;
		
	for (i=0; *menu[i]; i++) {
		if (!strchr(ignore, menu[i][0]))	/* command enabled? */
			printf("%s\n", menu[i]);	/* yes, print it */
	}			
	putchar('\n');
}

/*----------------------------------------------------------------------
 *	addwho(rec)
 *	add CWHO record
 *	file is self-maintaining
 *	returns: ERROR or SUCCESS
 *----------------------------------------------------------------------*/
int	addwho(rec)
WHOREC	*rec;
{
	WHOREC	who;
	long	offset;
	int	fid, rc;
	
	if ((fid = open(WHOFILE, O_RDWR | O_CREAT, 0x1b4)) == ERROR) {
		printf("Can't open %s", WHOFILE);
		return(ERROR);
	}

	/* find a deleted WHOREC slot and re-use it, else append new record */
	offset = 0;
	while (read(fid, &who, sizeof(WHOREC)) == sizeof(WHOREC)) {	
		if (who.name[0] == 0)
			break;
		offset += (long)sizeof(WHOREC);
	}
	lseek(fid, offset, 0);
	rc = write(fid, rec, sizeof(WHOREC));
	close(fid);
	if (rc == ERROR)
		printf("\nError adding name to %s", WHOFILE);
	return((rc == ERROR) ? ERROR : SUCCESS);
}

/*----------------------------------------------------------------------
 *	killwho(rec)
 *	remove CWHO record
 *	returns: nothing
 *----------------------------------------------------------------------*/
void	killwho(rec)
WHOREC	*rec;
{
	WHOREC	who;
	long	offset;
	int	fid;
	
	if ((fid = open(WHOFILE, O_RDWR)) == ERROR)
		return;

	/* find match on rec->tty and who.tty */
	offset = 0;
	
	while (read(fid, &who, sizeof(WHOREC)) == sizeof(WHOREC)) {	
		if (!strcmp(who.tty, rec->tty)) {
			strinit(&who, sizeof(WHOREC));
			lseek(fid, offset, 0);
			write(fid, &who, sizeof(WHOREC));
			break;
		}
		offset += (long)sizeof(WHOREC);
	}
	close(fid);
}

/*----------------------------------------------------------------------
 *	whozon()
 *	display CWHO file
 *	returns: nothing
 *----------------------------------------------------------------------*/
void	whozon()
{
	int	fid, users = 0;
	WHOREC	who;
	
	if ((fid = open(WHOFILE, O_RDONLY)) != ERROR) {
		while (read(fid, &who, sizeof(WHOREC)) == sizeof(WHOREC)) {
			if (who.name[0]) {
				if (!users)	puts("\nOthers in Chat:");
				printf("%-30s%-15s%s\n", who.name, who.tty,
					chattime(&who.login));
				users++;
			}
		}
		close(fid);
	}
	if (!users)	puts("\n[Nobody in Chat]");
}

/*----------------------------------------------------------------------
 *	chattime(ltime)
 *	returns: pointer to formatted time string for 'ltime'
 *----------------------------------------------------------------------*/
char	*chattime(ltime)
long	*ltime;
{
	struct	tm *TM;
	static	char	tbuff[8];
	int	hour, min, pm;
	
	TM = localtime(ltime);
	hour = TM->tm_hour;
	min = TM->tm_min;
	pm = (hour > 11);
	if (pm)
		hour -= 12;
	if (hour == 0)
		hour = 12;
	sprintf(tbuff, "%d:%02d%s", hour, min, pm ? "pm" : "am");
	return(tbuff);
}

/*----------------------------------------------------------------------
 *	instext()
 *	get and insert a line of text into 'buff'
 *	returns: nothing
 *----------------------------------------------------------------------*/
void	instext()
{
	char	combuf[MAXLINE +1];
	int	i, eol, len, width, bufflen;
	
	bufflen = strlen(buff);
	tail = (char *)(buff + bufflen);
	*tail = '\0';
	width = mywidth -4;
	len = 0;
	strinit(combuf, MAXLINE +1);

	/* get text entry */
	while (TRUE) {
		/* check for potential overflow */
		if ((tail - buff) > (MAXCHAT - MAXLINE)) {
			puts("\n**Buffer full**");
			break;
		}
		printf("> ");				/* prompt */
		if (!(len = getline(combuf, width))) {	/* get a line */
			backspace();			/* erase the prompt */
			backspace();
			putchar('\n');
			break;
		}
		eol = len;
		workbuf[0] = '\0';
						
		/* see if line fold needed */
		if (len >= width && combuf[len-1] > ' ') {
			for (; len && combuf[len] != ' '; len--)
				; 
			if (!len)	len = eol;
			strcpy(workbuf, (char *)(combuf+len+1));
		}
		else 	for (; len && combuf[len-1] <= ' '; combuf[len--] = 0)
				;
		combuf[len] = '\n';
		combuf[len+1] = '\0';
		
		/* at this point, trimmed line with terminating '\n' 
		   is in 'combuf' and any overage is in 'workbuf'.
		   'combuf[len]' is pointing to the terminating '\n'
		*/
		strcpy(tail, combuf);		/* copy to buffer */
		tail += (len +1);
		*tail = '\0';
		strinit(combuf, MAXLINE +1);
			
		/* check for line fold on display */
		if (workbuf[0]) {
			for (i=strlen(workbuf); i; i--)	/* erase tail */
				backspace();
			strcpy(combuf, workbuf);
		}
		putchar('\n');
	}
	if ((tail-buff) == bufflen)		/* no text */
		return;
	*(tail -1) = '\0';			/* remove trailing newline */
	reformat(buff, 78);			/* reformat buffer */
	append(buff, FALSE);			/* write to chatfile */
}
		
/*----------------------------------------------------------------------
 *	readchat()
 *	reads any text present into 'buff' and formats it for the user's
 *	terminal width
 *	returns: ERROR or SUCCESS
 *----------------------------------------------------------------------*/
int	readchat()
{
	long	fpos, ltime;
	int	size;
	char	*p;
	struct	tm *TM;
			
	fpos = lseek(Chatfid, 0L, 2);		/* get current eof */
	if (fpos <= Chatpos)			/* nothing to read */
		return(ERROR);

	lseek(Chatfid, Chatpos, 0);		/* get last-read position */
	size = read(Chatfid, buff, BUFSIZE);	/* fill the buffer */
	buff[size] = '\0';

	/* move backwards through buffer to get last "\n\n" pair,
	   stick a NULL after it and reset Chatpos
	*/
	while (size && buff[size] != '\n' && buff[size-1] != '\n') 
		size--;

	buff[size+1] = '\0';
	Chatpos += (long)size;			/* correct file position */

	reformat(buff, mywidth -1);		/* format for user's terminal */
	p = buff;
	while (*p) {				/* dump the buffer */
		if (*p > YELL) 
			putchar(*p);
		else if (*p == YELL)
			p = yell(++p);
		p++;
	}
	
	/* Tricky here... check the date to make sure the day hasn't
	   rolled over.  If so, folks logging on after midnight will be
	   reading/writing to another chatfile.  If date rollover,
	   switch to new chat file.
	*/
	time(&ltime);			/* check the day */
	TM = localtime(&ltime);		/* time to switch chatfile? */
	if (TM->tm_mday != Today) {	/* start new chat file */
		puts("\n** Day rollover: Switching chat files");
		puts("(Some pending discussion may be lost)");
		close(Chatfid);
		if (openchat() != SUCCESS) {
			puts("\n** Internal error **");
			quit();
		}
		signin();
	}
	return(SUCCESS);
}

/*----------------------------------------------------------------------
 *	getcmd()
 *	gets a command key
 *	waits 1 second for input, then breaks
 *	else, checks for valid command.
 *	returns: ERROR (quit program) or SUCCESS
 *----------------------------------------------------------------------*/
int	getcmd()
{
	char	c, *user;
	long	ltime;
		
	signal(SIGALRM, gotit);		/* set up timeout */
	alarm(1);
	c = toupper(getchar() & 0x7f);	/* grab 7-bit character */
	alarm(0);
	if (c != 'Q' && strchr(ignore, c))
		return(SUCCESS);
	switch (c) {
	
		case 'C':	/* set terminal width */
		getwidth();
		break;
		
		case 'W':	/* who's on */
		whozon();
		break;
		
		case ' ':	/* write a chat message */
		sprintf(buff, "%s:  ", my.name);
		instext();
		break;

		case 'P':	/* User->user private chat message */
		if (!(user = finduser()))
			break;
		sprintf(buff, "%c%s%c**Private from %s:  ", YELL, user, 
		   MSG, my.name);
		instext();
		break;
		
		case 'Q':	/* exit chat */
		return(ERROR);
			
		case '?':	/* help */
		help();
		break;

		case 'T':	/* timer */
		time(&ltime);
		printf("Time now:   %s\n", chattime(&ltime));
		printf("Time on:    %ld:%02ld\n", (ltime-my.login) /60,
			(ltime-my.login) %60);
		if (TimesUp > -1) 
			printf("Time left:  %ld:%02ld\n",
			   (TimesUp-ltime) /60, (TimesUp-ltime) %60);
		break;
		
		case 'L':	/* list logged-in users */
		shpager(FALSE);
		break;
		
		case 'S':	/* page logged in user via /dev/? */
		shpager(TRUE);
		break;
		
		case '!':
		strinit(workbuf, 81);
		printf("sh command: ");
		if (getline(workbuf, 80)) {
			putchar('\n');
			if (chexec(workbuf) == 127)
				puts("\nsh error");
			else {
				printf("\n*Hit any key*");
				getchar();
			}
		}
		putchar('\n');
		break;
	}
	return(SUCCESS);
}

/*----------------------------------------------------------------------
 *	gotit()
 *	branches here on timeout above
 *	returns: nothing
 *----------------------------------------------------------------------*/
void	gotit()
{
	return;
}

/*----------------------------------------------------------------------
 *	chexec(arg)
 *	execute a shell command
 *	returns:  execl status
 *----------------------------------------------------------------------*/
int	chexec(arg)
char	*arg;
{
	int	pid, rc, wrc;

	if ((pid = fork()) == 0) {
		setuid(getuid());
		execl("/bin/sh", "sh", "-c", arg, 0);
		_exit(127);
	}
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	signal(SIGHUP, SIG_IGN);
	while ((wrc = wait(&rc)) != pid && wrc != -1)
		;
	setsigs();
	return(rc);
}
	
SHAR_EOF
fi # end of overwriting check
if test -f 'getline.c'
then
	echo shar: will not over-write existing file "'getline.c'"
else
cat << \SHAR_EOF > 'getline.c'
#include <stdio.h>
#include <ctype.h>

#define EOL     0
#define FALSE   0
#define TRUE    1
#define BEL     7
#define BS      '\b'
#define TAB     9
#define CR      13
#define LF      10
#define ESC     27
#define SPACE   ' '
#define DEL     127
#define TABLEN  8
#define ONESEC  18L

void	backspace();

/*--------------------------------------------------------------------------
 *  getline( buff, maxlen )
 *
 *  buff:       input buffer
 *  maxlen:     maximum characters
 *-------------------------------------------------------------------------*/
int	getline(buff, maxlen)
char	buff[];
int	maxlen;
{
	int	curs, i;
	char	c;
	
	if (*buff)
		printf("%s", buff);	/* display anything in buffer */
	curs = strlen(buff);		/*  and advance 'curs' */

	while (curs <= maxlen) {
		c = getchar() & 0x7f;
		if (c >= SPACE && c != DEL) {	/* printable character */
			buff[curs++] = c;	/* overwrite/insert character */
			putchar(c);
			continue;
		}

		switch (c) {			/* special character received */

		case CR:			/* done */
		return(strlen(buff));		/* return buffer length */

		case 'H'-64:		/* backspace */
		case DEL:		/* or delete */
		if (!curs)     
			break;		/* beginning of line... ignore */
		if (!buff[curs]) {	/* backspace at end of line */
			backspace();	/* display destructive BS */
			buff[--curs] = '\0';	/* zap the buffer character */
			break;
		}
		putchar(BS);		/* cursor left */
		curs--;			/*.. then fall through to next
                                                   'case'.. */

		case 'G'-64:	/* delete in-line */
		if (buff[curs]) {			/* inside a line? */
			strcpy(buff, buff+1);		/* shift buffer left */
			for (i=curs; buff[i]; i++)	/* display it */
				putchar(buff[i]);
			putchar(SPACE);			/* zap trailing char */
			for (; i >= curs; i--)		/* return cursor */
				putchar(BS);
		}
		break;

		case 'D'-64:	/* cursor right */
		if (buff[curs])			/* if not at right column... */
			putchar(buff[curs++]);	/* move to character-right */
		break;

		case 'B'-64:	/* cursor left */
		if (curs) {			/* if not at left column... */
			putchar(BS);		/* cursor left */
			curs--;			/* mark postion */
		}
		break;

		case 'A'-64:		/* word left */
		if (curs) {			/* if not at left column... */
			do			/* move left through any */
				putchar(BS);	/*  whitespace */
			while (curs && buff[--curs] <= SPACE)
				;
			while (curs && buff[curs-1] > SPACE) {
				putchar(BS);  /* move left through text */
				curs--;
			}      
		}
		break;

		case 'F'-64:	/* word right */
		if (buff[curs]) {		/* if not at right column... */
			while (buff[curs] > SPACE)
				putchar(buff[curs++]);	/* show char-right */
			while (buff[curs] == SPACE)	/* move through SPACEs */
				putchar(buff[curs++]);
		}
		break;

		case 'X'-64:	/* delete line */
		while (buff[curs]) {	/* delete characters-right */
			putchar(SPACE);
			curs++;
		}
		while (curs) {		/* delete to beginning of line */
			backspace();
			buff[curs--] = '\0';
		}
		curs = 0;
		buff[curs] = '\0';
		break;

		case 'R'-64:	/* retype line */
		printf("\n> ");
		for (curs=0; buff[curs]; curs++)	/* retype the buffer */
			putchar(buff[curs]);
		break;

		case TAB:	/* expand tab to SPACEs */
		while (curs < maxlen) {		/* don't expand beyond maxlen */
			buff[curs++] = SPACE;	/* insert a space */
			putchar(SPACE);		/* show it */
			if ( !(curs % TABLEN) ) /* and break if at tabstop */
				break;
		}
		break;
	}
	}
	return (strlen(buff));
}

/*----------------------------------------------------------------------
 *	backspace()
 *	prints destructive backspace
 *	returns: nothing
 *----------------------------------------------------------------------*/
void	backspace()
{
	putchar('\b');
	putchar(' ');
	putchar('\b');
}
SHAR_EOF
fi # end of overwriting check
if test -f 'lockchat.c'
then
	echo shar: will not over-write existing file "'lockchat.c'"
else
cat << \SHAR_EOF > 'lockchat.c'
/*	lockchat.c	-- record locking functions for Magpie chat */

#include "chat.h"
#include <sys/locking.h>

#define	MAXTRY	10

/*----------------------------------------------------------------------
 *	lockf(fid, func, size)
 *
 *	Replacement for SVR2 lockf(), which doesn't work correctly
 *	in some versions of Unix and in Xenix.
 *----------------------------------------------------------------------*/
int	lockf(fid, func, size) 
int 	fid, func; 
long	size;
{ 
       switch (func) { 
               case F_ULOCK:   return( locking(fid, LK_UNLCK, size) ); 
               case F_LOCK:    return( locking(fid, LK_LOCK,  size) ); 
               case F_TLOCK:   return( locking(fid, LK_NBLCK, size) ); 
               default:        return(ERROR); 
       } 
} 

/*----------------------------------------------------------------------
 *	reqlock()
 *	locks chat file for end-of-file write
 *	returns: ERROR or SUCCESS
 *----------------------------------------------------------------------*/
int	reqlock()
{
	long	fpos;
	int	tries;
	
	fpos = lseek(Chatfid, 0L, 2);	/* mark current file pos */
	lseek(Chatfid, 0L, 0);		/* move to BOF and lock */
	signal(SIGHUP,	unlock);	/* if hang up, assure unlock */
	
	Lockflag = TRUE;
	tries = 0;
	while (lockf(Chatfid, F_TLOCK, 0L) == ERROR) { 
		if (tries++ == MAXTRY) {
			puts("Can't acquire file lock");
			Lockflag = FALSE;
			break;
		}
		sleep(2);
		puts("Awaiting lock");
	}
	lseek(Chatfid, fpos, 0);		/* restore file pos */
	setsigs();
	return( (Lockflag == TRUE) ? SUCCESS : ERROR);
}

/*----------------------------------------------------------------------
 *	unlock()
 *	unlock chatfile
 *	returns: nothing
 *----------------------------------------------------------------------*/
void	unlock()
{
	long	fpos;
	
	if (Lockflag == TRUE) {
		fpos = lseek(Chatfid, 0L, 2);	/* save current file pos */
		lseek(Chatfid, 0L, 0);		/* set to BOF for unlock */
		signal(SIGHUP,	SIG_IGN);
		lockf(Chatfid, F_ULOCK, 0L);
		lseek(Chatfid, fpos, 0);	/* restore file pos */
		Lockflag = FALSE;
	}
	setsigs();
}

SHAR_EOF
fi # end of overwriting check
if test -f 'misc.c'
then
	echo shar: will not over-write existing file "'misc.c'"
else
cat << \SHAR_EOF > 'misc.c'
/*	misc.c		-- miscellaneous routines for Magpie 'chat' */

#include "chat.h"

/*----------------------------------------------------------------------
 *	finduser()
 *	asks for username and checks WHO for match
 *	returns: username or NULL
 *----------------------------------------------------------------------*/
char	*finduser()
{
	int	fid;
	WHOREC	who;
	
	printf("\nPrivate message to: ");	/* get username */
	strinit(workbuf, MAXNAME +1);		/* for getline() */
	if (!getline(workbuf, MAXNAME))	{
		putchar('\n');
		return( (char *)0 );
	}
	putchar('\n');
	strupr(workbuf);			/* name -> uppercase */
	
	if ((fid = open(WHOFILE, O_RDONLY)) == ERROR)
		return( (char *)0 );
	while (read(fid, &who, sizeof(WHOREC)) == sizeof(WHOREC)) {
		if (!strcmp(who.name, workbuf))
			return(workbuf);
	}
	puts("\nUser not in chat");
	return( (char *)0 );
}

/*----------------------------------------------------------------------
 *	strupr(s)
 *	converts string to uppercase
 *	returns: pointer to string
 *----------------------------------------------------------------------*/
char	*strupr(s)
char	*s;
{
	char	*p;
	
	for (p=s; *p; p++)
		*p = toupper(*p);
	return(s);
}

/*----------------------------------------------------------------------
 *	strinit(s, len)
 *	null out a string, s', to length, 'len'.
 *	returns: nothing
 *----------------------------------------------------------------------*/
void	strinit(s, len)
char	*s;
int	len;
{
	while (len--)
		*s++ = '\0';
}

/*----------------------------------------------------------------------
 *	yell(p)
 *	private message
 *	checks who.name against addressee name at 'p'
 *	and prints private message, if successful.
 *	returns: (char *) new read position
 *----------------------------------------------------------------------*/
char	*yell(p)
char	*p;
{
	char	*me;
	
	me = my.name;
	while (*p != MSG) {
		if (*me++ != *p++) {	/* match failed */
			while ( !(*p == '\n' && *(p-1) == '\n') )
				p++;
			return(++p);
		}
	}
	
	/* match successful */
	while (*p != '\n' && *(p-1) != '\n') {
		p++;
		putchar(*p);
	}
	return(p);
}
		
/*----------------------------------------------------------------------
 *	getwidth()
 *	sets user's terminal width
 *	returns: nothing
 *----------------------------------------------------------------------*/
void	getwidth()
{
	int	n;
	
	printf("\nNew terminal width: ");
	strinit(workbuf, 5);
	if (getline(workbuf, 4)) {
		n = atoi(workbuf);
		if (n >= 32 && n <= 132)
			mywidth = n;
	}
	putchar('\n');
}

/*----------------------------------------------------------------------
 *	reformat(buff, winsize)
 *	reformats 'buff' for user's window width
 *	returns: nothing
 *----------------------------------------------------------------------*/
void	reformat(buff, width)
char	*buff;
int	width;
{       
	extern  char *tail;
	char  	*c, *lastbrk, *lastspace;

	c = lastspace = lastbrk = buff;
	while (*c == '\n')		/* preserve leading newlines */
		c++;
	while (*c) {
		if (*c == '\n') {	/* check for newline */
			if (*(c+1)=='\n' || *(c+1)=='.' || *(c-1)=='\n'||
			    *(c+1)==' ') {
				lastbrk = c++;
				continue;
			}
			*c = ' ';
		}
		if (*c == ' ')		/* check for line break */
			lastspace = c;
					/* check for wrap... */
					/* if no break space, chop up line */
		if (c >= (lastbrk + width -1)) {    
			if (lastspace <= lastbrk)  
				lastspace = c;
			*lastspace = '\n';	/* add a newline */
			lastbrk = ++lastspace;
			c++;
			continue;
		}
		c++;
	}
	tail = c;				/* reset end-of-buffer addr */
}

SHAR_EOF
fi # end of overwriting check
if test -f 'term.c'
then
	echo shar: will not over-write existing file "'term.c'"
else
cat << \SHAR_EOF > 'term.c'
/*	device.c		-- Magpie chat functions	*/

#include "chat.h"
#include <utmp.h>

/*----------------------------------------------------------------------
 *	shpager(call)
 *	shows system on-line
 *	if 'call', send chat summons
 *	returns: nothing
 *----------------------------------------------------------------------*/
void	shpager(call)
int	call;
{
	struct	utmp UT;
	char	dev[20][12];		/* device address */
	int	fid, i=0, n;
	FILE	*fp;
		
	if ((fid = open(UTMPFILE, O_RDONLY)) == ERROR) {
		printf("\nCan't open %s", UTMPFILE);
		return;
	}
	puts("\n\nSystem Users\n------ -----");

	while (i < 20 && read(fid, &UT, sizeof(UT)) == sizeof(UT)) {
		if (UT.ut_line[0] && UT.ut_name[0] &&
		    strncmp(UT.ut_name, "LOGIN", 5)) {
		    	strcpy(dev[i], UT.ut_line);	/* copy device */
		    	printf("#%-4d%-8s %-12s %s\n", i, UT.ut_name, UT.ut_line,
		    	   chattime(&UT.ut_time));
			i++;
		}
	}
	close(fid);
	if (!call)			/* send chat request? */
		return;			/* nope, exit */
		
	/* send a message via /dev */
	strinit(workbuf, 5);
	printf("\n\nSend chat summons to # ");
	if (!getline(workbuf, 4)) {	/* get user */
		putchar('\n');
		return;
	}
	if ((n = atoi(workbuf)) > i)	/* out of range */
		return;

	sprintf(workbuf, "/dev/%s", dev[n]);
	if (!(fp = fopen(workbuf, "w"))) {
		puts("\nCan't open device");
		return;
	}
	fprintf(fp, "\07\n\n** Chat Request from %s on %s", my.name, my.tty);
	fprintf(fp, "\n** From shell:  type 'chat'");
	fprintf(fp, "\n** From Magpie: type 'EC'\n\07");
	fclose(fp);
	puts("\nSummons sent");
}
SHAR_EOF
fi # end of overwriting check
if test -f 'chat.h'
then
	echo shar: will not over-write existing file "'chat.h'"
else
cat << \SHAR_EOF > 'chat.h'
/*	chat.h	*/

#include <stdio.h>		
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <signal.h>
#include <ctype.h>
#include <termio.h>

#undef	toupper		/* use the function version */

#define	XENIX		/* this one's for Xenix */

/* path and file prefix for chat text file */
#define	CHATFILE	"/u/local/chatfiles/chat"

/* path and filename for chat user file */
#define WHOFILE		"/u/local/chatfiles/cwho"

/* path and filename for 'chat-closed' file */
#define NOCHATFILE	"/u/local/chatfiles/closed"

#define	UTMPFILE	"/etc/utmp"

#define	MAXPATH		60		/* maximum path length */
#define MAXNAME		25		/* maximum username length */
#define MAXTTYNAME	15		/* maximum ttyname string length */
#define MAXCHAT		2000		/* buffer size for chat message */
#define BUFSIZE		(MAXCHAT *2)	/* maximum output buffer size */
#define MAXLINE		132		/* maximum chat line length */

#define	TRUE		1
#define FALSE		0
#define SUCCESS		0
#define ERROR		-1

#define TTYIN		1		/* terminal handle */

/*----------------------------------------------------------------------
 *	Special string prefixes
 *	These are filtered from display.  They serve mainly to aid
 *	in chatfile searches later.
 *----------------------------------------------------------------------*/
#define	MSG		1		/* Ctrl-A */
#define YELL		2		/* Ctrl-B */

/*----------------------------------------------------------------------
 *	WHO structure
 *----------------------------------------------------------------------*/
typedef	struct {
	char		name[MAXNAME +1];	/* user's name */
	char		tty[MAXTTYNAME +1];	/* device name */
	long		login;			/* login time */
} WHOREC;

/*----------------------------------------------------------------------
 *	strchr/index and 'void' dependencies
 *----------------------------------------------------------------------*/
#ifdef INDEX
#define	strchr	index
#endif

#ifdef NOVOID
#define	void	int
#endif

/*----------------------------------------------------------------------
 *	extern
 *----------------------------------------------------------------------*/
char	*ttyname(), *getlogin(), *chattime(), *strupr(), *finduser(),
	*yell();
long	atol();
void	quit(), unlock(), setsigs(), append(), timeout(), help(), 
	whozon(), killwho(), instext(), gotit(), strinit(), signin();

extern	char	workbuf[], *buff, *tail;
extern	int	mywidth, Chatfid, Lockflag;
extern	long	TimesUp, Chatpos;
extern	WHOREC	my;
SHAR_EOF
fi # end of overwriting check
#	End of shell archive
exit 0
