/*
 * lastlog - print last login time for all users, based on times
 *            stored in /usr/adm/lastlog.
 *
 * Lines are printed oldest first, with name, date/time, and gecos
 * field on each line.
 *
 * No command line options. Runs on VAX/4.2 BSD Unix.
 *
 * compile with:  cc -O -o lastlog lastlog.c
 *
 * Rex Sanders, US Geological Survey, Pacific Marine Geology, 12/19/85
 */

#include <stdio.h>
#include <strings.h>
#include <sys/file.h>
#include <sys/types.h>
#include <lastlog.h>
#include <pwd.h>

/* maximum number of users/entries in /etc/passwd */
#define MAXU       1000
/* maximum length of the gecos field in /etc/passwd */
#define MAXG        100

char   *ctime ();
long    lseek ();

struct info_s {
    int     time;
    char    name[9];
    char    gecos[MAXG];
};

main () {
    int     infocmp ();
    struct lastlog  ll;
    struct passwd  *pw;
    struct info_s   info[MAXU];
    char    lastdate[25];
    int     llfd;
    register int    nusers = 0;
    register int    i;

    if ((llfd = open ("/usr/adm/lastlog", O_RDONLY)) < 0) {
         perror ("lastlog: /usr/adm/lastlog:");
         exit (1);
    }

/*
 * For each user in password file, grab password info
 */
    while (pw = getpwent ()) {
    /* 
     * Grab info from lastlog file
     */
         if (lseek (llfd, (long) pw -> pw_uid * sizeof ll, 0) == -1)
             continue;
         if (read (llfd, (char *) & ll, sizeof ll) != sizeof ll)
             continue;

         info[nusers].time = ll.ll_time;
         strncpy (info[nusers].name, pw -> pw_name, 9);
         strncpy (info[nusers].gecos, pw -> pw_gecos, MAXG);
         nusers++;
    }

/*
 * Sort users by last login time
 */
    qsort ((char *) info, nusers, sizeof (struct info_s), infocmp);

/*
 * Print info for each user
 */
    for (i = 0; i < nusers; i++) {
         if (info[i].time) {
             strncpy (lastdate, ctime (&info[i].time), 24);
             lastdate[24] = '\0';
         }
         else
             strcpy (lastdate, "never logged in");

         printf ("%-8s %-24s    %s\n", info[i].name, lastdate,
                   info[i].gecos);
    }

    close (llfd);
    endpwent ();
}

/*
 * infocmp - compare 2 info entries for qsort
 */

infocmp (info1, info2)
struct info_s  *info1,
               *info2;
{
    register int    r;

    if (info1 -> time == info2 -> time)
         r = 0;
    else
         r = (info1 -> time > info2 -> time) ? 1 : -1;

    return (r);
}
