/* @(#)$Id: fsanalyze.h, V4.1 88/11/16 17:30:22 $ */

/*
 * fsanalyze.h - file system analyzer header file
 * Version  : 4.1 - 88/11/16 17:30:22
 *
 * Author   : Michael J. Young
 * USmail   : Software Development Technologies, Inc.
 *            375 Dutton Rd
 *            Sudbury MA 01776
 * UUCP     : harvard!sdti!mjy
 * Internet : mjy@sdti.SDTI.COM
 *
 * =========================================================================
 * Note : This program has been placed in the public domain to permit
 * unrestricted distribution and use.  I have placed no copyright on it, but
 * I request that you keep me informed about any enhancements and bug fixes
 * you make so I can keep an up-to-date copy for further distribution.
 * =========================================================================
 */

/*
 * Modification History:
 *
 *    Date       Author                   Description
 * -----------  --------  -----------------------------------------------
 * Wed Mar  9 17:51:38 EST 1988 - M. Young (mjy@sdti.SDTI.COM)
 *    Originated.
 *
 * Wed Apr 13 17:19:59 EDT 1988 - M. Young (mjy@sdti.SDTI.COM)
 *    Added support for BSD sockets to IS_SPECIAL macro
 *
 * Tue Jul 26 15:21:44 EDT 1988 - M. Young (mjy@sdti.SDTI.COM)
 *    Added wasted space metric
 *
 * Thu Jul 28 16:18:18 EDT 1988 - M. Young (mjy@sdti.SDTI.COM)
 *    Added external declarations due to code re-organization
 *
 * Mon Aug 08 11:27:39 EDT 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Revised OS_TYPE and FS_TYPE macros to avoid name-space conflicts
 *
 * Wed Nov 16 11:31:32 EST 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Placed under SCCS
 */

#include <sys/param.h>

#if (FS_TYPE == FS_ATT)
# include <sys/types.h>
# include <sys/filsys.h>
# include <sys/ino.h>
#endif

#if (FS_TYPE == FS_BSD)
# include <sys/fs.h>
# include <sys/inode.h>
#endif

#if (FS_TYPE == FS_BSD_NFS)
# include <sys/time.h>
# include <ufs/fs.h>
# include <sys/vnode.h>
# include <ufs/inode.h>
#endif

#include <sys/stat.h>
#include <varargs.h>
#include <stdio.h>

/*
 * ROOTINO doesn't seem to be defined in System V Release 3, so define
 * it here if necessary.
 */

#ifndef	ROOTINO
# define ROOTINO	2
#endif

/***************************************************************************
 *                            Basic Definitions                            *
 ***************************************************************************/

#define FALSE   0
#define TRUE    1

typedef int boolean;

/*
 * absolute value of difference of two numbers
 */
# define diff(l1,l2)   ((l1) >= (l2) ? (l1) - (l2) : (l2) - (l1))

/***************************************************************************
 *                          file mode definitions                          *
 ***************************************************************************/

#define FILE_TYPE(a)    ((a)->di_mode & S_IFMT)

/*
 * defines for determining whether or not a given inode is a special file
 */

/*
 * S_IFNAM for XENIX-style semaphore and shared memory devices
 * S_IFLNK for BSD style symbolic links
 */
#ifdef  S_IFNAM
# define IS_NAM(a) (((a) & S_IFMT) == S_IFNAM)
#else
# define IS_NAM(a) FALSE
#endif	/* XENIX IFNAM devices */

#ifdef  S_IFLNK
# define IS_LNK(a) (((a) & S_IFMT) == S_IFLNK)
#else
# define IS_LNK(a) FALSE
#endif /* BSD symlinks */

#ifdef  S_IFSOCK
# define IS_SOK(a) (((a) & S_IFMT) == S_IFSOCK)
#else
# define IS_SOK(a) FALSE
#endif /* BSD sockets */

#define IS_SPECIAL(a) \
        ((((a) & S_IFMT) == S_IFBLK) || \
        (((a) & S_IFMT) == S_IFCHR) || \
        (((a) & S_IFMT) == S_IFIFO) || \
        IS_NAM(a) || IS_LNK(a) || IS_SOK(a))

/*
 * per-file statistics structure
 */
struct file_data {
    int inode;                          /* i-node number */
    long total_blocks;                  /* total blocks in file (incl 
					 * indirect blocks */
    long data_blocks;                   /* total data blocks in file */
    long potential_seeks;		/* number of potential seeks in file */
    long seeks;                         /* actual seeks in file */
    long rotates;                       /* number of blocks which will suffer
                                         * from rotation delay */
    float fragm;                        /* fragmentation (seeks/pot.seeks) */
    long min_cost;                      /* minimum seek cost for file */
    long cost;                          /* actual seek cost for file */
    float rel_cost;                     /* average relative seek cost */
    long sparse;                        /* sparse file detections */
    long wasted;                        /* wasted space due to partial last
                                         * block */
    };

/***************************************************************************
 *                           External Declarations                         *
 ***************************************************************************/

extern int errno;

extern FILE *fsys;                      /* file system under test */
extern char *special;                   /* file system device name */

extern superblk_t *fil_sys;             /* file system superblock */

/*
 * file system static data
 */
extern int interleave;                  /* file system interleave
                                         * in logical blocks */
extern int block_size;                  /* bytes per logical block */
extern int cyl_size;                    /* physical sectors per cylinder */
extern dev_t fs_device;                 /* device ID of file system */

/*
 * calculated global statistics
 */
extern long blocks;                     /* running block count */
extern long ind_blks;                   /* blocks used for indirect blocks */
extern long free_inodes;                /* number of unused i-nodes */
extern long potential_seeks;            /* potential number of disk seeks
                                         * during sequential access of a 
                                         * file */
extern long seeks;                      /* actual number of disk seeks
                                         * required during sequential access
                                         * of a file */
extern long total_seek_distance;        /* actual distance of disk seeks
                                         * required during sequential access
                                         * of a file */
extern long rotates;                    /* number of disk rotation delays */
extern long indirects;                  /* number of files w/ more than
                                         * 10 data blocks */
extern long double_indirects;           /* number of files w/ more than
                                        /* one level of indirection */
extern long triple_indirects;           /* number of files w/ more than
                                         * two levels of indirection */
extern int big_directories;             /* number of directories with
                                         * indirection */
extern int num_directories;             /* number of directories */
extern int num_specials;                /* number of special files */
extern int linked_files;                /* number of multiply-linked files */
extern int sparse_files;                /* number of sparse files */
extern int size_errors;                 /* number of file size discrepancies */
extern long unuseable;                  /* unuseable bytes due to external
                                         * fragmentation */

extern struct file_data file_log[];     /* worst offenders */


/*
 * fsanalyze command-line flags
 */
extern boolean rpt_indirects;           /* command line option -- report
                                         * files with indirect data blocks */
extern boolean rpt_errors;              /* command line option -- report
                                         * file size discrepancies */
extern boolean debug;                   /* report i-node #s as they are
                                         * examined */
extern boolean override;                /* override bad fs test */


/***************************************************************************
 *                          Function Declarations                          *
 ***************************************************************************/

/*
 * from fsanalyze.c
 */
extern void error();			/* generic error reporter */

/*
 * from init.c
 */
extern int init();			/* system initialization */

/*
 * from util.c
 */
extern daddr_t blk_no();		/* get block number from inode structure */
extern void get_inodes();		/* fetch inode(s) */

/*
 * from fragm.c
 */
extern void test_fragmentation();	/* fragmentation analyzer */

/*
 * from chkfile.c
 */
extern void chk_file();			/* scan inode */
extern void scan();			/* analyze entire file system */
extern void anal_file();		/* analyze single file */

/*
 * from stats.c
 */
extern void init_stats();		/* initialize inode statistics */
extern void log_stats();		/* log inode/file system stats */

/*
 * from report.c
 */
extern void print_report();		/* report fs stats */
