static char sccsid[] = "@(#)$Id: util.c, V4.1 88/11/16 17:31:35 $";

/*
 * util.c - inode utilities
 * Version  : 4.1 - 88/11/16 17:31:35
 *
 * Author   : Michael J. Young
 * USmail   : Software Development Technologies, Inc.
 *            375 Dutton Rd
 *            Sudbury MA 01776
 * UUCP     : harvard!sdti!mjy
 * Internet : mjy@sdti.SDTI.COM
 *
 * =========================================================================
 * Note : This program has been placed in the public domain to permit
 * unrestricted distribution and use.  I have placed no copyright on it, but
 * I request that you keep me informed about any enhancements and bug fixes
 * you make so I can keep an up-to-date copy for further distribution.
 *
 * This program is being provided "as is", with no warrantee as to safety or
 * accuracy of results.  Use at your own risk.
 * =========================================================================
 */

/*
 * Modification History:
 *
 * Thu Jul 28 15:55:40 EDT 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Extracted from fsanalyze.c
 *
 * Mon Aug 08 11:27:39 EDT 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Revised OS_TYPE and FS_TYPE macros to avoid name-space conflicts
 *
 * Wed Nov 16 11:31:32 EST 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Placed under SCCS
 */

#include "fsconfig.h"
#include "fsanalyze.h"

/*
 * blk_no : given a pointer to an inode block number, returns a (daddr_t)
 * block number.  Used to provide portable access to the direct data blocks
 * of an i-node.
 */
daddr_t blk_no (off)
unsigned char *off;                /* 3- or 4-byte offset */
{
    daddr_t temp = 0;

#if FS_TYPE == FS_ATT
    extern void l3tol();

    l3tol (&temp, off, 1);
#endif

#if FS_TYPE == FS_BSD
    temp = *((daddr_t *)off);
#endif

    return temp;
    }

/*
 * get_inodes : given an initial i-node number, reads a block of i-nodes
 * into an i-node array.
 */
void get_inodes (in, inp, num)
int in;                     /* inode number */
int num;                    /* # inodes to get */
struct dinode *inp;         /* buffer to hold info */
{
    daddr_t position;          /* computed position of the
                                * first requested i-node */

    position = (daddr_t) inode_block(fil_sys, in) * block_size + 
               (daddr_t) inode_offset(fil_sys, in) * sizeof(struct dinode);
    if (fseek (fsys, position, 0)){
        error (errno, "\nerror seeking inode %d, pos = %ld\n", in, position);
        /* NOTREACHED */
        }
    else {
        if (fread (inp, sizeof (struct dinode), num, fsys) != num){
            error (errno, "\nerror reading inode %d\n", in);
            /* NOTREACHED */
            }
        }
    }

