static char sccsid[] = "@(#)$Id: stats.c, V4.1 88/11/16 17:31:26 $";

/*
 * stats.c - file system statistics
 * Version  : 4.1 - 88/11/16 17:31:26
 *
 * Author   : Michael J. Young
 * USmail   : Software Development Technologies, Inc.
 *            375 Dutton Rd
 *            Sudbury MA 01776
 * UUCP     : harvard!sdti!mjy
 * Internet : mjy@sdti.SDTI.COM
 *
 * =========================================================================
 * Note : This program has been placed in the public domain to permit
 * unrestricted distribution and use.  I have placed no copyright on it, but
 * I request that you keep me informed about any enhancements and bug fixes
 * you make so I can keep an up-to-date copy for further distribution.
 *
 * This program is being provided "as is", with no warrantee as to safety or
 * accuracy of results.  Use at your own risk.
 * =========================================================================
 */

/*
 * Modification History:
 *
 * Thu Jul 28 16:02:51 EDT 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Extracted from fsanalyze.c
 *
 * Mon Aug 08 11:27:39 EDT 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Revised OS_TYPE and FS_TYPE macros to avoid name-space conflicts
 *
 * Wed Nov 16 11:31:32 EST 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Placed under SCCS
 */

#include "fsconfig.h"
#include "fsanalyze.h"

/*
 * calculated global statistics
 */
long blocks              = 0;           /* running block count */
long free_inodes         = 0;           /* number of unused i-nodes */
long potential_seeks     = 0;           /* potential number of disk seeks
                                         * during sequential access of a 
                                         * file */
long seeks               = 0;           /* actual number of disk seeks
                                         * required during sequential access
                                         * of a file */
long total_seek_distance = 0;           /* actual distance of disk seeks
                                         * required during sequential access
                                         * of a file */
long rotates             = 0;           /* number of disk rotation delays */
long indirects           = 0;           /* number of files w/ more than
                                         * 10 data blocks */
long double_indirects    = 0;           /* number of files w/ more than
                                        /* one level of indirection */
long triple_indirects    = 0;           /* number of files w/ more than
                                         * two levels of indirection */
long ind_blks            = 0;           /* number of blocks used for
                                         * indirection */
int big_directories      = 0;           /* number of directories with
                                         * indirection */
int num_directories      = 0;           /* number of directories */
int num_specials         = 0;           /* number of special files */
int linked_files         = 0;           /* number of multiply-linked files */
int sparse_files         = 0;           /* number of sparse files */
int size_errors          = 0;           /* number of file size discrepancies */
long unuseable           = 0;           /* unuseable bytes due to external
                                         * fragmentation */

struct file_data file_log[NUMOFFEND] = {0};    /* worst offenders */

/*
 * init_stats : initializes per-file statistics structure
 */
void init_stats (data, inode, file_size)
struct file_data *data;                           /* file stats to init */
int inode;                                        /* i-node number */
long file_size;                                   /* file size */
{
    data->inode = inode;
    data->total_blocks = data->data_blocks = 0;
    data->potential_seeks = data->seeks = data->rotates = 0;
    data->fragm = 0.0;
    data->sparse = 0;
    data->cost = 0;
    data->min_cost = minimum_seeks (file_size);
    data->rel_cost = 0.0;
    data->wasted = 0;
    }

/*
 * log_stats : updates global statistics based on the current file statistics.
 * The current file is then checked to see if it qualifies as one of the
 * worst offenders (i.e., most fragmented) encountered thus far.  The worst
 * offenders are determined based on their absolute number of disk seeks
 * required to read the entire file.  Such an absolute test (viz a viz a
 * relative percentage test) ensures that very small, but fragmented, files
 * will not clutter the output.
 */
void log_stats (data)
struct file_data *data;                /* file statistics to be
                                        * logged */
{
    int i, j;                          /* loop counters */


    /*
     * update global statistics
     */
    blocks += data->total_blocks;
    ind_blks += data->total_blocks - data->data_blocks;
    potential_seeks += data->potential_seeks;
    seeks += data->seeks;
    total_seek_distance += data->cost;
    rotates += data->rotates;
    data->fragm = data->potential_seeks ? (float)data->seeks/(float)data->potential_seeks : 0.0;
    data->rel_cost = (data->seeks ? (float)data->cost/(float)data->seeks : 0.0);
    unuseable += data->wasted;

    /*
     * update worst offender array
     */
    for (i = 0; i < NUMOFFEND; i++){
        if (data->seeks > file_log[i].seeks){
            for (j = NUMOFFEND-1; j > i; j--){
                file_log[j] = file_log[j-1];
                }
            file_log[i] = *data;
            break;
            }
        }
    }

