static char sccsid[] = "@(#)$Id: report.c, V4.1 88/11/16 17:31:13 $";

/*
 * report.c - print analysis report
 * Version  : 4.1 - 88/11/16 17:31:13
 *
 * Author   : Michael J. Young
 * USmail   : Software Development Technologies, Inc.
 *            375 Dutton Rd
 *            Sudbury MA 01776
 * UUCP     : harvard!sdti!mjy
 * Internet : mjy@sdti.SDTI.COM
 *
 * =========================================================================
 * Note : This program has been placed in the public domain to permit
 * unrestricted distribution and use.  I have placed no copyright on it, but
 * I request that you keep me informed about any enhancements and bug fixes
 * you make so I can keep an up-to-date copy for further distribution.
 *
 * This program is being provided "as is", with no warrantee as to safety or
 * accuracy of results.  Use at your own risk.
 * =========================================================================
 */

/*
 * Modification History:
 *
 * Thu Jul 28 16:03:04 EDT 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Extracted from fsanalyze.c
 *
 * Mon Aug 08 11:27:39 EDT 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Revised OS_TYPE and FS_TYPE macros to avoid name-space conflicts
 *
 * Wed Nov 16 11:31:32 EST 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Placed under SCCS
 */

#include "fsconfig.h"
#include "fsanalyze.h"

/*
 * print_report : calculates percentages and prints a summary report of
 * file system statistics
 */
void print_report (){
    char    minibuf[32];          /* line buffer */
    long    num_files;            /* number of inodes used
                                   * in file system */
    int     i;                    /* loop counter */
    
    float   fragm,                /* percent fragmentation */
            rel_cost,             /* relative cost of fragmentation */
            rotations,            /* percent rotation delays */
            ind_p,                /* percent indirections */
            dind_p,               /* percent double indirects */
            tind_p,               /* percent triple indirects */
            bused_p,              /* percent data blocks used */
            iused_p,              /* percent inodes used */
            sparse_p,             /* percent sparse inodes */
            link_p,               /* percent multiply-linked
                                   * files */
            spec_p,               /* percent special files */
            dir_p,                /* percent of inodes that
                                   * are directories */
            bdir_p,               /* percent of directories
                                   * that have more than 10
                                   * blocks */
            indirb_p,             /* percent of blocks used for indirection */
            wasted_p;             /* wasted space due to external frag */

    /*
     * calculate percentages for report
     */
    fragm = potential_seeks ? (float)seeks/(float)potential_seeks : 0.0;
    rel_cost = seeks ? (float)total_seek_distance / (float)seeks : 0.0;
    rotations = potential_seeks ? (float)rotates/(float)potential_seeks : 0.0;
    bused_p = (float)blocks/(float)(blocks+freespace(fil_sys,0));
    num_files = num_inodes(fil_sys) - free_inodes;
    iused_p = (float)num_files/(float)num_inodes(fil_sys);
    ind_p = num_files ? (float)indirects/(float)num_files : 0.0;
    dind_p = num_files ? (float)double_indirects/(float)num_files : 0.0;
    tind_p = num_files ? (float)triple_indirects/(float)num_files : 0.0;
    sparse_p = num_files ? (float)sparse_files/(float)num_files : 0.0;
    dir_p = num_files ? (float)num_directories/(float)num_files : 0.0;
    bdir_p = num_directories ? (float)big_directories/(float)num_directories : 0.0;
    link_p = num_files ? (float)linked_files/(float)num_files : 0.0;
    spec_p = num_files ? (float)num_specials/(float)num_files : 0.0;
    indirb_p = (float)ind_blks/(float)(blocks+freespace(fil_sys,0));
    wasted_p = (float)unuseable/(float)(fssize(fil_sys) * block_size);

    /*
     * print out report
     */
# if FS_TYPE == FS_ATT
    printf ("\n\nFile system name = \"%.6s\", Volume name = \"%.6s\"\n",
        fil_sys->s_fname, fil_sys->s_fpack);
# endif

# if FS_TYPE == FS_BSD
    /* Where do you get file system/volume name from? */
# endif

    printf ("Logical block size = %d bytes", bsize(fil_sys));

# if FS_TYPE == FS_BSD
    printf (", Fragment size = %d bytes", block_size);
# endif

    printf ("\nInterleave = %d sectors; %d sectors/cyl", 
        interleave, cyl_size);

# if FS_TYPE == FS_BSD
    printf ("; Allocation Strategy = %s", 
        fil_sys->fs_optim == FS_OPTTIME ? "Time" : "Space");
# endif

    printf ("\nVolume Size = %ld blocks (%ld bytes)\n",
        fssize(fil_sys), fssize(fil_sys) * block_size);
    printf ("\t%u blocks reserved for super block and inodes (%d inodes)\n", isize (fil_sys), num_inodes (fil_sys));
    printf ("\t%lu blocks reserved for data\n", 
        dsize(fil_sys));

# if FS_TYPE == FS_BSD
    printf ("Cylinder groups = %ld; Inodes per cg = %ld; Data Blocks per cg = %ld\n",
            fil_sys->fs_ncg, fil_sys->fs_ipg, fil_sys->fs_fpg);
# endif

    printf ("%.2f%% inodes used (%ld used, %ld free)\n", 
        iused_p*100, num_inodes(fil_sys) - free_inodes, free_inodes);
    printf ("%.2f%% data blocks used (%ld used, %ld free)\n",
        bused_p*100, blocks, freespace(fil_sys,0));

    printf ("\n");
    sprintf (minibuf, "%.2f%%", fragm*100);
    printf ("Fragmentation         = %-15s", minibuf);
/*    printf ("   (%ld seeks of %ld potential)\n", seeks, potential_seeks); */
    printf ("  Special files    = %d (%.2f%%)\n",
        num_specials, spec_p*100);
    sprintf (minibuf, "%.2f cyls", rel_cost);
    printf ("Average Seek Distance = %-15s", minibuf);
    printf ("  Indirect files   = %ld (%.2f%%)\n",
        indirects, ind_p*100);
    sprintf (minibuf, "%.2f%%", rotations*100);
    printf ("Rotation delays       = %-15s", minibuf);
    printf ("  Double indirects = %ld (%.2f%%)\n",
        double_indirects, dind_p*100);
    sprintf (minibuf, "%d (%.2f%%)", linked_files, link_p*100);
    printf ("Multiply-linked files = %-15s", minibuf);
    printf ("  Triple indirects = %ld (%.2f%%)\n",
        triple_indirects, tind_p*100);
    sprintf (minibuf, "%d (%.2f%%)", num_directories, dir_p*100);
    printf ("Directories           = %-15s", minibuf);
    printf ("  Indirection blks = %ld (%.2f%%)\n",
        ind_blks, indirb_p*100);
    sprintf (minibuf, "%d (%.2f%%)", big_directories, bdir_p*100);
    printf ("Oversized directories = %-15s", minibuf);
    printf ("  Sparse files     = %d (%.2f%%)\n",
        sparse_files, sparse_p*100);
    printf ("Unused bytes in last blocks = %ld (%.2f%%)\n",
        unuseable, wasted_p*100);
    printf ("                            %d Most Fragmented Files\n",NUMOFFEND);
    printf (" i-node  Size  Fragments   %%      Dist  i-node  Size  Fragments   %%       Dist\n");
    for (i = 0; i < NUMOFFEND/2; i++){
        if (file_log[i].inode != 0){
            printf ("%6d %6ld   %6ld  %6.2f%% %6.1f",
                file_log[i].inode,
                file_log[i].total_blocks,
                file_log[i].seeks+1,
                file_log[i].fragm*100,
                file_log[i].rel_cost);
            if (file_log[i+(NUMOFFEND/2)].inode != 0){
                printf (" %6d %6ld   %6ld  %6.2f%%  %6.1f",
                    file_log[i+(NUMOFFEND/2)].inode,
                    file_log[i+(NUMOFFEND/2)].total_blocks,
                    file_log[i+(NUMOFFEND/2)].seeks+1,
                    file_log[i+(NUMOFFEND/2)].fragm*100,
                    file_log[i+(NUMOFFEND/2)].rel_cost);
                }
            printf ("\n");
            }
        else break;
        }
    }

