/* @(#)$Id: fsconfig.h, V4.1.1.1 88/11/18 17:38:35 $ */

/*
 * fsconfig.h - fsanalyze configuration-specific definitions
 * Version  : 4.1.1.1 - 88/11/18 17:38:35
 *
 * Author   : Michael J. Young
 * USmail   : Software Development Technologies, Inc.
 *            375 Dutton Rd
 *            Sudbury MA 01776
 * UUCP     : harvard!sdti!mjy
 * Internet : mjy@sdti.SDTI.COM
 *
 * =========================================================================
 * Note : This program has been placed in the public domain to permit
 * unrestricted distribution and use.  I have placed no copyright on it, but
 * I request that you keep me informed about any enhancements and bug fixes
 * you make so I can keep an up-to-date copy for further distribution.
 * =========================================================================
 */

/*
 * Modification History:
 *
 *    Date       Author                   Description
 * -----------  --------  -----------------------------------------------
 * Wed Mar  9 17:51:38 EST 1988 - M. Young (mjy@sdti.SDTI.COM)
 *    Originated.
 *
 * Wed Apr 13 17:18:06 EDT 1988 - M. Young (mjy@sdti.SDTI.COM)
 *    Completed port to BSD.  Added fsize(), first_inode, and Sec_per_blk
 *    macros.
 *
 * Wed Jun 15 14:06:35 EDT 1988 - M. Young (mjy@sdti.SDTI.COM)
 *    Added NUMOFFEND macro.
 *
 * Tue Jul 26 15:27:52 EDT 1988 - M. Young (mjy@sdti.SDTI.COM)
 *    Modified Opt_interleave and cyl_pos macros to more closely reflect BSD
 *    placement algorithm (still unsure of this!).
 *
 * Thu Jul 28 16:43:20 EDT 1988 - M. Young (mjy@sdti.SDTI.COM)
 *    Opt_interleave formula now makes sense.
 *
 * Mon Aug 08 11:27:39 EDT 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Revised OS_TYPE and FS_TYPE macros to avoid name-space conflicts
 *
 * Wed Nov 16 11:31:32 EST 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Placed under SCCS
 *
 * Fri Nov 18 17:37:08 EST 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Removed #defines for SUPERBOFF for all but XENIX/286
 */

/*
 * One of the things fsanalyze displays is a list of the most fragmented
 * files.  The macro NUMOFFEND determines how many of those files to report.
 * The report is in double column format, so the number should be divisible
 * by 2.  Ideally, this number should be set so that the report fits on
 * a single screen.  For a 24-line display, the suggested number is 10
 * (5 lines).
 */
#ifndef NUMOFFEND
# define NUMOFFEND	10	/* number of top offenders to report	*/
#endif

/*
 * File System types - define _FS_TYPE accordingly
 */
#define FS_ATT         1       /* AT&T File system derivatives, incl Version 7,
                                * System III, & System V (sVr2 & sVr3) */
#define FS_BSD         2       /* BSD fast file system derivatives */
#define FS_BSD_NFS     3       /* BSD fast file system with NFS support */

/*
 * OS-types -- although the basic structure of the file system remains
 * constant, many ports of Unix contain minor modifications.  Eventually,
 * the following should contain a complete list of special cases.  Those
 * OS's which do not contain special cases should be referred to as OS_ATT
 * or OS_BSD.
 */
#define OS_ATT         1       /* Generic AT&T OS, no special cases */
#define OS_BSD         2       /* Generic BSD 4.2 or later FFS, no special
                                * cases */
#define OS_XENIX_286   4       /* XENIX/286 */
#define OS_UPORT_286   5       /* Microport System V/AT */

#ifndef FS_TYPE
# define FS_TYPE    FS_ATT
#endif

#ifndef OS_TYPE
# define OS_TYPE    OS_ATT
#endif


/***************************************************************************
 *                            file system macros                           *
 ***************************************************************************/

/*
 * File systems based on Version 7 Unix (System III and System V) are
 * significantly different than those based on the BSD Fast File System.
 * The following macros are defined to facilitate portable access to the
 * superblock and inode information.  Where possible, macro names 
 * the BSD <sys/fs.h> are used, and these macros must be created for non
 * BSD file systems.
 *
 *    SUPERBOFF                 Byte offset of the superblock
 *    DEV_BSIZE                 Physical device block size (sector size)
 *    MAXBSIZE                  Maximum block size of any file system
 *    MAXINOPB                  Maximum number of inodes per block (based
 *                              on largest possible block size of any file
 *                              system
 *    MAXINDIR                  Maximum number of indirect blocks per block
 *                              (based on largest possible block size of any
 *                              file system)
 *    inopb(fs)                 Number of inodes per block of a given file
 *                              system
 *    nindir(fs)                Number of indirect blocks per block in a
 *                              given file system
 *    bsize(fs)                 Block size (in bytes) of a given file system
 *    fsize(fs)                 Fragment size (in bytes) -- same as bsize()
 *                              in non-BSD file systems
 *    fssize(fs)                Total size of a file system (in blocks of
 *                              bsize(fs) bytes)
 *    dsize(fs)                 Number of data blocks in the file system
 *    isize(fs)                 Total number of blocks reserved for inode info
 *    num_inodes(fs)            Number of inodes supported by the file system
 *    first_inode               number of first inode in file system
 *    iblkno(fs)                Block number of the first inode in a file
 *                              system (or cylinder group)
 *    sec_per_cyl(fs)           Number of physical sectors per cylinder in
 *                              a given file system
 *    is_ok(fs)                 TRUE if the file system is not in need of
 *                              checking (with fsck(1M))
 *    opt_interleave(fs)        The optimum sector interleave which will result
 *                              in minimum rotational delay.
 *    Sec_per_blk               Number of sectors per logical block
 *    freespace(fs,res)         Total number of free blocks in a file system,
 *                              given a percentage that must be held in reserve
 *    inode_block(fs,inode)     Computes block number which contains inode info
 *    inode_offset(fs,inode)    Computes offset of an inode within its block
 *    blk_size(fs,inode,lbn)    Computes the size of a data block in bytes
 *    cylinder(fs,blk)          Computes cylinder which contains specified
 *                              block
 *    cyl_pos(fs,blk)           Computes relative sector position of the
 *                              specified block in its cylinder.
 *    NDADDR                    Number of direct data blocks within inode
 *    NIADDR                    Number of indirect data blocks within inode
 *    dta_blk(blk)              Returns pointer to data block within inode
 *                              cast as (char *) for compatibility with
 *                              AT&T file systems.
 *    indir_blk(blk)            Returns pointer to indirect block within inode
 *                              cast as (char *) for compatibility with
 *                              AT&T file systems.
 */

/*
 * Sec_per_blk : Number of physical sectors (size DEV_BSIZE) per logical block.
 */
#define Sec_per_blk             (block_size / DEV_BSIZE)

#if (FS_TYPE == FS_ATT)

/*
 * The following definitions provide the above-listed macros for a
 * "conventional" Unix file system.  Any versions of Unix that use a
 * file system structure that was derived directly from Version 7 Unix
 * (e.g., System III, System V, XENIX) use these definitions.
 */

typedef struct filsys superblk_t;       /* superblock structure definition */

/* SCO XENIX doesn't have SUPERBOFF, so we must set it explicitly.  Note
 * that XENIX/286 seems to want the value BSIZE*SUPERB (==1024L), yet
 * XENIX/386 is "normal" SystemV (512L).
 */
# if (OS_TYPE == OS_XENIX_286)
#   define SUPERBOFF	(BSIZE*SUPERB)
# endif

# define DEV_BSIZE      512

/*
 * MAXBSIZE is defined as the largest possible BSIZE for any file system.
 * The largest I have come across in System V ports is 2048.  If a larger
 * one is encountered, MAXBSIZE should be increased accordingly.
 */
# define MAXBSIZE       2048
# define MAXINOPB       (MAXBSIZE / sizeof (struct dinode))
# define MAXINDIR       (MAXBSIZE / sizeof (daddr_t))
# ifdef FsINOPB
#  define inopb(fs)	FsINOPB(fs)
# else
#  define inopb(fs)     INOPB
# endif
# ifdef FsNINDIR
#  define nindir(fs)	FsNINDIR(fs)
# else
#  define nindir(fs)    NINDIR
# endif

/*
 * The following definition is used to determine the logical block size for
 * a particular file system.  Normally, SBUFSIZE == BSIZE == the logical
 * block size.  However, in systems that have dual file system support
 * enabled (rare), BSIZE is usually set to the block size of the smaller
 * file system, whereas SBUFSIZE is set to the larger.  If this is
 * different in your system, change the following macro accordingly.
 */
# ifdef Fs2b
#  define bsize(fs)      ((fs)->s_type == Fs2b ? SBUFSIZE : BSIZE)
# else
#  define bsize(fs)	 (BSIZE)
# endif
# define fsize(fs)       (bsize(fs))

# define fssize(fs)      ((fs)->s_fsize)
# define dsize(fs)       ((fs)->s_fsize - (fs)->s_isize)
# define isize(fs)       ((fs)->s_isize)
# define num_inodes(fs)  (((fs)->s_isize-ROOTINO) * inopb(fs))
# define first_inode     1
# define iblkno(fs)      2
# define sec_per_cyl(fs) ((fs)->s_dinfo[1])

/*
 * Note that the standard check for file system integrity does not work
 * on Microport systems because a clean, unmounted file system is not set
 * to FsOKAY, but some other undocumented constant.  It is therefore
 * strongly recommended that the HAVE_FSSTAT macro be defined for Microport
 * systems.
 */
# if (OS_TYPE == OS_UPORT_286)
#  define is_ok(fs) (TRUE)
#  ifndef HAVE_FSSTAT
#   define HAVE_FSSTAT
#  endif
# else
#  if (OS_TYPE == OS_XENIX_286)
#   define is_ok(fs) (TRUE)
#  else
#   define is_ok(fs) ((fs)->s_state == FsOKAY) || ((fs)->s_state == FsACTIVE)
#  endif
# endif

# define opt_interleave(fs)      ((fs)->s_dinfo[0])
# define freespace(fs,reserved)  ((fs)->s_tfree)
# define inode_block(fs,inode)   (iblkno(fs) + (((inode)-1) / inopb(fs)))
# define inode_offset(fs,inode)  (((inode)-1) % inopb(fs))
# define blk_size(fs, inode, lbn) (bsize(fs))
# define cylinder(fs,blk)        ((daddr_t)(blk) * Sec_per_blk / cyl_size)
# define cyl_pos(fs,blk)         ((daddr_t)(blk) * Sec_per_blk % cyl_size)

/*
 * inode data/indirect block access
 */
# define NDADDR                  10    /* direct addresses in inode */
# define NIADDR                  3     /* indirect addresses in inode */

# define dta_blk(ino, blk)       (&(ino)->di_addr[(blk)*3])
# define indir_blk(ino, blk)     (&(ino)->di_addr[((blk)+10)*3])

#endif /* FS_TYPE == FS_ATT */

#if ((FS_TYPE == FS_BSD) || (FS_TYPE == FS_BSD_NFS))

/*
 * The following definitions provide the above-listed macros for a derivative
 * of the BSD Fast File System.
 */

typedef struct fs superblk_t;    /* superblock structure definition */

# define SUPERBOFF        (SBLOCK * DEV_BSIZE)
/* DEV_BSIZE is defined in <sys/fs.h> */
/* MAXBSIZE is defined in <sys/fs.h>  */
# define MAXINOPB         (MAXBSIZE / sizeof (struct dinode))
# define MAXINDIR         (MAXBSIZE / sizeof (daddr_t))
# define inopb(fs)        INOPB(fs)
# define nindir(fs)       NINDIR(fs)
# define bsize(fs)        ((fs)->fs_bsize)
# define fsize(fs)        (bsize(fs) / (fs)->fs_frag)
# define fssize(fs)       ((fs)->fs_size)
# define dsize(fs)        ((fs)->fs_dsize)
# define isize(fs)        ((fs)->fs_ncg * (fs)->fs_ipg / inopb(fs))
# define num_inodes(fs)   (isize(fs) * inopb(fs))
# define first_inode      0
# define iblkno(fs)       ((fs)->fs_iblkno)
# define sec_per_cyl(fs)  ((fs)->fs_spc)

/*
 * How do we determine file system integrity on a BSD file system?
 */
# define is_ok(fs)        (TRUE)

# define opt_interleave(fs) \
         (((fs)->fs_rps * (fs)->fs_nsect * (fs)->fs_rotdelay /* sectors */\
           + ((NSPB(fs)*1000)-1)) / 1000)      /* round up */

/* freespace(fs,res) is defined in <sys/fs.h> */
# define inode_block(fs,inode)   itod((fs),(inode))
# define inode_offset(fs,inode)  itoo((fs),(inode))
# define cylinder(fs,blk)        cbtocylno((fs),(blk))
# define cyl_pos(fs,blk)         (cbtorpos((fs),(blk)) * NRPOS)

# define blk_size(fs, inode, lbn)  (dblksize (fs, inode, lbn))

/*
 * inode data/indirect block access
 */
/* NDADDR is defined in inode.h */
/* NIADDR is defined in inode.h */
# define dta_blk(ino,blk)        ((char *)&((ino)->di_db[blk]))
# define indir_blk(ino,blk)      ((char *)&((ino)->di_ib[blk]))

# endif  /* FS_TYPE == FS_BSD || FS_TYPE == FS_BSD_NFS */
