static char sccsid[] = "@(#)$Id: fsanalyze.c, V4.1 88/11/16 17:30:08 $";

/*
 * fsanalyze.c - file system analyzer
 * Version  : 4.1 - 88/11/16 17:30:08
 *
 * Author   : Michael J. Young
 * USmail   : Software Development Technologies, Inc.
 *            375 Dutton Rd
 *            Sudbury MA 01776
 * UUCP     : harvard!sdti!mjy
 * Internet : mjy@sdti.SDTI.COM
 *
 * =========================================================================
 * Note : This program has been placed in the public domain to permit
 * unrestricted distribution and use.  I have placed no copyright on it, but
 * I request that you keep me informed about any enhancements and bug fixes
 * you make so I can keep an up-to-date copy for further distribution.
 *
 * This program is being provided "as is", with no warrantee as to safety or
 * accuracy of results.  Use at your own risk.
 * =========================================================================
 */

/*
 * Modification History:
 *
 *    Date       Author                   Description
 * -----------  --------  -----------------------------------------------
 * 28 Jul 1987    MJY       Originated
 *  5 Oct 1987    MJY       Capability to analyze individual files,
 *                          Added error checking to file system argument,
 *                          Added -o flag
 *                          Prints out volume and file system name in summary
 * 12 Oct 1987    MJY       Use /etc/fsstat to do file system validity
 *                          checking
 *  9 Nov 1987    MJY       print out warning if file system is mounted
 * 12 Nov 1987    MJY       Volume size statistics now long instead of int
 *  7 Jan 1988    MJY       Modified blk_no() to use l3tol()
 *
 * Wed Mar  9 17:51:38 EST 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Rewrite for portability between various versions of System V, esp.
 *    SCO XENIX and 5.3 systems.  First (incomplete) attempt at porting
 *    to BSD 4.3.  See README for details.
 *
 * Thu Apr  7 10:03:21 EDT 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Seeks for files that span cylinders due to their sheer size are
 *    ignored.  Average seek distance is now reported.
 *
 * Wed Apr 13 17:33:03 EDT 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Completed port to BSD.  Fixed bug in inode numbering for BSD.
 *    Symbolic links now handled correctly for individual files.
 *
 * Wed Jun 15 14:08:30 EDT 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Number of top offenders is now a configurable parameter via the
 *    NUMOFFEND macro in fsconfig.h.
 *
 * Fri Jun 24 16:22:10 EDT 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Make top offender size report consistent with anal_file reports.
 *
 * Tue Jul 26 15:24:30 EDT 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Added wasted space metric
 *    Modified BSD rotation delay algorithm
 *
 * Thu Jul 28 16:15:22 EDT 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Opt_interleave() formula now makes sense
 *    Re-organized code and general cleanup in preparation for posting.
 *
 * Mon Aug 08 11:27:39 EDT 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Revised OS_TYPE and FS_TYPE macros to avoid name-space conflicts
 *
 * Wed Nov 16 11:31:32 EST 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Placed under SCCS
 */

/*
 * Include files
 */
#include "fsconfig.h"
#include "fsanalyze.h"

/***************************************************************************
 *                           Global Variables                              *
 ***************************************************************************/

/*
 * interface to system error messages
 */
extern char *sys_errlist[];
extern int sys_nerr;

/*
 * error : performs a function similar to perror(3), but supports variable
 * argument lists.  Prints out a formatted error string to stderr, followed if
 * possible by an appropriate system error message.  Control is then
 * returned to the system with an error status.  This function does not
 * return.
 */
/* VARARGS0 */
void error (va_alist)
va_dcl                            /* varargs */
{
    int err;                      /* 1st arg - error number */
    char *str;                    /* 2nd arg - error format string */
    va_list args;
    va_start(args);
    err = va_arg (args, int);
    str = va_arg (args, char *);
    vfprintf (stderr, str, args);
    if (err <= sys_nerr && err > 0)
        fprintf (stderr, "%s\n", sys_errlist[err]);
    else
        fprintf (stderr, "unknown error : %d\n", err);
    va_end(args);

    /*
     * print out partial report, if possible
     */
    if (fil_sys != NULL)print_report ();
    exit(1);                      /* exit with error status */
    }

main (argc, argv)
int argc;
char *argv[];
{
    int next_param;
    extern int stat ();
    struct stat f_stat;

    /*
     * perform various initialization functions
     */
    next_param = init (argc, argv);

    if (next_param == argc){
        /*
         * no individual files to check, scan entire file system
         */
        printf ("Analyzing file system %s...\n", special);

        /*
         * scan through all i-nodes in the file system
         */
        scan();

        /*
         * print out statistics summary
         */
        print_report();
        }
    else {
        /*
         * scan individual files instead of entire file system
         */
        printf ("                  \t                                       Seek  Wasted\n");
        printf ("        Name      \ti-node    Fragments  Size      %%       Dist  Space\n");
        for (; next_param < argc; next_param++){
            if (stat (argv[next_param], &f_stat) != 0){
                error (errno, "error opening \"%s\"\n",
                       argv[next_param]);
                /* NOTREACHED */
                }
            else {

                /*
                 * make sure the inode belongs to the correct device
                 * (for BSD systems with symbolic links)
                 */
                if ((f_stat.st_dev == fs_device) &&
                    !IS_SPECIAL (f_stat.st_mode)){
                    anal_file (f_stat.st_ino, argv[next_param]);
                    }
                }
            }
        }
    return (0);
    }
