static char sccsid[] = "@(#)$Id: init.c, V4.1 88/11/16 17:30:51 $";

/*
 * init.c - initialization and usage code
 * Version  : 4.1 - 88/11/16 17:30:51
 *
 * Author   : Michael J. Young
 * USmail   : Software Development Technologies, Inc.
 *            375 Dutton Rd
 *            Sudbury MA 01776
 * UUCP     : harvard!sdti!mjy
 * Internet : mjy@sdti.SDTI.COM
 *
 * =========================================================================
 * Note : This program has been placed in the public domain to permit
 * unrestricted distribution and use.  I have placed no copyright on it, but
 * I request that you keep me informed about any enhancements and bug fixes
 * you make so I can keep an up-to-date copy for further distribution.
 *
 * This program is being provided "as is", with no warrantee as to safety or
 * accuracy of results.  Use at your own risk.
 * =========================================================================
 */

/*
 * Modification History:
 *
 * Thu Jul 28 15:50:42 EDT 1988 - M. Young (mjy@sdti.SDTI.COM)
 *    Extracted from fsanalyze.c.
 *
 * Mon Aug 08 11:27:39 EDT 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Revised OS_TYPE and FS_TYPE macros to avoid name-space conflicts
 *
 * Wed Nov 16 11:31:32 EST 1988 - M. Young (mjy@sdti.SDTI.COM),
 *    Placed under SCCS
 */

#include "fsconfig.h"
#include "fsanalyze.h"
#include "patchlevel.h"

static superblk_t super = {0};          /* holds file system super block */
superblk_t *fil_sys     = &super;       /* external handle to super block */

FILE *fsys               = NULL;        /* file system under test */
char *special            = NULL;        /* file system device name */

/*
 * file system static data
 */
int interleave           = 0;           /* file system interleave
                                         * in logical blocks */
int block_size           = 0;           /* bytes per logical block */
int cyl_size             = 0;           /* physical sectors per cylinder */
dev_t fs_device          = 0;           /* device ID of file system */

/*
 * fsanalyze command-line flags
 */
boolean rpt_indirects = FALSE;          /* command line option -- report
                                         * files with indirect data blocks */
boolean rpt_errors    = FALSE;          /* command line option -- report
                                         * file size discrepancies */
boolean debug         = FALSE;          /* report i-node #s as they are
                                         * examined */
boolean override      = FALSE;          /* override bad fs test */

/*
 * version : prints out the current version of fsanalyze
 */
void version(){
    printf ("\nFile System Analyzer\n");
    printf ("Version : 4.1 - 88/11/16 17:30:51, Patch Level #%d\n", patch_level);
    }

/*
 * usage : prints out a short message describing command usage.  This
 * function does not return.
 */
void usage(){
    version();
    printf ("Usage   : fsanalyze [-[deio] [-b#] [-c#] [-g#] ] special [file] ...\n");
    printf ("\nIf the [file] argument(s) are missing, the entire file system\n");
    printf ("is scanned.  Otherwise, only the specified files are examined.\n");
    printf ("Valid option are:\n\n");
    printf ("\tb#\tassume '#' bytes per logical block;\n");
    printf ("\t\toverrides default calculation from the superblock.\n");
    printf ("\tc#\tassume '#' sectors per disk cylinder;\n");
    printf ("\t\toverrides information contained in superblock.\n");
    printf ("\td\tdisplay i-node numbers as they are examined\n");
    printf ("\te\treport file size inconsistencies\n");
    printf ("\tg#\tassume an inter-block gap of '#' sectors;\n");
    printf ("\t\toverrides information contained in superblock.\n");
    printf ("\ti\treport data block double and triple indirection\n");
    printf ("\to\toverride error checking on file system argument\n");
    printf ("\tv\tdisplay current version number and patch level\n");
    exit(1);
    }

/*
 * chk_fs : opens the file system and reads the superblock, then checks
 * the file system to be sure it is not damaged.  If the file system is
 * damaged, the function displays a message, then returns FALSE.  Otherwise,
 * returns TRUE.
 */
boolean chk_fs (fs)
char *fs;
{
#ifdef  HAVE_FSSTAT
    char buffer[256];                /* buffer to hold cmd */
    int fstatus;                     /* exit status of fsstat */
#endif  /* HAVE_FSSTAT */

    extern int fstat();
    struct stat sbuf;                /* buffer to hold file status */

    /*
     * make sure the file is a block structured device, then read
     * the superblock
     */
    if ((fsys=fopen (fs, "r")) == NULL){
        error (errno, "error opening \"%s\"\n", fs);
        /* NOTREACHED */
        }
    if (fstat (fileno (fsys), &sbuf)){
        error (errno, "fstat failed: \"%s\"\n", fs);
        /* NOTREACHED */
        }
    if ((sbuf.st_mode & S_IFMT) != S_IFBLK){
        fprintf (stderr, "\"%s\" is not a block structured device\n",
                 fs);
        return (FALSE);
        }

    /*
     * save device ID of file system for later use.
     */
    fs_device = sbuf.st_rdev;

#ifdef  HAVE_FSSTAT
    /*
     * Check the integrity of the file system using fsstat(1).
     */
    sprintf (buffer, "/etc/fsstat %s 2>/dev/null", fs);
    fstatus = system (buffer);
    if (fstatus != 0 && !override){
        if (fstatus == 512){
            fprintf (stderr, "warning: file system is mounted\n");
            }
        else {
            /*
             * run fsstat again to get error message (this is a kludge,
             * but I hope more portable than having fsanalyze do the
             * analysis itself)
             */
             sprintf (buffer, "/etc/fsstat %s", fs);
             (void) system(buffer);
             return (FALSE);
             }
         }
#endif  /* HAVE_FSSTAT */

    /*
     * Read the file system super block
     */
    if (fseek (fsys, (long)SUPERBOFF, 0)){
        error (errno, "error seeking superblock\n");
        /* NOTREACHED */
        }
    if (fread (fil_sys, sizeof (superblk_t), 1, fsys) != 1){
        error (errno, "error reading superblock\n");
        /* NOTREACHED */
        }

#ifndef HAVE_FSSTAT
    /*
     * Check the integrity of the file system manually, if possible.
     */
    if (!is_ok(fil_sys)){
        fprintf (stderr, "\"%s\" needs checking\n", fs);
        return (FALSE);
        }

#endif  /* HAVE_FSSTAT */

    return (TRUE);
    }

/*
 * init : parses command line flags and the file system device name, then
 * reads the file system super block.  init returns the number of the
 * parameter AFTER the file system device name.  All subsequent parameters
 * are assumed to be specific files to be tested.
 */
int init (argc, argv)
int argc;
char *argv[];
{
    int i;                             /* loop counter */
    char *cp;                          /* cmd-line flag pointer */
    boolean special_found = FALSE;     /* TRUE = found special arg */
    boolean done;                      /* means of escaping while loop
                                        * from within a switch */
    
    for (i = 1; i < argc && !special_found; i++){
        cp = argv[i];
        if (*cp == '-'){
            done = FALSE;
            while (*++cp && !done){
                switch (*cp){

                        /* override logical block size */
                    case 'b':
                        if (cp[1]){
                            block_size = atoi (++cp);
                            done = TRUE;      /* force end of while loop */
                            }
                        else {
                            block_size = atoi (argv[++i]);
                            }
                        if (block_size < 1){
                            fprintf (stderr, "Illegal value for block size : %d, using default value of 512 bytes\n", block_size);
                            block_size = 0;
                            }
                        break;

                        /* override number of sectors per cylinder */
                    case 'c':
                        if (cp[1]){
                            cyl_size = atoi (++cp);
                            done = TRUE;      /* force end of while loop */
                            }
                        else {
                            cyl_size = atoi (argv[++i]);
                            }
                        if (cyl_size < 1){
                            fprintf (stderr, "Illegal value for cylinder size : %d\n", cyl_size);
                            fprintf (stderr, "using default value from superblock\n");
                            cyl_size = 0;
                            }
                        break;

                        /* debugging flag */
                    case 'd':
                        debug = TRUE;
                        break;

                        /* report file size errors */
                    case 'e':
                        rpt_errors = TRUE;
                        break;

                        /* override inter-record gap */
                    case 'g':
                        if (cp[1]){
                            interleave = atoi (++cp);
                            done = TRUE;      /* force end of while loop */
                            }
                        else {
                            interleave = atoi (argv[++i]);
                            }
                        if (interleave < 1){
                            fprintf (stderr, "Illegal value for inter-record gap : %d\n", interleave);
                            fprintf (stderr, "Using default value from superblock\n");
                            interleave = 0;
                            }
                        break;

                        /* report i-nodes with
                         * one or more levels of
                         * indirection */
                    case 'i':
                        rpt_indirects = TRUE;
                        break;

                        /* override bad fs test */
                    case 'o':
                        override = TRUE;
                        break;

                    case 'v':
                        version();
			exit(0);

                    default:
                        fprintf (stderr, "illegal option : %c\n", *cp);
                        usage();
                    }
                }
            }
        else {
            special = argv[i];
            special_found = TRUE;
            }
        }
    if (special == NULL)usage();                /* no fs parameter */

    /*
     * open file and make sure we have a good file system
     */
    if (!chk_fs (special))
        exit(1);                /* bad file system, error status */

    /*
     * Set the default block size, if not already set.
     */
    if (block_size == 0){
        block_size = fsize(fil_sys);
        }

    if (interleave == 0){
        interleave = opt_interleave(fil_sys);
        }

    if (cyl_size == 0){
       cyl_size = sec_per_cyl(fil_sys);
       }

    return i;                /* return # of next argument to be processed */
    }

