/*
 *	makedict - Make DBM version of password dictionary
 */

#include <sys/file.h>
#include <stdio.h>
#include <ndbm.h>

extern char	*index();

char	line[80];

main(argc, argv)
char	*argv[];
{
	DBM	*dp;
	int	recs = 0;
	datum	d,
		k;

	dp = dbm_open(argv[1], O_RDWR, 0);
	if (dp == 0) {
		if ((dp = dbm_open(argv[1], O_RDWR|O_CREAT, 0644)) == 0) {
			perror("open dbm");
			exit(1);
		}
	}
	while (!feof(stdin)) {
		char	*p;

		fgets(line, 80, stdin);
		p = index(line, '\n');
		if (p) *p = 0;
		d.dptr = line;
		d.dsize = strlen(line);
		dbm_store(dp, d, d, DBM_INSERT);
		recs++;
	}
	dbm_close(dp);
	printf("%s built, %d records\n", argv[1], recs);
}
