/*
"autoadd" -- a batch account-setter-upper.  for adding whole class
rosters to unix machines.  
by: j. nelson, univ. nc-wilmington, dept. math. sciences, 
wilmington nc 28403,  919-395-3300.

The idea here is to allow a student assistant or other partially
trusted assistant to enter the class roster, and then in one 
swell-foop, add all those folks to the system.  This can be either
permitted to the assistant or reserved to the sysop, but requires
that the program be run as root (at least it does on my machines).

An input file consists of a few "keyword" lines, followed by the
class roster in "lastname fi mi" form.

Keywords :
"prof:ssss"		professor for "accesstab" file
				this is for that neat program that came down the
				wire a while back that allows someone to access
				another directory by effectively "becoming" them.
				If not using, comment out the following line: */
#define ACCESS
/*
"disk:/sssss"	parent directory, e.g. /usr3, /stoonts, etc.
"firstprog:ssss" this will be the last line of .profile
"shell:xxxxx"	shell; 0 means no entry */
#define PROFILE "/.profile" /*will have parentdir prepended*/
#define LOGIN "/.login"
#define STDPROFILE "/etc/stdprofile"
/*
"alias:sssss"	for manually moving into the prof's .mailrc file
"group:nnn"		group
"passwd:xxxxxx" password (will be same for all these users, but salt
				is randomly selected)
"password:xxxx" (same as passwd)
		special case: 1 means use username as password.

Any line containing one of the keywords is processed for the keyword
value.  Null lines, blank lines, and lines beginning with # are ignored.
Other lines are presumed to be name-lines of the form
lastname f m
that is, lastname firstinitial middleinitial
separated by blanks.
The lastname may be of any length, but will be truncated to ML (default
is 7) chars before applying any of the algorithms.  fi and mi should 
be only single characters, but the parser will accept any number, 
and will truncate them to single chars.
Also accepts usernames of the form abc, where abc is the person's
fi mi li, as some system admins like to use, e.g. I would be
"jhn" (James H Nelson), and "Joe Bob College" would be "jbc".  
The program assumes that "jhn" is the lastname, and forces fi 
and mi to be '1' for purposes of the algorithm.
The algorithm first tries lastname, then filastname, then
lastnamefi, then filastnamemi, etc., etc., finally resorting to
prepending digits to usernames if all else fails (this is guaranteed
to work unless you have a huge number of users (!)).  The exact
algorithm is clear from reading the code in tryagain().
See alse the example file.
*/

#include <stdio.h>


/* these next includes probably will not work everywhere */
/* they DO work on SysVr2 (3b2/300) and a BSD4.1-derived
knockoff (lmc -- GENIX on a nsc16032) */
#include <string.h> /*maybe strings.h   ???*/
#include <sys/types.h> /*maybe don't need sys  ??? */
#include <sys/stat.h>  /* ditto */
#include <errno.h> /*only for ENOENT*/ /*if fails, forget it! */

/* next three are individually tunable parameters */
#define MAXNU 1300 /*max number of entries in /etc/passwd */
#define ROOT 0 /* just in case your root is not uid==0 (?weird?) */
#define ML 7  /*maximum length of a login-name.*/
/* 7 is a nice length, 'cause tabs work better, but this can be
 anything within reason */

#define null '\0' /*just for ease of typing*/ /* not same as NULL */

extern void exit(); /* for lint */

#ifdef MAIN /*so only see once; main.c will define MAIN,
but nobody else will*/

/* some of the following might need to be lengthened if sysop
allows ridiculously long login names */

int euid; 
/* euid = geteuid(); */ /*to see if we're dangerous */
/*this will be done very early in main() */
/* Autoadd does slightly different things depending on whether
 user is root or not, e.g. /etc/passwd vs. ./passwd , etc.
 Examine the code carefully before running at all, and then re-
 examine it before running as root. This is not a disk-polisher or
 one of those other nasties, (DO NOT take my word for it, look at
 the code!) but it does have to run as root to be
 effective (not necessarily setuid root, just "effective uid"
 of root), 'cause it must append to /etc/passwd and create
 directories in /"disk". (unless you let just anybody do those
 things!)
*/
/* some defaults:*/
#define GROUP "100" /*why not?*/
#define DISK "/usr4" /*our current place to stash stoonts*/
#define SHELL "0" /* 0 means Bourne shell */
#define ALIAS "csc101" /*we don't have a csc101, so why not?*/
#define FIRSTPROG "0" /* default no startup program */
#define PROFESSOR "nelson"	/* make "0" (with quotes) for none*/
#define PASSWD "0" /*no default password*/
#define DISLIST "./mailrc" /*filename of where to put alias list*/
/*notice that several of the variables default if the first
(i.e. zeroth) character of a string is the character '0' , but the
above defines must be in double-qoutes, not single-quotes, becuz
they're used in strcpy() statements.
A couple of other things: GROUP must be a string, not an integer;
the leading / is optional on DISK (it'll be forced if omitted);
I don't have ksh, so the only way to make it the default is to
hack on the source; be sure the look at ecpw.c closely if worried
about passwords.
*/

/* Global variables: */
char *user[MAXNU],*malloc(); /* we have only about 120, but ...*/
char ecptex[20]; /* large enuff to hold an encrypted password*/
char infile[100]; /*the input filename ... 30 should be plenty*/
char line[142],lastname[50],fi[2],mi[2];
char profname[30],diskname[20],groupname[20],passwordname[20],
	username[40],aliasname[40],firstprog[40],parentdir[40];
char dislist[60],passwd[60],proffile[60] ;
#endif /*MAIN*/
