/*
 * hpfont.h
 * Header for HP LaserJet font manipulation programs.
 */

#include "hpconfig.h"

/*
 * Font descriptor, p. 3-10 of Technical Reference Manual.
 */

typedef struct {
    uint16  f_unu1;		/* 26 */
    uchar   f_unu2;		/* 0 */
    uchar   f_type;		/* 0:7 bit, 1:8 bit */
    uint16  f_unu3;		/* 0 */
    uint16  f_baseline;		/* dots from top of char cell to baseline */
    uint16  f_cwidth;		/* cell width, 1-255 dots */
    uint16  f_cheight;		/* cell height, 1-255 dots */
    uchar   f_orient;		/* 0:portrait, 1:landscape */
    uchar   f_spacing;		/* 0:fixed spacing, 1:proportional */
    /*
     * (symbol set value field number * 32) + (decimal ASCII value for escape
     * sequence terminator, e.g. U, - 64). Symbol set value field numbers are
     * listed on p3-12, Tech Ref Man. 
     */
    uint16  f_symset;
    uint16  f_pitch;		/* horiz dots/char * 4 (@ 300 dpi, 2-1260) */
    uint16  f_height;		/* vertical dots * 4 */
    uint16  f_unu4;		/* 0 */
    uchar   f_unu5;		/* 0 */
    uchar   f_style;		/* 0:upright, 1:italic */
    schar   f_weight;		/* -7 to 7 */
    uchar   f_typeface;		/* 0-10, see table on p. 3-14 */
}       fontdesc;

/*
 * Character descriptor, p. 3-16 of Technical Reference Manual.
 */

typedef struct {
    uchar   c_unu1;		/* 4 */
    uchar   c_unu2;		/* 0 */
    uchar   c_unu3;		/* 14 */
    uchar   c_unu4;		/* 1 */
    uchar   c_orient;		/* 0:portrait, 1:landscape */
    uchar   c_unu5;		/* 0 */
    sint16  c_leftoff;		/* dots, ref pt to left of pat, -128-127 */
    sint16  c_topoff;		/* dots, ref pt to top of pat, -128-127 */
    uint16  c_width;		/* 0-128 dots */
    uint16  c_height;		/* 0-128 dots */
    sint16  c_delta_x;		/* horiz dist in printing char, dots * 4 */
}       chardesc;

/*
 * Variable-length amount of character data.
 */

typedef struct {
    char   *d_data;
    int     d_len;		/* length of d_data in bytes */
}       chardata;
