/*
 * dewidth - decode a troff font width file (/usr/lib/font/ft*)
 * into C source code (written to standard output)
 *
 * Usage: dewidth [-h] ftfile...
 * Options:
 * -h	only print size of object file (hdrb)
 *
 * David MacKenzie
 * Latest revision: 07/24/88
 */

/*
 * HDRBYTES is the number of bytes taken up by the object file header at
 * the top of your troff's font files.  Calculated automatically if you
 * don't define it manually.
 */

#ifndef HDRBYTES
#include <a.out.h>
#endif

#include <stdio.h>

char   *tab[] = {
    "space",
    "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",",
    "- hyphen", ".", "/",
    "0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
    ":", ";", "<", "=", ">", "?", "@",
    "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M",
    "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z",
    "[", "\\", "]", "^", "_", "`",
    "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m",
    "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z",
    "{", "|", "}", "~",
    "narrow space", "hyphen", "bullet", "square", "3/4 em dash", "rule",
    "1/4", "1/2", "3/4", "minus", "fi", "fl", "ff", "ffi", "ffl", "degree",
    "dagger", "section", "foot mark", "acute acc",
    "grave acc", "underrule", "slash",
    "half narrow space", "null", "null", "null", "null", "null", "null",
    "null", "null", "null", "null", "null", "null", "null", "null", "null",
    "null", "null", "null", "null", "null", "null", "null", "null", "null",
    "null", "null", "null", "null", "null", "null", "null", "null", "null",
    "null", "null", "null", "null", "null", "null", "null", "null", "null",
    "null", "null", "null", "null", "null", "null", "null", "null", "null",
    "null", "null", "null", "null", "null", "null", "null", "null", "null",
    "null", "null", "null", "null", "null", "null", "null", "null", "null",
    "null", "registered", "copyright", "null", "cent", "null", "null",
    "null", "null", "null", "null", "null", "null", "null", "null", "null",
    "null", "null", "null", "null", "null", "null", "null", "null", "null",
    "null", "null", "null", "null", "null", "null", "null", "null", "null",
    "null", "null"
};

int     hdrb;

main(argc, argv)
    int     argc;
    char  **argv;
{
    extern int optind;
    register int c;

#ifdef HDRBYTES
    /* Defined manually. */
    hdrb = HDRBYTES;
#else
    /* Calculate automatically. */
    hdrb = sizeof(struct exec);
#endif

    while ((c = getopt(argc, argv, "h")) != EOF)
	switch (c) {
	case 'h':
	    printf("%d\n", hdrb);
	    exit(0);
	default:
	    usage(argv[0]);
	}
    if (optind == argc)
	usage(argv[0]);
    for (; optind < argc; ++optind)
	show(argv[optind]);

    exit(0);
}

show(f)
    char   *f;
{
    char   *malloc();
    FILE   *fp;
    register int c;
    register int cval;
    char   *trash;

    if (hdrb > 0) {
	trash = malloc(hdrb);
	if (!trash) {
	    perror("malloc");
	    exit(1);
	}
    }
    if (!(fp = fopen(f, "r"))) {
	perror(f);
	return;
    }
    printf("char XXw[256-32] = {\n");

    if (hdrb > 0 && fread(trash, hdrb, 1, fp) != 1) {
	perror("fread of header");
	return;
    }
    for (cval = 0; (c = getc(fp)) != EOF && cval <= 223; ++cval)
	if (c & ~077)
	    printf("%d+%04o%s\t/* %s */\n", c & 077, c & ~077,
		cval == 223 ? "" : ",", tab[cval]);
	else
	    printf("%d%s\t\t/* %s */\n", c,
		cval == 223 ? "" : ",", tab[cval]);

    printf("};\n");

    fclose(fp);
}

usage(f)
    char   *f;
{
    fprintf(stderr, "Usage: %s [-h] ftfile...\n", f);
    exit(1);
}
