/* xc
% cc -O hpwidth.c -o hpwidth
% strip hpwidth
 */
/*
 * hpwidth - width display of HP LaserJet font
 * Usage: hpwidth fontfile
 *
 * Output is in the form of C source code.
 *
 * David MacKenzie
 * Latest revision: 07/14/88
 */

/*
 * The widths of the characters are adjusted by SCALE.
 *
 * I did arrive at 0.864 by looking at the versatec driver.  It is
 * (54/25)*(6/10)*(200/300).  I do not know how those numbers came about.
 * -Sverre
 */
#define SCALE 8.64 / ps

#include <stdio.h>
#include "hpfont.h"

main(argc, argv)
    int     argc;
    char  **argv;
{
    if (argc != 2)
	usage(argv[0]);
    dumpfont(argv[1]);

    exit(0);
}

FILE *
openfont(file)
    register char *file;
{
    FILE   *fp;
    char    path[150];

    if (*file != '/')
	strcpy(path, FONTDIR);
    else
	path[0] = 0;
    strcat(path, file);
    if (!(fp = fopen(path, "r"))) {
	perror(path);
	exit(1);
    }
    return fp;
}

dumpfont(file)
    char   *file;
{
    FILE   *openfont();
    FILE   *fp;
    fontdesc fd;
    chardesc cde;
    chardata cda;
    register int ps;		/* Point size. */
    register int ccode;
    register int width;

    fp = openfont(file);

    readfontdesc(fp, &fd);
    /* Points = quarter_dots / 4 * 72 / 300. */
    ps = (int) ((double) fd.f_height * 0.06);

    printf("char XXw [256-32] = {\n");
    printf("12,\t/* space */\n");

    while ((ccode = readchar(fp, &cde, &cda)) != EOF) {
	if (ccode <= '~') {
	    if (index("\"#<>@\\^_{}~", ccode))
		width = 0;
	   else
		width = (int) ((float) cde.c_delta_x / 4.0 * SCALE + 0.5);
	    printf("%d,\t/* %c */\n", width, ccode);
	    free(cda.d_data);
	}
    }
    fclose(fp);

    printf("6,\t\t/* narrow space */\n");
    printf("20,\t\t/* hyphen */\n");
    printf("12,\t\t/* bullet */\n");
    printf("22,\t\t/* square */\n");
    printf("33,\t\t/* 3/4 em dash */\n");
    printf("30,\t\t/* rule */\n");
    printf("18,\t\t/* 1/4 */\n");
    printf("18,\t\t/* 1/2 */\n");
    printf("0,\t\t/* 3/4 */\n");
    printf("20,\t\t/* minus */\n");
    printf("0,\t\t/* fi */\n");
    printf("0,\t\t/* fl */\n");
    printf("0,\t\t/* ff */\n");
    printf("0,\t\t/* ffi */\n");
    printf("0,\t\t/* ffl */\n");
    printf("14,\t\t/* degree */\n");
    printf("16,\t\t/* dagger */\n");
    printf("0,\t\t/* section */\n");
    printf("8,\t\t/* foot mark */\n");
    printf("0,\t\t/* acute acc */\n");
    printf("0,\t\t/* grave acc */\n");
    printf("0,\t\t/* underrule */\n");
    printf("0,\t\t/* slash */\n");
    printf("3,\t\t/* half narrow space */\n");
    for (ccode = 1; ccode <= 70; ++ccode)
	printf("0,\t\t/* null */\n");
    printf("22,\t\t/* registered */\n");
    printf("22,\t\t/* copyright */\n");
    printf("0,\t\t/* null */\n");
    printf("21,\t\t/* cent */\n");
    for (ccode = 1; ccode <= 30; ++ccode)
	printf("0,\t\t/* null */\n");
    printf("0\t\t/* null */\n");
    printf("};	/* from file %s, ps=%d */\n", file, ps);
}

readfontdesc(fp, fdp)
    FILE   *fp;
    fontdesc *fdp;
{
    char    buf[500];		/* Trash receptacle. */
    int     fdlen;		/* No. of bytes in font descriptor. */

    if (fscanf(fp, "\033)s%dW", &fdlen) != 1)
	err("Can't read font creation sequence");
    if (!fread(fdp, sizeof(fontdesc), 1, fp))
	err("Can't read font descriptor");
    if (fdlen > sizeof(fontdesc))
	if (!fread(buf, fdlen - sizeof(fontdesc), 1, fp))
	    err("Can't read continuation of font descriptor");
}

readchar(fp, cdep, cdap)
    FILE   *fp;
    chardesc *cdep;
    chardata *cdap;
{
    char   *Malloc();
    int     ccode;		/* Character code (character number). */
    int     cdlen;		/* No. of bytes in character descriptor. */

    switch (fscanf(fp, "\033*c%dE", &ccode)) {
    case 1:
	break;
    case EOF:
	return EOF;
    default:
	fprintf(stderr, "Can't read character code\n");
	return EOF;
    }
    if (fscanf(fp, "\033(s%dW", &cdlen) != 1)
	err("Can't read character download sequence");
    if (!fread(cdep, sizeof(chardesc), 1, fp))
	err("Can't read character descriptor");
    cdap->d_len = cdlen - sizeof(chardesc);
    cdap->d_data = Malloc(cdap->d_len);
    if (!fread(cdap->d_data, cdap->d_len, 1, fp))
	err("Can't read character data");
    return ccode;
}

char   *
Malloc(size)
    unsigned size;
{
    char   *malloc();
    register char *s;

    if (!(s = malloc(size))) {
	perror("malloc");
	exit(1);
    }
    return s;
}

err(s)
    char   *s;
{
    fprintf(stderr, "%s\n", s);
    exit(1);
}

usage(file)
    char   *file;
{
    fprintf(stderr, "Usage: %s fontfile\n", file);
    exit(1);
}
