/*
 * $Header: spectab.h,v 1.1 85/08/15 15:07:15 ron Exp $
 */

/*
 * spectab.h - Copyright (c) 1985 by Ron Saad
 *
 * This code may be freely distributed in source
 * for non commercial purposes.
 * Please keep this notice intact.
 */

/*
 * $Log:	spectab.h,v $
 * Revision 1.1  85/08/15  15:07:15  ron
 * Initial revision
 * 
 * 
 */

char *spectab[] ={
	/*
	 * these are the names of the characters
	 *  on the Special font, in same order as
	 *  described in the 'Berkeley Font Catalog'.
	 *  The index of the name is supposed to give
	 *  the position of that character in the
	 *  character description table, from which
	 *  we directly grab a pointer to the binary
	 *  bit map starting position.
	 */
	"",	/* space */
	"if",	/* infinity */
	"ip",	/* improper superset */
	"pt",	/* proportional to */
	"rh",	/* right hand */
	"cu",	/* cup (union) */
	"rn",	/* root en extender */
	"bs",	/* bell sign - seems to have disappeared from
		the troff output according to the DWB manual */
	"+-",	/* plus-minus */
	"<=",	/* <= */
	">=",	/* >= */
	"sr",	/* square root */
	"ts",	/* terminal sigma */
	"is",	/* integral sign */
	"sl",	/* slash */
	"bv",	/* bold vertical */
	"lf",	/* left floor (big bracket) */
	"rf",	/* right floor (big bracket) */
	"lc",	/* left ceiling (big bracket) */
	"rc",	/* right ceiling (big bracket) */
	"lt",	/* left top (big brace) */
	"lb",	/* left bottom (big brace) */
	"rt",	/* right top (big brace) */
	"rb",	/* right bottom (big brace) */
	"lk",	/* left center (big brace) */
	"rk",	/* right center (big brace) */
	"sb",	/* subset of */
	"sp",	/* superset of */
	"ca",	/* cap (intersection) */
	"no",	/* not */
	"lh",	/* left hand */
	"mo",	/* member of */
	"",
	"",
	"\"",	/* - not in DWB manual */
	"#",	/* - not in DWB manual */
	"",
	"",
	"",
	"\\'",	/* name not in Berekeley, but looks like
		an accute accent. will never be used since
		"aa" occurs in asctab first. */
	"gr",	/* gradient */
	"",
	"mu",	/* multiply */
	"pl",	/* math plus */
	"",
	"mi",	/* math minus */
	"",
	"di",	/* divide */
	"==",	/* identically equal */
	"~=",	/* approximately equal */
	"ap",	/* approximates */
	"!=",	/* not equal */
	"<-",	/* left arrow */
	"->",	/* right arrow */
	"ua",	/* up arrow */
	"da",	/* down arrow */
	"sc",	/* section */
	"**",	/* math star */
	"",
	"",
	"",	/* really a '<' */
	"eq",	/* name not in Berekeley */
	"",	/* really a '>' */
	"",
	"",	/* looks like the '@' */
	"*A",	/* Alpha (mapped into English on font pos 1) */
	"*B",	/* Betta (mapped into English on font pos 1) */
	"*G",	/* Gamma */
	"*D",	/* Delta */
	"*E",	/* Epsilon (mapped into English on font pos 1) */
	"*Z",	/* Zetta (mapped into English on font pos 1) */
	"*Y",	/* Etta (mapped into English on font pos 1) */
	"*H",	/* Theta */
	"*I",	/* Iotta (mapped into English on font pos 1) */
	"*K",	/* Kappa (mapped into English on font pos 1) */
	"*L",	/* Lambda */
	"*M",	/* Mu (mapped into English on font pos 1) */
	"*N",	/* Nu (mapped into English on font pos 1) */
	"*C",	/* Xi */
	"*O",	/* Omicron (mapped into English on font pos 1) */
	"*P",	/* Pi */
	"*R",	/* Rho (mapped into English on font pos 1) */
	"*S",	/* Sigma */
	"*T",	/* Tau (mapped into English on font pos 1) */
	"*U",	/* Upsilon */
	"*F",	/* Phi */
	"*X",	/* Chi (mapped into English on font pos 1) */
	"*Q",	/* Psi */
	"*W",	/* Omega */
	"dd",	/* double dagger - not in DWB manual */
	"br",	/* box vertical rule */
	"ib",	/* improper subset */
	"\\e",	/* backslash - not in DWB manual */
	"ci",	/* circle */
	"",		/* really a '^' */
	/* "ul",	/* underrule - name not in Berkeley */
	"ru",	/* try a rule - name not in Berkeley */
	"\\`",	/* grave accent ("ga" listed in asctab) */
	"*a",	/* alpha */
	"*b",	/* betta */
	"*g",	/* gamma */
	"*d",	/* delta */
	"*e",	/* epsilon */
	"*z",	/* zetta */
	"*y",	/* etta */
	"*h",	/* theta */
	"*i",	/* iotta */
	"*k",	/* kappa */
	"*l",	/* lambda */
	"*m",	/* mu */
	"*n",	/* nu */
	"*c",	/* xi */
	"*o",	/* omicron */
	"*p",	/* pi */
	"*r",	/* rho */
	"*s",	/* sigma */
	"*t",	/* tau */
	"*u",	/* upsilon */
	"*f",	/* phi */
	"*x",	/* chi */
	"*q",	/* psi */
	"*w",	/* omega */
	"pd",	/* partial derivative */
	"es",	/* empty set */
	"",	/* really a '{' */
	"or",	/* or */
	"",	/* really a '}' */
	"",	/* really a '~' */
	""
};

