/*
 * $Header: glyph.h,v 1.1 85/08/15 15:07:31 ron Exp $
 */

/*
 * $Log:	glyph.h,v $
 * Revision 1.1  85/08/15  15:07:31  ron
 * Initial revision
 * 
 * 
 */

struct f_header
  {
	short		f_magic ;
		/*
		 * Should be 0436 - for vfont. rasti10 uses
		 * just 0 (i think)
		 */
	unsigned short	f_size ;
		/*
		 * Total size of raster section
		 * of the font file.
		 */
		/*
		 * the following are used for vfont, but seem to
		 * be consistently 0 for rasti10. this gives us
		 * a way to distinguish between them.
		 */
	short		f_maxx ;	/* Largest x of character */
	short		f_maxy ;	/* Largest y of character */
	short		f_xtnd ;	/* Largest extender */
  } ;

struct c_param
  {
	unsigned short	c_addr ;
		/*
		 * Offset in file where character
		 * is located. doesn't include the
		 * size of the c_param and f_header
		 * structures - see F_OFFSET below
		 */
	short		c_size ;	/* Size in bytes of character	*/
	char		c_up ;
	char		c_down ;
		/*
		 * c_up + c_down = heigth of raster in
		 * font file, in rows, for vfont. rasti10 wants
		 * c_up + c_down + 1.
		 */
	char		c_left ;
	char		c_right ;
		/*
		 * c_right + c_left = width of raster in
		 * font file, in bits (dots), for vfont. rasti10 wants
		 * c_right + c_left + 1.
		 */
	char		c_width ;
		/*
		 * Width, including space required
		 * to print character.
		 * rasti10 may not use this. be careful.
		 */
  } ;


#define	F_OFFSET	((long)(sizeof(struct f_header)+ \
			    256*sizeof(struct c_param)))
