/***********************************************************************
*                                                                      *
*     TABLE - A PROGRAM TO PREPARE NROFF DRIVER TABLES                 *
*     copyright (c) 1985 by Bruce Townsend and Bell Northern Research  *
*     Permission hereby granted to use, distribute, modify, or copy    *
*     except for profit, providing this disclaimer is included.        *
*                                                                      *
*                                                                      *
*     Please send bug reports to Bruce Townsend (utcs!bnr-vpa!bruce)   *
*                                                                      *
*     Usage: 1) Modify this source to initialize the "t" structure.    *
*            2) If the amount of char data that the structure          *
*               references is very large, you may want to redefine     *
*               C_SIZE                                                 *
*            3) check to see whether <sgtty.h> or <termio.h> should    *
*               be #included. One of these include files may be        *
*               necessary to provide settings for t.bset, t.breset     *
*            4) Compile this source:                                   *
*                   cc -O table -o table.c                             *
*            5) Run the program as "table filename", where filename    *
*               is of the form "tab*", as in: "tab450"                 *
*            6) Locate the tabfile in the proper place (on our system  *
*               the directory is /usr/lib/term                         *
*                                                                      *
*	Date: Mon Feb 25 1985                                          *
***********************************************************************/
#include	<stdio.h>
#include	<termio.h>	/* ... or use <sgtty.h> */
/* #include	<sgtty.h>	/* ... or use <termio.h> */

#define C_SIZE	10000	/* The maximum amount of character data allowed
			   in the initialized structure t - increase if
			   necessary */

#define	INCH	240
struct {			/* Initialize this structure */
	int bset;
	int breset;
	int Hor;
	int Vert;
	int Newline;
	int Char;
	int Em;
	int Halfline;
	int Adj;
	char *twinit;
	char *twrest;
	char *twnl;
	char *hlr;
	char *hlf;
	char *flr;
	char *bdon;
	char *bdoff;
	char *iton;
	char *itoff;
	char *ploton;
	char *plotoff;
	char *up;
	char *down;
	char *right;
	char *left;
	char *codetab[256-32];
	char *zzz;
} t = {
	/*****************************************************************
	*                                                                *
	*   The following is a partial initialization for a Diablo 630   *
	*   in proportional mode using a Bold Roman printwheel. It is    *
	*   included as an example only, as is not guaranteed to work    *
	*   properly.                                                    *
	*                                                                *
	*****************************************************************/
	NULL, ONLCR | OCRNL | ONLRET,
	INCH / 60, INCH / 48, INCH / 6, INCH / 60,
	INCH / 12, INCH / 12, INCH / 60,
	"\0334\033\\", "\0334\033/", "\r\n", "\033D", "\033U", "\033\n",
	"\033W", "\033&", "", "", "\0333", "\0334", "\033\n", "\n", " ", "\b",

	"\005 ", "\205}", "\204\"", "\206#", "\205$", "\210%", "\207&", "\202'",
	"\203(", "\203)", "\205*", "\205+", "\203,", "\204-", "\203.", "\204/",

	"\2050", "\2051", "\2052", "\2053", "\2054", "\2055", "\2056", "\2057",
	"\2058", "\2059", "\203:", "\203;", "\205[", "\205=", "\206~", "\205?",

	"\206 ", "\207A", "\206B", "\207C", "\207D", "\206E", "\206F", "\207G",
	"\207H", "\203I", "\205J", "\207K", "\206L", "\210M", "\207N", "\207O",

	"\206P", "\207Q", "\207R", "\205S", "\206T", "\207U", "\206V", "\210W",
	"\207X", "\207Y", "\206Z", "\203`", "\206 ", "\203}", "\206 ", "\205_",

	"\206 ", "\205a", "\205b", "\205c", "\205d", "\205e", "\204f", "\205g",
	"\205h", "\203i", "\203j", "\205k", "\203l", "\210m", "\205n", "\205o",

	"\205p", "\205q", "\204r", "\204s", "\204t", "\205u", "\205v", "\207w",
	"\205x", "\205y", "\205z", "\206 ", "\203!", "\206 ", "\206 ", "",

	"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",

	NULL
	};

/************* DO NOT ALTER ANYTHING AFTER THIS POINT ***************/

struct {		/* This structure will be stored in the tab file */
	int bset;
	int breset;
	int Hor;
	int Vert;
	int Newline;
	int Char;
	int Em;
	int Halfline;
	int Adj;
	int twinit;
	int twrest;
	int twnl;
	int hlr;
	int hlf;
	int flr;
	int bdon;
	int bdoff;
	int iton;
	int itoff;
	int ploton;
	int plotoff;
	int up;
	int down;
	int right;
	int left;
	int codetab[256-32];
	int zzz;
} t_stor;

char	c_data[C_SIZE];
char	*c_pointer[256];
char	*c_end = c_data;
int	n_strings, c_size;

main (argc, argv)
int	argc;
char	*argv[];
{
	FILE	*table;
	int	i, j, i_len, j_len;
	char	*tail, *strcpy();

	if (argc != 2) {	/* Need a file name argument */
	    fprintf (stderr, "Usage: table \"file\"\n");
	    exit (1);
	    }

	/* Open the file */
	if ((table = fopen (argv[1], "w")) == NULL) {
	    fprintf (stderr, "File %s not opened for writing\n", argv[1]);
	    exit (1);
	    }

	/* Copy the integer values from the initialized structure
	   to the storage structure */
	t_stor.bset = t.bset;
	t_stor.breset = t.breset;
	t_stor.Hor = t.Hor;
	t_stor.Vert = t.Vert;
	t_stor.Newline = t.Newline;
	t_stor.Char = t.Char;
	t_stor.Em = t.Em;
	t_stor.Halfline = t.Halfline;
	t_stor.Adj = t.Adj;

	/* Add the character strings into a character array */
	addstring (t.twinit);
	addstring (t.twrest);
	addstring (t.twnl);
	addstring (t.hlr);
	addstring (t.hlf);
	addstring (t.flr);
	addstring (t.bdon);
	addstring (t.bdoff);
	addstring (t.iton);
	addstring (t.itoff);
	addstring (t.ploton);
	addstring (t.plotoff);
	addstring (t.up);
	addstring (t.down);
	addstring (t.right);
	addstring (t.left);
	for (i = 0; i < 256 - 32; i++) addstring (t.codetab[i]);

	/* eliminate strings which are tails of other strings */
	for (i = 0; i < n_strings; i++) {
	    i_len = strlen (c_pointer[i]);
	    for (j = 0; j < n_strings; j++) {
		if (i == j) continue;
		j_len = strlen (c_pointer[j]);
		if (i_len <= j_len) {	/* string i could be tail of string j */
		    tail = c_pointer[j] + j_len - i_len;
		    if (! strcmp (c_pointer[i], tail)) {
			clearstring (c_pointer[i]);
			break;
			}
		    }
		}
	    }

	/* Compress the c_data array to eliminate strings of nulls */
	for (i = j = 0; i < n_strings; i++) {
	    if (! *c_pointer[i]) continue;
	    tail = strlen (strcpy (c_pointer[j], c_pointer[i])) +
		    c_pointer[j] + 1;
	    c_pointer[++j] = tail;
	    }

	c_size = c_pointer[j] - c_data;	/* The amount of data to be stored */

	/* Now find each string in this table and provide an index to it */
	t_stor.twinit = findstring (t.twinit);
	t_stor.twrest = findstring (t.twrest);
	t_stor.twnl = findstring (t.twnl);
	t_stor.hlr = findstring (t.hlr);
	t_stor.hlf = findstring (t.hlf);
	t_stor.flr = findstring (t.flr);
	t_stor.bdon = findstring (t.bdon);
	t_stor.bdoff = findstring (t.bdoff);
	t_stor.iton = findstring (t.iton);
	t_stor.itoff = findstring (t.itoff);
	t_stor.ploton = findstring (t.ploton);
	t_stor.plotoff = findstring (t.plotoff);
	t_stor.up = findstring (t.up);
	t_stor.down = findstring (t.down);
	t_stor.right = findstring (t.right);
	t_stor.left = findstring (t.left);
	for (i = 0; i < 256 - 32; i++) {
	    t_stor.codetab[i] = findstring (t.codetab[i]);
	    }
	t_stor.zzz = 0;

	/* Write the character storage block size */
	if (fwrite (&c_size, sizeof (c_size), 1, table) != 1)
	    write_err ();

	if (fwrite (&t_stor, sizeof (t_stor), 1, table) != 1)
	    write_err ();

	if (fwrite (c_data, sizeof (*c_data), c_size, table) != c_size)
	    write_err ();

	if (fclose (table)) {
	    fprintf (stderr, "File %s not closed properly\n", argv[1]);
	    exit (1);
	    }
	}

addstring (string)
char	*string;
{
	c_pointer[n_strings] = c_end;
	c_end += strlen (string) + 1;
	if (c_end >= c_data + C_SIZE) {
	    fprintf (stderr, "Table size too small, increase it!/n");
	    exit(1);
	    }
	strcpy (c_pointer[n_strings++], string);
}

clearstring (string)
char	*string;
{
	while (*string) *string++ = 0;
}

findstring (string)
char	*string;
{
	int	c_len, s_len, i;

	for (i = 0; c_pointer[i]; i++) {
	    if ((c_len = strlen (c_pointer[i])) >= (s_len = strlen (string))) {
		if (!strcmp (string, c_pointer[i] + c_len - s_len))
		    return (c_pointer[i] + c_len - s_len - c_data);
		}
	    }
	fprintf (stderr, "Serious bug! string not found in table\n");
	exit(1);
	/* NOT REACHED */
	}



write_err () {
	fprintf (stderr, "Write to file failed\n");
	exit (1);
	}
