/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: termclear.c
 ***************************************************************************
 * Revision History: Created Mon Feb  1 18:06:56 CST 1988
 * $Log:	termclear.c,v $
 * Revision 3.1  88/06/18  09:35:54  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.1  88/05/09  10:10:38  papowell
 * PLP: Released Version
 * 
 * Revision 1.3  88/04/08  08:49:17  papowell
 * Added <sys/types.h>, <sgtty.h> to includes
 * 
 * Revision 1.2  88/03/11  19:29:41  papowell
 * Minor Changes, Updates
 * 
 * Revision 1.1  88/03/01  11:09:26  papowell
 * Initial revision
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: termclear.c,v 3.1 88/06/18 09:35:54 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint

/***************************************************************************
 * Term_clear()
 * 1. Do the initialization if neccessary
 * 2. clear the screen using the termcap information
 * This code was taken from "Screen Updating and Cursor Movement Optimization
 * A Library Package", by Ken. C. Arnold;  with 4.3BSD Release,
 * Programmers Reference Manual
 ***************************************************************************/
static int tinit_done;
static int is_term;

#ifdef TERMCAP
#include <stdio.h>
#include <sys/types.h>
#include <sgtty.h>
#include <curses.h>

char *getenv();
extern int XLOG_INFO;
/***************************************************************************
 * definitions for TERMCAP
 ***************************************************************************/
char bp[1024];
char xp[1024];
char *area = xp;
short ospeed;
struct sgttyb sbuf;
char *TI;
char *TE;
char *CL;
char *tgetstr();

pputs( c )
	int c;
{
	putchar( c );
}


Term_clear()
{
	char *sp;
	if( tinit_done == 0 ){
		tinit_done = 1;
		/*
		 * set things up
		 */
		if( isatty(0) && (sp = getenv( "TERM" )) != NULL ){
			/* get the speed */
			if( ioctl(1, TIOCGETP, &sbuf) < 0 ){
				logerr_die( XLOG_INFO,"ioctl on output failed" );
			}
			ospeed = sbuf.sg_ospeed;
			if( tgetent( bp, sp ) > 0 ){
				TI = tgetstr( "ti", &area );
				TE = tgetstr( "te", &area );
				CL = tgetstr( "cl", &area );
			}
			if( TI ){
				tputs( TI, 0, pputs );
			}
			is_term = 1;
		}
	}
	if( is_term && CL ){
		tputs( CL, 0, pputs );
	}
}

Term_finish()
{
	if( is_term && TE ){
			tputs( TE, 0, pputs );
	}
}
#else TERMCAP
Term_clear()
{ ; }
Term_finish()
{ ; }
#endif TERMCAP
