/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: startserver.c
 * send a "start" message to the LPD server
 ***************************************************************************
 * Revision History: Created Sun Jan 24 06:32:54 CST 1988
 * $Log:	startserver.c,v $
 * Revision 3.1  88/06/18  09:35:52  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.1  88/05/09  10:10:34  papowell
 * PLP: Released Version
 * 
 * Revision 1.3  88/04/06  12:13:02  papowell
 * Minor updates, changes in error message formats.
 * Elimination of the AF_UNIX connections, use AF_INET only.
 * Better error messages.
 * 
 * Revision 1.2  88/03/25  15:01:53  papowell
 * Debugged Version:
 * 1. Added the PLP control file first transfer
 * 2. Checks for MX during file transfers
 * 3. Found and fixed a mysterious bug involving the SYSLOG facilities;
 * 	apparently they open files and then assume that they will stay
 * 	open.
 * 4. Made sure that stdin, stdout, stderr was available at all times.
 * 
 * Revision 1.1  88/03/01  11:09:22  papowell
 * Initial revision
 * 
 ***************************************************************************/
/***************************************************************************
 * Startserver()
 * This originally used to use the UNIX domain sockets,  but now uses the
 * AF_INET domain sockets.  The actual sending is done by calling
 * Remote_start,  after setting the RP (remote printer) and RM fields
 * appropriately.
 * 1. Save the RP and RM values.
 * 2. Set RP to Printer and RM to Host
 * 3. If you are running NW, start the remote one
 * 4. Send the start message.
 * 5. Restore RP and RM
 * 6. Return success indication
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: startserver.c,v 3.1 88/06/18 09:35:52 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint
#include "lp.h"

Startserver()
{
	char *old_RP, *old_RM;			/* original RP and RM values */

	old_RP = RP;
	old_RM = RM;

	RP = Printer;
	RM = Host;
	if( NW ){
		RP = old_RP;
		RM = old_RM;
	}
	if( Remote_start() == 0 ){
		logerr(XLOG_INFO,"Startserver: host '%s' server for '%s' not started",
			Host, Printer);
	}
	RP = old_RP;
	RM = old_RM;
}
