/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: sendmail.c
 * send mail to user on completion of a job
 ***************************************************************************
 * Revision History: Created Fri Jan 15 15:17:10 CST 1988
 * $Log:	sendmail.c,v $
 * Revision 3.1  88/06/18  09:35:36  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.1  88/05/09  10:10:13  papowell
 * PLP: Released Version
 * 
 * Revision 1.3  88/04/06  12:13:55  papowell
 * Minor updates, changes in error message formats.
 * Elimination of the AF_UNIX connections, use AF_INET only.
 * Better error messages.
 * 
 * Revision 1.2  88/03/25  15:01:36  papowell
 * Debugged Version:
 * 1. Added the PLP control file first transfer
 * 2. Checks for MX during file transfers
 * 3. Found and fixed a mysterious bug involving the SYSLOG facilities;
 * 	apparently they open files and then assume that they will stay
 * 	open.
 * 4. Made sure that stdin, stdout, stderr was available at all times.
 * 
 * Revision 1.1  88/03/01  11:09:14  papowell
 * Initial revision
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: sendmail.c,v 3.1 88/06/18 09:35:36 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint

#include "lp.h"

/*
 * sendmail ---
 *   tell people about job completion
 * 1. fork a sendmail process
 * 2. if successful, send the good news
 * 3. if unsuccessful, send the bad news
 */
sendmail(q, status)
	struct queue *q;
	int status;
{
	static int p[2];	/* pipe */
	int i;				/* ACME Integer, Inc. */
	char buf[100];
	FILE *mail;			/* mail file */
	int pid;			/* sendmail process */
	union wait stat;	/* daughter status */

	(void)sprintf(buf, "%s %s", MAIL, MAILNAME );
	if(Debug>3)log( XLOG_DEBUG, "mail command: %s", buf );
	if( pipe(p) < 0 ){
		logerr_die( XLOG_NOTICE, "pipe failed for sendmail" );
	}
	/*
	 * start up sendmail process
	 */
	if((pid = fork()) == 0){
		if( p[0] ){
			if( dup2(p[0], 0) < 0 ){
				logerr_die( XLOG_NOTICE, "dup2 failed in sendmail child" );
			}
			(void)close(p[0]);
		}
		(void)close(p[1]);
		mexecv(buf);
		logerr_die(XLOG_INFO, "exec mail failed: %s", buf);
	} else if(pid < 0) {				/* parent */
		logerr_die( XLOG_NOTICE, "sendmail: fork failed" );
	}
	(void)close(p[0]);
	if( (mail = fdopen(p[1], "w")) == NULL ){
		logerr_die( XLOG_NOTICE, "sendmail: fdopen failed" );
	}
	(void)fprintf(mail,"To: %s@%s\n", q->q_user, &q->q_from);
	(void)fprintf(mail,"Subject: %s printer job\n\n", Printer);
	(void)fprintf(mail,"Your %s printer job %d (%s)",Printer,
		q->q_num, q->q_data);
	switch(  status ){
		case JSUCC:
			(void)fprintf( mail, " was successful.\n" );
			break;
		case JFAIL:
			(void)fprintf( mail, " failed, and retry count was exceeded.\n" );
			(void)fprintf( mail, "%s\n", Last_errormsg );
			break;
		default:
			(void)fprintf( mail, " died a horrible death.\n");
			(void)fprintf( mail, "%s\n", Last_errormsg );
			break;
	}
	(void) fflush(mail);
	(void) fclose(mail);
	while ((i = wait(&stat)) > 0 && i != pid){
		if(Debug>3)log( XLOG_DEBUG, "sendmail: caught %d, (%s)", i,
			Decode_status(&stat));
	}
	if(Debug>3)log( XLOG_DEBUG, "sendmail: %d finished (%s)",
		i,Decode_status(&stat) );
}
