/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: mexecv.c
 * ExecrV a la 4 BSD for brain damaged System V
 ***************************************************************************
 * Revision History: Created Sat Jan  9 15:23:23 CST 1988
 * $Log:	mexecv.c,v $
 * Revision 3.1  88/06/18  09:35:11  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.1  88/05/09  10:09:36  papowell
 * PLP: Released Version
 * 
 * Revision 1.6  88/04/28  11:02:48  papowell
 * removed unused variables,  shuts up lint
 * 
 * Revision 1.5  88/04/27  20:24:08  papowell
 * Modified the SYSV Braindamaged mode to invoke shells better.
 * The invocation is rather odd, but appears to work.
 * 
 * Revision 1.4  88/03/25  15:00:52  papowell
 * Debugged Version:
 * 1. Added the PLP control file first transfer
 * 2. Checks for MX during file transfers
 * 3. Found and fixed a mysterious bug involving the SYSLOG facilities;
 * 	apparently they open files and then assume that they will stay
 * 	open.
 * 4. Made sure that stdin, stdout, stderr was available at all times.
 * 
 * Revision 1.3  88/03/11  19:29:44  papowell
 * Minor Changes, Updates
 * 
 * Revision 1.2  88/03/05  15:00:56  papowell
 * Minor Corrections,  Lint Problems
 * 
 * Revision 1.1  88/03/01  11:08:56  papowell
 * Initial revision
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: mexecv.c,v 3.1 88/06/18 09:35:11 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint

/***************************************************************************
 * ExecrV a la 4 BSD for brain damaged System V
 * Sun Dec  6 20:04:57 CST 1987 Patrick Powell
 * This is a massive hack, based on all sorts of checks and balances.
 *
 * 1. First, we try blinding using exev()
 * 2. Next, we check the perms; if not executable, tough.
 * 3. Next we try to read the file;  if not readable, tough.
 * 4. We read the first character of the file.
 * 5. If it is not #, use Bourne shell;
 * 6. We check for the #!; if not, we use CSH
 * 7. We get the pathname of the file, and args, and use that.
 */
#include "lp.h"

mexecv( command)
	char *command;
{
	int i;		/* ACME Integer, Inc. */
	struct stat statb;
	FILE *fp;
	char buf[BUFSIZ];
	char cmd[BUFSIZ];
	char *cp;
	char *args[100];
	char **argv = args+2;
	char *option = 0;
	char *fname;
	char *path;

	/*
	 * close all the file descriptors
	 */
	for( i = 3; i < NOFILE; ++i){
		(void)close(i);
	}
	/*
	 * split command line up
	 */
	(void)strcpy(cmd,command);
	if( getwords(cmd, argv, 98) == 0 ){
		log(XLOG_INFO,"mexecv: invalid argv passed, command %s",command);
		return;
	}
	if(Debug>4){
		char **s, b[BUFSIZ];
		(void)sprintf(b,"mexecv: ");
		for( s = argv; *s; ++s){
			(void)sprintf(b+strlen(b),"'%s' ",*s);
		}
		log(XLOG_DEBUG,"%s",b);
	}
	execv( argv[0],argv );

	if(Debug>4)logerr(XLOG_DEBUG,"mexecv: execv failed" );

	/*
	 * well, that didn't work, lets try the shell options
	 */
	fname = argv[0];
	if( stat(fname, &statb) < 0 ){
		logerr( XLOG_INFO,"mexecv: cannot stat %s", fname );
		return;
	}
	if(Debug>4)log(XLOG_DEBUG,
		"mexecv: %s, perms %o, st_uid %d, st_gid %d, uid %d, gid %d",
		fname,statb.st_mode &0777, statb.st_uid, statb.st_gid,
			getegid(), geteuid());
	if(! (statb.st_mode & 0001)
		&& !((statb.st_mode & 0010) && statb.st_gid == getegid())
		&& !((statb.st_mode & 0100) && statb.st_uid == geteuid())){
		log( XLOG_INFO,"mexecv: %s has no valid execute perms",fname);
		return;
	}
	fp = fopen( fname, "r" );
	if( fp == NULL ){
		logerr(XLOG_INFO,"mexecv: cannot open %s for reading and failed execv",
			fname);
		return;
	}
	if( fgets( buf, sizeof(buf), fp ) == NULL
		|| (cp = index(buf, '\n')) == NULL ){
		/* empty file , bad format */
		log( XLOG_INFO,"mexecv: bad format %s", fname );
		return;
	}
	(void)fclose(fp);
	*cp = 0;
	if( buf[0] != '#' ){
		path = "/bin/sh";
	} else {
		/* check for the #! magic number */
		if( buf[1] != '!' ){
			/* use csh, be paranoid, and sure */
			path = "/bin/csh";
		} else {
			/* we have an explicit path Name formed */
			for( path = &buf[2]; *path && isspace(*path); ++path);
			/* path points to the start of the command */
			if( *path == 0 ){
				log( XLOG_INFO,"mexecv: bad format %s", path );
				return;
			}
			/* look for the end of the command */
			for( cp = path; *cp && !isspace(*cp); ++cp );
			if( *cp ){
				/* we have options */
				*cp = 0;
				for( ++cp; *cp && isspace(*cp); ++cp);
				option = cp;
				++cp;
				for( ++cp; *cp && !isspace(*cp); ++cp);
				*cp = 0;
			}
		}
	}
	if( strcmp( path, "/bin/csh" ) == 0 ){
		/* we are using csh */
		if( option == 0 ){
			option = "-f";
		} else {
			(void)strcat(option, "f");
		}
	} else if (strcmp( path, "/bin/sh") == 0 ){
		/*
		 * nothing
		 */
		;
	} else {
		fatal( XLOG_INFO,"mexecv: shell (%s) not /bin/csh or /bin/sh", path );
	}
	if( option ){
		--argv;
		argv[0] = option;
	}
	--argv;
	argv[0] = fname;
	if(Debug>4){
		char **s, b[BUFSIZ];
		(void)sprintf(b,"mexecv: path '%s'", path);
		for( s = argv; *s; ++s){
			(void)sprintf(b+strlen(b),"'%s' ",*s);
		}
		log(XLOG_DEBUG,"%s",b);
	}
	execv( path,argv );
	logerr_die(XLOG_INFO,"mexecv: execv failed '%s'", path);
}


/*
 * getwords splits a string up into words, and returns a non-null
 * pointer if there are any.
 * Note that splitting is done on a crude basis of matched quotes only
 */
int
getwords(s, argv, maxargc)
	char *s;	/* string containing isspace separated words */
	char *argv[];
	int maxargc;
{
	char **w;
	char *tp = s;
	int num_words = 0;

	if (s==NULL || *s == 0 )
		return(0);
	while (*tp) {
		while(*tp && isspace(*tp))
			++tp;
		if (*tp == 0) continue;
		num_words++;
		if( *tp == '\'' ){
			if( (tp = index( tp+1, '\'')) == 0 ){
				log(XLOG_INFO,"getwords: unmatched ' in string: %s", s );
				return(0);
			}
			++tp;
		} else if( *tp == '\"' ){
			if( (tp = index( tp+1, '\"')) == 0 ){
				log(XLOG_INFO,"getwords: unmatched ' in string: %s", s );
				return(0);
			}
			++tp;
		} else  {
			while ((*tp) && !isspace(*tp))
			++tp;
		}
	}
	if (num_words==0)
		return(0);
	if( num_words > maxargc ){
		log(XLOG_INFO,"getwords: more than %d arguments" );
		return(0);
	}
	w = argv;
	while(*s) {
		while(*s && isspace(*s))
			++s;
		if (*s == 0) {
			*w = NULL;
			return(1);
		}
		if( *s == '\'' ){
			*w++ = s+1;
			s = index( s+1, '\'');
			*s++ = 0;
		} else if( *s == '\"' ){
			*w++ = s+1;
			s = index( s+1, '\"');
			*s++ = 0;
		} else  {
			*w++ = s;
			while ((*s) && !isspace(*s))
				++s;
			if( *s ) *s++ = '\0';
		}
	}
	*w = NULL;
	return(1);
}
