/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: lprm.c
 * lprm- remove files
 ***************************************************************************
 * Revision History: Created Mon Jan 25 14:04:26 CST 1988
 * $Log:	lprm.c,v $
 * Revision 3.1  88/06/18  09:35:07  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.2  88/05/14  10:20:53  papowell
 * Modified -X flag handling
 * 
 * Revision 2.1  88/05/09  10:09:32  papowell
 * PLP: Released Version
 * 
 * Revision 1.6  88/04/27  18:02:41  papowell
 * The SIGCHLD signal has an odd behaviour on some systems.  Modified so that
 * it will not get set UNLESS processes are started;  also,  it is reset
 * to SIG_DFL, not SIG_IGN.
 * 
 * Revision 1.5  88/04/15  13:06:06  papowell
 * Std_environ() call added, to ensure that fd 0 (stdin), 1 (stdout), 2(stderr)
 * have valid file descriptors;  if not open, then /dev/null is used.
 * 
 * Revision 1.4  88/04/06  12:12:39  papowell
 * Minor updates, changes in error message formats.
 * Elimination of the AF_UNIX connections, use AF_INET only.
 * Better error messages.
 * 
 * Revision 1.3  88/03/25  15:00:48  papowell
 * Debugged Version:
 * 1. Added the PLP control file first transfer
 * 2. Checks for MX during file transfers
 * 3. Found and fixed a mysterious bug involving the SYSLOG facilities;
 * 	apparently they open files and then assume that they will stay
 * 	open.
 * 4. Made sure that stdin, stdout, stderr was available at all times.
 * 
 * Revision 1.2  88/03/11  19:27:59  papowell
 * Minor Changes, Updates
 * 
 * Revision 1.1  88/03/01  11:08:55  papowell
 * Initial revision
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: lprm.c,v 3.1 88/06/18 09:35:07 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint
#include "lp.h"

extern int cleanup();

main(argc, argv)
	int argc;
	char **argv;
{
	struct passwd *pw_ent;		/* user entry in /etc/passwd */

	/*
	 * set umask to avoid problems with user umask
	 */
	(void)umask(0);
	/*
	 * Set fd 0, 1, 2 to /dev/null if not open
	 */
	Std_environ();
#	ifdef XPERIMENT
		Setup_test();
#	endif XPERIMENT
	/*
     * set up the pathnames for information files
	 */
	Tailor_names();
	/*
	 * set up the From information
	 */
	From = Host;
	/*
	 * get the user information
	 */
	if( (pw_ent = getpwuid( getuid() )) == 0 ){
		logerr_die( XLOG_INFO, "getpwuid failed on uid %d", getuid());
	}
	(void)strcpy( LOGNAME, pw_ent->pw_name );
	Person = LOGNAME;
	if( getuid() == 0 ){
		/* we are being invoked by root */
		Is_root = 1;
	}
	/*
	 * setup parameters
	 */
	Lprm_parms(argc, argv);
	/*
	 * set signals
	 */
	(void)signal(SIGPIPE, SIG_IGN);
	(void)signal(SIGHUP, cleanup);
	(void)signal(SIGINT, cleanup);
	(void)signal(SIGQUIT, cleanup);
	(void)signal(SIGTERM, cleanup);
	if( Parmcount != 0 ){
		rmjob();
	}
	exit( 0 );
}

/***************************************************************************
 * cleanup()
 * remove the temp files
 ***************************************************************************/

cleanup()
{
	exit( 1 );
}

/***************************************************************************
 * Lprm_parms( int arc, char **argv )
 * 1. pick off the options
 * 2. set up the parameters
 ***************************************************************************/

static char *optstr = "P:D:Xa";
static int Xpert;
static int all_flag;
Lprm_parms( argc, argv )
	int argc;
	char **argv;
{
	int option;
	char *s;
	int i;

	while( (option = Getopt(argc,argv,optstr)) != EOF ){
		switch( option ){
		case 'D':
			if(Debug){
				Diemsg("Duplicate -D option");
			}
			if( sscanf( Optarg, "%d", &Debug ) != 1 || Debug <= 0){
				Diemsg("-D parameter is not positive integer" );
			}
			break;
		case 'X':
			if( Xpert ){
				Diemsg("Duplicate -X option");
			}
#			ifdef DEBUG
				Setup_test();
				Tailor_names();
#			else
				Diemsg( "-X not allowed" );
#			endif DEBUG
			break;
		case 'P':
			if( Printer ){
				Diemsg("Duplicate -P option");
			}
			Printer = Optarg;
			break;
		case 'a':
			if( all_flag ){
				Diemsg("Duplicate -a option");
			}
			all_flag = 1;
			break;
		case '?':
			break;
		default:
			fatal(XLOG_INFO, "Lprm_parms: badparm %c", option );
		}
	}

	/*
	 * set up the Parms[] array
	 */
	for( ; Optind < argc; ++Optind ){
		if( Parmcount < MAXPARMS ){
			s = argv[Optind];
			Parms[Parmcount].str = s;
			if( isdigit( *s )){
				Parms[Parmcount].num = atoi(s);
			} else {
				Parms[Parmcount].num = -1;
			}
			++Parmcount;
		} else {
			Diemsg( "too many files to print; break job up" );
		}
	}
	/*
	 * get the default printer
	 */
	Get_Printer(0);
	/*
	 * check for the all option
	 */
	if( all_flag ){
		if( Parmcount > 0 ){
			Diemsg("-a cannot be combined with other options" );
		}
		Parms[0].str = "-all";
		Parmcount = 1;
	}
	if(Debug>4){
		(void)fprintf(stdout,"Printer %s, Parmcount %d ", Printer, Parmcount );
		for( i = 0; i < Parmcount; ++i )
			(void)fprintf(stdout," '%s'(%d)",Parms[i].str, Parms[i].num ); 
		(void)fprintf(stdout,"\n"); (void)fflush(stdout);
	}
}
