/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: lpq.c
 ***************************************************************************
 * Revision History: Created Mon Feb  1 11:34:11 CST 1988
 * $Log:	lpq.c,v $
 * Revision 3.2  88/07/01  15:44:39  papowell
 * Added multiple -P parameters
 * 
 * Revision 3.1  88/06/18  09:34:43  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.2  88/05/14  10:20:56  papowell
 * Modified -X flag handling
 * 
 * Revision 2.1  88/05/09  10:08:54  papowell
 * PLP: Released Version
 * 
 * Revision 1.7  88/04/28  11:03:01  papowell
 * removed unused variables,  shuts up lint
 * 
 * Revision 1.6  88/04/27  18:02:50  papowell
 * The SIGCHLD signal has an odd behaviour on some systems.  Modified so that
 * it will not get set UNLESS processes are started;  also,  it is reset
 * to SIG_DFL, not SIG_IGN.
 * 
 * Revision 1.5  88/04/15  13:06:14  papowell
 * Std_environ() call added, to ensure that fd 0 (stdin), 1 (stdout), 2(stderr)
 * have valid file descriptors;  if not open, then /dev/null is used.
 * 
 * Revision 1.4  88/04/07  12:26:49  papowell
 * modified to use Getopt
 * 
 * Revision 1.3  88/03/25  15:00:11  papowell
 * Debugged Version:
 * 1. Added the PLP control file first transfer
 * 2. Checks for MX during file transfers
 * 3. Found and fixed a mysterious bug involving the SYSLOG facilities;
 * 	apparently they open files and then assume that they will stay
 * 	open.
 * 4. Made sure that stdin, stdout, stderr was available at all times.
 * 
 * Revision 1.2  88/03/11  19:28:16  papowell
 * Minor Changes, Updates
 * 
 * Revision 1.1  88/03/01  11:08:39  papowell
 * Initial revision
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: lpq.c,v 3.2 88/07/01 15:44:39 papowell Locked $ PLP Copyright 1988 Patrick Powell";
#endif lint
#include "lp.h"

/***************************************************************************
 *   lpq - spool queue examination program
 *   lpq [-Pprinter ][-a][-l][+[n]][-D[n]][-X][ job # ... ][ user ... ]
 * DESCRIPTION
 *   lpq examines the spooling area used by lpd(8) for printing
 *   files on the line printer, and reports the status of the
 *   specified jobs or all jobs associated with a user. lpq
 *   invoked without any arguments reports on the printer given
 *   by the default printer (see -P option).  For each job sub-
 *   mitted (i.e. invocation of lpr(1)) lpq reports the user's
 *   name, current rank in the queue, the names of files compris-
 *   ing the job, the job identifier (a number which may be sup-
 *   plied to lprm(1) for removing a specific job), and the total
 *   size in bytes.  Job ordering is dependent on the algorithm
 *   used to scan the spooling directory and is FIFO (First in
 *   First Out), in order of priority level.  File names compris-
 *   ing a job may be unavailable (when lpr(1) is used as a sink
 *   in a pipeline) in which case the file is indicated as
 *   ``(stdin)''.  The following options are available.
 *   -P printer  spool queue name
 *   -a   All printers listed in /etc/printcap(5) file are reported.
 *   -l   aLternate display format
 *   [+[n]] redisplay the spool queue
 *   -D[n]  debug level n
 *   -X   Use an Xperimental version of LPD
 *   [ job # ... ][ user ... ]
 ***************************************************************************/

static int Delay;	/* time to wait */
static int Do_all_pr;		/* do all printers */
static int Xpert;			/* X flag */
static char **Printer_name;
static int Printer_count;
static int Max_printer_count;
int cleanup();

main( argc, argv )
	int argc;
	char **argv;
{
	struct passwd *pw_ent;		/* user entry in /etc/passwd */
	int i;

	/*
	 * set umask to avoid problems with user umask
	 */
	(void)umask(0);
	/*
	 * Set fd 0, 1, 2 to /dev/null if not open
	 */
	Std_environ();
#	ifdef XPERIMENT
		Setup_test();
#	endif XPERIMENT

	/*
     * set up the pathnames for information files
	 */
	Tailor_names();
	/*
	 * set up the from information
	 */
	From = Host;
	/*
	 * get the user name
	 */
	if( (pw_ent = getpwuid( getuid() )) == 0 ){
		logerr_die( XLOG_INFO, "getpwuid failed on uid %d", getuid());
	}
	(void)strcpy( LOGNAME, pw_ent->pw_name );
	Person = LOGNAME;
	/*
	 * get the parameters
	 */
	Get_parms(argc, argv);
	(void)signal(SIGPIPE, SIG_IGN);
	(void)signal(SIGHUP, cleanup);
	(void)signal(SIGINT, cleanup);
	(void)signal(SIGQUIT, cleanup);
	(void)signal(SIGTERM, cleanup);
	do{
		/*
		 * if we are to clear the terminal, do so
		 */
		if( Delay ){
			Term_clear();
		}
		/*
		 * if we have all printers to display, do so
		 */
		if( Do_all_pr ){
			Display_all();
		} else if( Printer_count == 0 ){
				Displayq();
		} else {
			for( i = 0; i < Printer_count; ++i ){
				Printer = Printer_name[i];
				Displayq();
			}
		}
		if( Delay ){
			sleep( (unsigned)Delay );
		}
	} while( Delay );
	exit( 0 );
}


/***************************************************************************
 * Get_parms( argc, argv )
 * 1. set up the name routine
 * 2. extract parameters
 *  -Pprinter sets Printer to printer
 *  -Dn set Debug to n
 *  -a   sets Do_all_pr
 *  -l   set Short_format
 *  -X   sets Xpert
 *  +nn
 ***************************************************************************/
static char *optstr= "P:D:alX+?";
Get_parms( argc, argv )
	int argc;
	char **argv;
{
	int c;		/* ACME Integers, Inc. */
	char *arg;	/* argument from list */

	Opt_flag = "+";
	while( (c = Getopt(argc,argv,optstr)) != EOF ){
		switch( c ){
		case 'P':
			if( Printer_count == Max_printer_count ){
				if( Max_printer_count == 0 ){
					Max_printer_count = 3;
					Printer_name =
						(char **)malloc( Max_printer_count * sizeof(char *));
				} else {
					Max_printer_count += 3;
					Printer_name =
						(char **)realloc( Printer_name,
							Max_printer_count * sizeof(char *));
				}
			}
			Printer_name[Printer_count] =  Optarg;
			++Printer_count;
			break;
		case 'D':
			Check_already( c, &Debug );
			if( Optarg ){
				Debug = atoi( Optarg );
			} else {
				Debug = 1;
			}
			break;
		case 'a':
			Check_already( c, &Do_all_pr );
			break;
		case 'l':
			Check_already( c, &Short_format );
			break;
		case 'X':
			Check_already( c, &Xpert );
#	ifdef DEBUG
			Setup_test();
			Tailor_names();
#	else
			Diemsg( "-X not allowed" );
#	endif DEBUG
			break;
		case '+':
			/**************************************
			 [+[n]] set Delay to n
			 **************************************/
			Check_already( c, &Delay );
			if( Optarg ){
				Delay = atoi( Optarg );
			}
			if( Delay == 0 ){
				Delay = 30;
			}
			break;
		default:
			Usemsg();
			exit(1);
		}
	}
	for(; Optind < argc; ++Optind ){
		arg = argv[Optind];
		Parms[Parmcount].str = arg;
		if( isdigit( *arg ) ){
			Parms[Parmcount].num = atoi( arg );
		} else {
			Parms[Parmcount].num = -1;
		}
		++Parmcount;
		if( Parmcount >= MAXPARMS ){
			Diemsg( "Too many arguments" );
		}
	}
	/*
	 * pick up the default printer name
	 */
	Get_Printer(0);
}

static
Check_already( c, v )
	int c;
	int *v;
{
	if( *v ){
		Usemsg();
		Diemsg( "-%c has already been specified", c);
	}
	*v = 1;
}

Usemsg()
{
	(void)fprintf(stderr,
	"use: lpq [-Pprinter] [-alX] [+[n]] [-Dn] (job# | user)*\n");
}

/***************************************************************************
 * Display_all()
 * 1. get the printer list
 * 2. for each printer in the list call Displayq
 ***************************************************************************/

Display_all()
{
	char **list;

	for( list = All_printers(); *list; ++list ){
		Printer = *list;
		Displayq();
	}
}
/***************************************************************************
 * cleanup()
 * remove the temp files
 ***************************************************************************/

cleanup()
{
	Term_finish();
	exit( 1 );
}
