/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: lpc.c
 * lpc - control LPR queues
 ***************************************************************************
 * Revision History: Created Mon Jan 25 14:04:26 CST 1988
 * $Log:	lpc.c,v $
 * Revision 3.1  88/06/18  09:34:36  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.2  88/05/14  10:21:01  papowell
 * Modified -X flag handling
 * 
 * Revision 2.1  88/05/09  10:08:40  papowell
 * PLP: Released Version
 * 
 * Revision 1.7  88/04/27  18:02:54  papowell
 * The SIGCHLD signal has an odd behaviour on some systems.  Modified so that
 * it will not get set UNLESS processes are started;  also,  it is reset
 * to SIG_DFL, not SIG_IGN.
 * 
 * Revision 1.6  88/04/15  13:06:23  papowell
 * Std_environ() call added, to ensure that fd 0 (stdin), 1 (stdout), 2(stderr)
 * have valid file descriptors;  if not open, then /dev/null is used.
 * 
 * Revision 1.5  88/04/07  12:32:26  papowell
 * Modified to use Getopt
 * 
 * Revision 1.4  88/04/06  12:12:17  papowell
 * Minor updates, changes in error message formats.
 * Elimination of the AF_UNIX connections, use AF_INET only.
 * Better error messages.
 * 
 * Revision 1.3  88/03/25  15:00:00  papowell
 * Debugged Version:
 * 1. Added the PLP control file first transfer
 * 2. Checks for MX during file transfers
 * 3. Found and fixed a mysterious bug involving the SYSLOG facilities;
 * 	apparently they open files and then assume that they will stay
 * 	open.
 * 4. Made sure that stdin, stdout, stderr was available at all times.
 * 
 * Revision 1.2  88/03/11  19:28:21  papowell
 * Minor Changes, Updates
 * 
 * Revision 1.1  88/03/01  11:08:35  papowell
 * Initial revision
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: lpc.c,v 3.1 88/06/18 09:34:36 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint
#include "lp.h"


/***************************************************************************
 * SYNOPSIS
 *      lpc [ -Dn ] [ -X [ command [ argument ... ] ]
 * DESCRIPTION
 *      Lpc  is  used  by  the  system  administrator to control the
 *      operation  of the line printer system. For each line printer
 *      configured in /etc/printcap, lpc may be used to:
 *      + disable or enable a printer,
 *      + disable or enable a printer's spooling queue,
 *      + rearrange the order of jobs in a spooling queue,
 *      + find the status of printers, and their associated spooling
 *        queues and printer dameons.
 *      Without any arguments, lpc will prompt for commands from the
 *      standard  input.   If arguments are supplied, lpc interprets
 *      the  first argument as a command and the remaining arguments
 *      as  parameters  to  the  command.  The standard input may be
 *      redirected causing lpc to read commands from file.  Commands
 *      may  be  abreviated; the following is the list of recognized
 *      commands.
 *      ? [ command ... ]
 *      help [ command ... ]
 *      abort { all | printer ... }
 *      clean { all | printer ... }
 *      enable { all | printer ... }
 *      exit
 *      quit
 *      disable { all | printer ... }
 *      restart { all | printer ... }
 *      start { all | printer ... }
 *      kill { all | printer ... }
 *      status [ terse ] [ all ] [ printer ... ]
 *      stop { all | printer ... }
 *      remote { abort | clean | enable | disable | restart  } printer
 *      topq printer [ jobnum ... ] [ user ... ]
 *      lpq [options]
 *      lprm [options]
 *      lpd
 *
 *      -Dn  Enables  display  of  debugging  information.   The  -D
 *           selects  level  1;  -Dn  selects level n (n is a single
 *           digit).
 *      -X   Use  an  Xperimental version of LPD if the software has
 *           been  compiled  with  the  appropriate support; ignored
 *           otherwise.
 ***************************************************************************/
/***************************************************************************
 * main(int argc, char **argv)
 * 1. get the host computer name and user name
 * 2. set up the Host and Person information
 * 3. get the parameters or set up a read from STDIN
 * 4. convert parameters and call the server routine
 ****************************************************************************/

extern int cleanup();

main(argc, argv)
	int argc;
	char **argv;
{
	struct passwd *pw_ent;		/* user entry in /etc/passwd */

	/*
	 * set umask to avoid problems with user umask
	 */
	(void)umask(0);
	/*
	 * Set fd 0, 1, 2 to /dev/null if not open
	 */
	Std_environ();
#	ifdef XPERIMENT
		Setup_test();
#	endif XPERIMENT

	/*
     * set up the pathnames for information files
	 */
	Tailor_names();
	/*
	 * set the from flag
	 */
	From = Host;
	/*
	 * get the user name
	 */
	if( (pw_ent = getpwuid( getuid() )) == 0 ){
		logerr_die( XLOG_INFO, "lpc: getpwuid failed on uid %d", getuid());
	}
	(void)strcpy( LOGNAME, pw_ent->pw_name );
	Person = LOGNAME;
	if( getuid() == 0 ){
		/* we are being invoked by root */
		Is_root = 1;
	}
	/*
	 * setup parameters
	 */
	Lpc_parms(argc, argv);
	/*
	 * set signals
	 */
	(void)signal(SIGPIPE, SIG_IGN);
	(void)signal(SIGHUP, cleanup);
	(void)signal(SIGINT, cleanup);
	(void)signal(SIGQUIT, cleanup);
	(void)signal(SIGTERM, cleanup);
	if( Parmcount != 0 ){
		(void)Control_ops();
	} else {
		Get_line();
	}
	exit( 0 );
}

/***************************************************************************
 * cleanup()
 * remove the temp files
 ***************************************************************************/

cleanup()
{
	exit( 1 );
}

/***************************************************************************
 * Lpc_parms( int arc, char **argv )
 * 1. pick off the options
 * 2. set up the parameters
 ***************************************************************************/

static char *optstr = "D:X";
static int Xpert;
Lpc_parms( argc, argv )
	int argc;
	char **argv;
{
	int option;
	int i;

	while( (option = Getopt(argc,argv,optstr)) != EOF ){
		switch( option ){
		case 'D':
			if(Debug){
				Diemsg("Duplicate -D option");
			}
			if( sscanf( Optarg, "%d", &Debug ) != 1 || Debug <= 0){
				Diemsg("-D parameter is not positive integer" );
			}
			break;
		case 'X':
			if( Xpert ){
				Diemsg("Duplicate -X option");
			}
#	ifdef DEBUG
			Setup_test();
			Tailor_names();
#	else
			Diemsg("-X is not allowed" );
#	endif DEBUG
			break;
		default:
			break;
		}
	}

	/*
	 * set up the Parms[] array
	 */
	for( ; Optind < argc; ++Optind ){
		if( Parmcount < MAXPARMS ){
			Parms[Parmcount].str = argv[Optind];
			i = atoi( Parms[Parmcount].str );
			if( i > 0 ){
				Parms[Parmcount].num = i;
			} else {
				Parms[Parmcount].num = -1;
			}
			++Parmcount;
		} else {
			Diemsg( "too many parameters" );
		}
	}
}


/***************************************************************************
 * Get_line()
 * Repeat:
 * 1. Get a line.
 * 2. if EOF return
 * 3. Split it up and put into Parms[]
 * 4. Call Control_ops()
 ***************************************************************************/

Get_line()
{
	char buf[BUFSIZ];	/* get a line */
	int i;				/* ACME Integers, Inc. */
	char *cp;			/* ACME Pointers, Inc. */

	while( 1 ){
		(void)fprintf(stdout, "lpc>");
		(void)fflush(stdout);
		if( fgets( buf, sizeof(buf), stdin ) == 0 ) return;
		buf[ strlen(buf) -1 ] = 0;	/* clobber the last char */
		/*
		 * now set up the parameters
		 */
		Parmcount = 0;
		for( cp = buf; *cp; ){
			/* skip leading blanks */
			Parms[Parmcount].str = 0;
			Parms[Parmcount].num = -1;
			while( *cp && isspace( *cp ) ) ++cp;
			if( *cp ){
				Parms[Parmcount].str = cp;
			}
			while( *cp && !isspace( *cp ) ) ++cp;
			if( *cp ){
				*cp = 0;
				++cp;
			}
			if( Parms[Parmcount].str != 0 ){
				Parms[Parmcount].num = -1;
				i = atoi( Parms[Parmcount].str );
				if( i > 0 ){
					Parms[Parmcount].num = i;
				}
				++Parmcount;
			}
		}
		if( Parmcount ){
			if(Debug>3){
				for( i = 0; i < Parmcount; ++i ){
					(void)fprintf(stderr,"Parms[%d]: '%s', %d\n",i,
						Parms[i].str,Parms[i].num );
				}
			}
			(void)Control_ops();
		}
	}
	/*NOTREACHED*/
}
