/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: globals.c
 * Definitions of global variables.
 * NOTE: system dependent,  default values defined in lp.h
 ***************************************************************************
 * Revision History: Created Sun Jan  3 08:25:42 CST 1988
 * $Log:	global.c,v $
 * Revision 3.1  88/06/18  09:34:18  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.3  88/05/21  10:27:41  papowell
 * Minor editing
 * 
 * Revision 2.2  88/05/14  10:18:12  papowell
 * Use long format for job file names;
 * Added 'fd', no forward flag;
 * Control file has to have hostname and origination agree.
 * 
 * Revision 2.1  88/05/09  10:08:15  papowell
 * PLP: Released Version
 * 
 * Revision 1.7  88/05/09  10:03:32  papowell
 * Revised effects of -h option
 * 
 * Revision 1.6  88/04/27  20:25:40  papowell
 * Modified to remove unused variables
 * 
 * Revision 1.5  88/04/07  12:31:25  papowell
 * 
 * Revision 1.4  88/03/25  14:59:34  papowell
 * Debugged Version:
 * 1. Added the PLP control file first transfer
 * 2. Checks for MX during file transfers
 * 3. Found and fixed a mysterious bug involving the SYSLOG facilities;
 * 	apparently they open files and then assume that they will stay
 * 	open.
 * 4. Made sure that stdin, stdout, stderr was available at all times.
 * 
 * Revision 1.3  88/03/11  19:29:31  papowell
 * Minor Changes, Updates
 * 
 * Revision 1.2  88/03/05  15:02:05  papowell
 * Minor Corrections,  Lint Problems
 * 
 * Revision 1.1  88/03/01  11:08:27  papowell
 * Initial revision
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: global.c,v 3.1 88/06/18 09:34:18 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint

#include "lp.h"

/*************************************************************************
 * global variables
 *************************************************************************/

char  *Name;					/* program Name (argv[0]) */
char  *Printer;					/* Printer Name, set for a queue handler */
char   Host[64];				/* Host machine name */
char  *From;					/* client's machine Name */
char  *Person;					/* Name of Person making request */
FILE  *Lfd;						/* lock file file descriptor */
char  *First_name;				/* first name in printcap entry */
int    Debug;					/* Debugging level */
int    Echo_on_stdout;			/* error messages on stdout and stderr */
int    Errorcode = 2;			/* exit() value for fatal termination */
struct parm Parms[MAXPARMS];    /* character parameters */
int    Parmcount;				/* number of requests */
char   Last_errormsg[BUFSIZ];	/* last errormessage */
struct queue *Jobentry;			/* current job entry in queue */
int    Request;					/* current lpd request code */
int    Print_fd;				/* output printer file descriptor */
char   CFparm[26][MAXPARMLEN+1];	/* parameters read from control file */
struct queue *Queue;			/* Getq generates a vector of jobs */
int    Jobcount;				/* and returns the number of jobs  */
int    Short_format;			/* short status format */
int    Rec_cnt;					/* number of files in a job */
int    Is_root;                 /* is this the root user? */
int    Is_local;				/* doing this locally or remotely? */
struct stat LO_statb;			/* used to stat lockfile */
int    Daemon_uid;				/* daemon UID */
int    Daemon_gid;				/* daemon GID */

/******************************************************************
 * Definitions for the printcap variables.
 ******************************************************************/

int    AB;		/* Always have a banner flag, ignore lpr -h option */
char  *AF;		/* accounting file */
int    BK;		/* Berkeley compatible remote and local */
char  *BP;		/* banner printer filter */
int    BR;		/* baud rate if lp is a tty */
int    CO;		/* cost of printing in dollars per thousand pages */
char  *EP;		/* end printer filter */
int    FC;		/* flags to clear if lp is a tty */
int    FD;		/* No forwarding, accept only from original site */
char  *FF;		/* form feed string */
int    FJ;		/* send control file  first to remote site */
int    FO;		/* print a form feed when device is opened */
int    FQ;		/* form feed on quitting */
int    FS;		/* flags to set if lp is a tty */
char  *FX;		/* allowable formats */
char  *LD;		/* leader string on opening */
char  *LF;		/* log file for error messages */
int    LH;		/* use long host name */
char  *LN;		/* group allowed to use links */
char  *LO;		/* lock file Name */
char  *LP;		/* line Printer device Name */
int    MC;		/* maximum number of copies allowed */
int    MX;		/* maximum number of blocks to copy */
int    NW;		/* Networked file system, do not make copies */
int    PL;		/* page length */
char  *PR;		/* pr program Name Name */
char  *PS;		/* Printer status file Name */
int    PW;		/* page width */
int    PX;		/* page width in pixels */
int    PY;		/* page length in pixels */
char  *QH;		/* queue handler */
char  *RG;		/* restrict use to group */
char  *RM;		/* remote machine Name */
char  *RP;		/* remote Printer Name */
int    RT;		/* max retries */
int    RW;		/* open LP for reading and writing */
int    SB;		/* short banner instead of normal header */
int    SC;		/* suppress multiple copies */
char  *SD;		/* spool directory */
int    SF;		/* suppress FF on each print job */
int    SH;		/* suppress header page */
char  *SS;		/* name of queue that the server serves  */
char  *ST;		/* status file Name */
char  *SV;		/* names of servers */
char  *TR;		/* trailer string to be output when Q empties */
char  *TY;		/* terminal characteristics, stty options */
int    XC;		/* flags to clear for local mode */
int    XS;		/* flags to set for local mode */
char  *XU;		/* restrict use to users with perms in file */
char  *XT;		/* check format in string for printable text only */
/*
 * filter arguments are indexed by first letter of the filter Name.
 * For example:
 * "if=/usr/lib/iffilter" -> Filter_name['i'-'a']
 */
char *Filter_name[26];
/*
 * Prefilter arguments are indexed by first letter of the filter Name,
 * as for the filters
 */
char *Prefilter_name[26];

/*************************************************************************
 * Printcap Entries,  Defaults, and Variables
 * The All_pc_vars[] and Status_pc_vars[] arrays contain the Names
 * of the printcap entries, the type of entry,  the default value,
 * and the variable which is set by the entry.
 * The array is sorted by the printcap entry.
 *************************************************************************/

PC_ENTRY All_pc_vars[] = {
{ "ab", PC_FLAG, 0, 0, (char **)&AB },
{ "ae", PC_STRING, 0, 0, &Prefilter_name['a'-'a'] },
{ "af", PC_STRING, 0, DEFACCT, &AF },
{ "be", PC_STRING, 0, 0, &Prefilter_name['b'-'a'] },
{ "bf", PC_STRING, 0, 0, &Filter_name['b'-'a'] },
{ "bk", PC_NUM, 0, 0, (char **)&BK },
{ "bp", PC_STRING, 0, 0, &BP },
{ "br", PC_NUM, 0, 0, (char **)&BR },
{ "ce", PC_STRING, 0, 0, &Prefilter_name['c'-'a'] },
{ "cf", PC_STRING, 0, 0, &Filter_name['c'-'a'] },
{ "co", PC_NUM, 0, 0, (char **)&CO },
{ "de", PC_STRING, 0, 0, &Prefilter_name['d'-'a'] },
{ "df", PC_STRING, 0, 0, &Filter_name['d'-'a'] },
{ "ee", PC_STRING, 0, 0, &Prefilter_name['e'-'a'] },
{ "ef", PC_STRING, 0, 0, &Filter_name['e'-'a'] },
{ "ep", PC_STRING, 0, 0, &EP },
{ "fc", PC_NUM, 0, 0, (char **)&FC },
{ "fd", PC_FLAG, 0, 0, (char **)&FD },
{ "ff", PC_STRING, 0, DEFFF, &FF },
{ "fj", PC_FLAG, 0, 0, (char **)&FJ },
{ "fo", PC_FLAG, 0, 0, (char **)&FO },
{ "fq", PC_FLAG, 0, 0, (char **)&FQ },
{ "fs", PC_NUM, 0, 0, (char **)&FS },
{ "fx", PC_STRING, 0, 0, &FX },
{ "ge", PC_STRING, 0, 0, &Prefilter_name['g'-'a'] },
{ "gf", PC_STRING, 0, 0, &Filter_name['g'-'a'] },
{ "he", PC_STRING, 0, 0, &Prefilter_name['h'-'a'] },
{ "hf", PC_STRING, 0, 0, &Filter_name['h'-'a'] },
{ "ie", PC_STRING, 0, 0, &Prefilter_name['i'-'a'] },
{ "if", PC_STRING, 0, 0, &Filter_name['i'-'a'] },
{ "je", PC_STRING, 0, 0, &Prefilter_name['j'-'a'] },
{ "jf", PC_STRING, 0, 0, &Filter_name['j'-'a'] },
{ "ke", PC_STRING, 0, 0, &Prefilter_name['k'-'a'] },
{ "kf", PC_STRING, 0, 0, &Filter_name['k'-'a'] },
{ "le", PC_STRING, 0, 0, &Prefilter_name['l'-'a'] },
{ "lf", PC_STRING, 0, DEFLOGF, &LF },
{ "lh", PC_NUM, 0, 0, (char **)&LH },
{ "ln", PC_STRING, 0, 0, &LN },
{ "lo", PC_STRING, 0, DEFLOCK, &LO },
{ "lp", PC_STRING, 0, 0, &LP },
{ "mc", PC_NUM, DEFMAXCOPIES, 0, (char **)&MC },
{ "me", PC_STRING, 0, 0, &Prefilter_name['m'-'a'] },
{ "mf", PC_STRING, 0, 0, &Filter_name['m'-'a'] },
{ "mx", PC_NUM, DEFMX, 0, (char **)&MX },
{ "ne", PC_STRING, 0, 0, &Prefilter_name['n'-'a'] },
{ "nf", PC_STRING, 0, 0, &Filter_name['n'-'a'] },
{ "nw", PC_FLAG, 0, 0, (char **)&NW },
{ "oe", PC_STRING, 0, 0, &Prefilter_name['o'-'a'] },
{ "of", PC_STRING, 0, 0, &Filter_name['o'-'a'] },
{ "pe", PC_STRING, 0, 0, &Prefilter_name['p'-'a'] },
{ "pf", PC_STRING, 0, 0, &Filter_name['p'-'a'] },
{ "pl", PC_NUM, DEFLENGTH, 0, (char **)&PL },
{ "pr", PC_STRING, 0, DEFPR, &PR },
{ "ps", PC_STRING, 0, 0, &PS },
{ "pw", PC_NUM, DEFWIDTH, 0, (char **)&PW },
{ "px", PC_NUM, 0, 0, (char **)&PX },
{ "py", PC_NUM, 0, 0, (char **)&PY },
{ "qe", PC_STRING, 0, 0, &Prefilter_name['q'-'a'] },
{ "qf", PC_STRING, 0, 0, &Filter_name['q'-'a'] },
{ "qh", PC_STRING, 0, 0, &QH },
{ "re", PC_STRING, 0, 0, &Prefilter_name['r'-'a'] },
{ "rf", PC_STRING, 0, 0, &Filter_name['r'-'a'] },
{ "rg", PC_STRING, 0, 0, &RG },
{ "rm", PC_STRING, 0, 0, &RM },
{ "rp", PC_STRING, 0, 0, &RP },
{ "rt", PC_NUM, DEFRETRY, 0, (char **)&RT },
{ "rw", PC_FLAG, 0, 0, (char **)&RW },
{ "sb", PC_FLAG, 0, 0, (char **)&SB },
{ "sc", PC_FLAG, 0, 0, (char **)&SC },
{ "sd", PC_STRING, 0, 0, &SD },
{ "se", PC_STRING, 0, 0, &Prefilter_name['s'-'a'] },
{ "sf", PC_FLAG, 0, 0, (char **)&SF },
{ "sh", PC_FLAG, 0, 0, (char **)&SH },
{ "ss", PC_STRING, 0, 0, &SS },
{ "st", PC_STRING, 0, DEFSTAT, &ST },
{ "sv", PC_STRING, 0, 0, &SV },
{ "te", PC_STRING, 0, 0, &Prefilter_name['t'-'a'] },
{ "tf", PC_STRING, 0, 0, &Filter_name['t'-'a'] },
{ "tr", PC_STRING, 0, 0, &TR },
{ "ty", PC_STRING, 0, 0, &TY },
{ "ue", PC_STRING, 0, 0, &Prefilter_name['u'-'a'] },
{ "uf", PC_STRING, 0, 0, &Filter_name['u'-'a'] },
{ "ve", PC_STRING, 0, 0, &Prefilter_name['v'-'a'] },
{ "vf", PC_STRING, 0, 0, &Filter_name['v'-'a'] },
{ "we", PC_STRING, 0, 0, &Prefilter_name['w'-'a'] },
{ "wf", PC_STRING, 0, 0, &Filter_name['w'-'a'] },
{ "xc", PC_NUM, 0, 0, (char **)&XC },
{ "xe", PC_STRING, 0, 0, &Prefilter_name['x'-'a'] },
{ "xf", PC_STRING, 0, 0, &Filter_name['x'-'a'] },
{ "xs", PC_NUM, 0, 0, (char **)&XS },
{ "xt", PC_STRING, 0, 0, &XT },
{ "xu", PC_STRING, 0, 0, &XU },
{ "ye", PC_STRING, 0, 0, &Prefilter_name['y'-'a'] },
{ "yf", PC_STRING, 0, 0, &Filter_name['y'-'a'] },
{ "ze", PC_STRING, 0, 0, &Prefilter_name['z'-'a'] },
{ "zf", PC_STRING, 0, 0, &Filter_name['z'-'a'] }
};

int	All_pc_len = sizeof(All_pc_vars)/sizeof(PC_ENTRY);

/**************************************************************************
 * Status_pc_vars[] 
 * status checking uses only a subset of all the printcap entries
 **************************************************************************/
PC_ENTRY Status_pc_vars[] = {
{ "af", PC_STRING, 0, 0, &AF },
{ "co", PC_NUM, 0, 0, (char **)&CO },
{ "fd", PC_FLAG, 0, 0, (char **)&FD },
{ "lf", PC_STRING, 0, DEFLOGF, &LF },
{ "lh", PC_NUM, 0, 0, (char **)&LH },
{ "lo", PC_STRING, 0, DEFLOCK, &LO },
{ "lp", PC_STRING, 0, 0, &LP },
{ "mx", PC_NUM, DEFMX, 0, (char **)&MX },
{ "nw", PC_FLAG, 0, 0, (char **)&NW },
{ "ps", PC_STRING, 0, 0, &PS },
{ "rg", PC_STRING, 0, 0, &RG },
{ "rm", PC_STRING, 0, 0, &RM },
{ "rp", PC_STRING, 0, 0, &RP },
{ "sd", PC_STRING, 0, 0, &SD },
{ "ss", PC_STRING, 0, 0, &SS },
{ "st", PC_STRING, 0, DEFSTAT, &ST },
{ "sv", PC_STRING, 0, 0, &SV },
{ "xu", PC_STRING, 0, 0, &XU }
};
int	Status_pc_len = sizeof(Status_pc_vars)/sizeof(PC_ENTRY);

/**************************************************************************
 * Server_pc_vars[] 
 * just used to get a select set of server information
 **************************************************************************/
PC_ENTRY Server_pc_vars[] = {
{ "ps", PC_STRING, 0, 0, &PS },
{ "ss", PC_STRING, 0, 0, &SS },
{ "st", PC_STRING, 0, DEFSTAT, &ST },
{ "sv", PC_STRING, 0, 0, &SV }
};

int	Server_pc_len = sizeof(Server_pc_vars)/sizeof(PC_ENTRY);
/*
 * Location of LPD and LPR dependent files
 * Note that this will get updated to site dependent versions.
 */
char Lpdlogf[MAXPATHLEN]  = RDEFLPDLOGF;
char Masterlock[MAXPATHLEN]  = RMASTERLOCK;
int	Lpr_port_num;		/* port number to connect to */
int Maxportno = RMAXPORTNO;
int Minportno = RMINPORTNO;
char Permfile[MAXPATHLEN]  = RPERMFILE;
char Printcap[MAXPATHLEN]  = RPRINTCAP;


/*
 *  SYSLOG.H -- declarations for system logging program
 *
 *	These are used as the first parameter to logmsg().
 *	Their meanings are approximately as follows:
 *
 *	LOG_ERR -- these represent error conditions, such as soft
 *		disk failures, etc.
 *	LOG_CRIT -- such messages contain critical information,
 *		but which can not be classed as errors, for example,
 *		'su' attempts.
 *	LOG_WARNING -- issued when an abnormal condition has been
 *		detected, but recovery can take place.
 *	LOG_NOTICE -- something that falls in the class of
 *		"important information"; this class is informational
 *		but important enough that you don't want to throw
 *		it away casually.
 *	LOG_INFO -- information level messages.  These messages
 *		could be thrown away without problems, but should
 *		be included if you want to keep a close watch on
 *		your system.
 *	LOG_DEBUG -- it may be useful to log certain Debugging
 *		information.  Normally this will be thrown away.
 */

#ifdef NOSYSLOG

/* defines for priorities */
#define	LOG_ERR		4	/* synonym of LOG_ERROR */
#define	LOG_CRIT	5	/* critical information */
#define	LOG_WARNING	6	/* warning */
#define	LOG_NOTICE	7	/* important information */
#define	LOG_INFO	8	/* informational message */
#define	LOG_DEBUG	9	/* Debug level info */

#else
#include <syslog.h>
#endif

int XLOG_ERR	= LOG_ERR;			/* synonym of LOG_ERROR */
int XLOG_CRIT	= LOG_CRIT;			/* critical information */
int XLOG_WARNING	= LOG_WARNING;	/* warning */
int XLOG_NOTICE	= LOG_NOTICE;		/* important information */
int XLOG_INFO	= LOG_INFO;			/* informational message */
int XLOG_DEBUG	= LOG_DEBUG;		/* Debug level info */
