/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: get_printer.c
 * gets the default printer value for a user job
 ***************************************************************************
 * Revision History: Created Mon Feb  1 12:31:23 CST 1988
 * $Log:	getprinter.c,v $
 * Revision 3.1  88/06/18  09:34:15  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.1  88/05/09  10:08:11  papowell
 * PLP: Released Version
 * 
 * Revision 1.4  88/05/05  20:07:09  papowell
 * Minor changes to shut up lint.
 * 
 * Revision 1.3  88/03/25  14:59:31  papowell
 * Debugged Version:
 * 1. Added the PLP control file first transfer
 * 2. Checks for MX during file transfers
 * 3. Found and fixed a mysterious bug involving the SYSLOG facilities;
 * 	apparently they open files and then assume that they will stay
 * 	open.
 * 4. Made sure that stdin, stdout, stderr was available at all times.
 * 
 * Revision 1.2  88/03/05  15:02:02  papowell
 * Minor Corrections,  Lint Problems
 * 
 * Revision 1.1  88/03/01  11:08:26  papowell
 * Initial revision
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: getprinter.c,v 3.1 88/06/18 09:34:15 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint

#include "lp.h"
/***************************************************************************
 * Get_Printer()
 * Get the Printer Name
 * 1. check for -P option
 * 2. check for PRINTER environment variable
 * 3. use first in printcap
 *
 ***************************************************************************/
Get_Printer(all)
	int all;
{
	int i;

	if( Printer == 0 ){
		if( Printer = getenv( "PRINTER" ) ){
			if(Debug>4)log(XLOG_DEBUG,
				"Get_Printer: PRINTER environment var '%s'", Printer );
		} else {
			/* use the default, first in list */
			Printer = First_printer();
			if(Debug>4)log(XLOG_DEBUG,
				"Get_Printer: First_printer '%s'", Printer );
		}
	}
	if(Debug>4)log(XLOG_DEBUG,"Get_printer: using Printer %s",Printer);
	if( all ){
		i = Get_pc_entry(Printer, All_pc_vars, All_pc_len );
	} else {
		i = Get_pc_entry(Printer, Status_pc_vars, Status_pc_len );
	}
	if( i == 0 ){
		Diemsg( "no printcap entry for printer %s", Printer );
	}
}

/***************************************************************************
 * Diemsg( char *m1, *m2, ...)
 * print error message and die
 ***************************************************************************/
/*VARARGS1*/
Diemsg(m1, m2, m3, m4, m5, m6)
	char *m1;
	int m2, m3, m4, m5, m6;
{
	(void)fprintf( stderr, "%s: Fatal error- ", Name );
	(void)fprintf( stderr, m1, m2, m3, m4, m5, m6 );
	(void)fprintf( stderr, "\n" );
	cleanup();
	exit(1);
}
/***************************************************************************
 * Warnmsg( char *m1, *m2, ...)
 * print warning message
 ***************************************************************************/
/*VARARGS1*/
Warnmsg(m1, m2, m3, m4, m5, m6)
	char *m1;
	int m2, m3, m4, m5, m6;
{
	(void)fprintf( stderr, "%s: Warning- ", Name );
	(void)fprintf( stderr, m1, m2, m3, m4, m5, m6 );
	(void)fprintf( stderr, "\n" );
}
