/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: Getopt.c
 * Getopt(3) implementation; modified so that the first time it is
 * called it sets "Name" to argv[0];
 ***************************************************************************
 * Revision History: Created Fri Jan  1 15:36:11 CST 1988
 * $Log:	getopt.c,v $
 * Revision 3.1  88/06/18  09:34:13  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.1  88/05/09  10:08:08  papowell
 * PLP: Released Version
 * 
 * Revision 1.4  88/04/15  10:45:19  papowell
 * When checking for alternate flag chars, got a && mixed up with || test
 * 
 * Revision 1.3  88/04/07  12:27:20  papowell
 * Added ability to detect '+' options
 * 
 * Revision 1.2  88/04/06  12:13:51  papowell
 * Minor updates, changes in error message formats.
 * Elimination of the AF_UNIX connections, use AF_INET only.
 * Better error messages.
 * 
 * Revision 1.1  88/03/01  11:08:25  papowell
 * Initial revision
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: getopt.c,v 3.1 88/06/18 09:34:13 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint
/***************************************************************************
 * int Getopt ( argc, argv, optstring)
 *     int argc;
 *    	char **argv, *opstring;
 * int Optind, Opterr;
 * char *Optarg;
 * extern char *Name; 
 * Returns: EOF if no more options left;
 *    '?' if option not in optstring;
 *    option character if in optstr.
 *      if option char is followed by : in opstring, an argument is required,
 *        and Optarg will point to the option argument
 *      if option char is followed by ? in opstring, an argument is optional
 *        and Optarg will point to the argument if it immediately follows
 *        the option character
 *	If there are a special set of characters (such as "+" ) that should also
 *	be allowed to indicate flags, these are specified in the Opt_flag,
 *  which indicates that the character is allowed to act as an option flag
 * 
 * 
 * Getopt places the argv index of the next argument to be processed in
 * Optind. Because Optind is external, it is automatically set to zero
 * before the first call to Getopt.  When all the options have been
 * processed (i.e., up to the first non-option argument), Getopt returns
 * EOF.  The special option -- may be used to delimit the end of the
 * options; EOF will be returned, and -- will be skipped.
 * 
 * Getopt prints an error message on stderr and returns the offending
 * character when it encounters an option letter that is not included in
 * optstring.  This error message may be disabled by setting Opterr to a
 * non-zero value.
 * 
 * Side Effect:  when Getopt is called and Optind is 0, Name is set to
 * argv[0].  This allows pulling the program Name from the file.
 * Errors: if an argument is specified and none is there, then Optarg is
 * set to NULL
 * 
 ***************************************************************************/

#include <stdio.h>

int	Optind = 0;			/* next argv to process */
int	Opterr = 0;			/* Non-zero disables errors msgs */
char	*Optarg = NULL;			/* Pointer to option argument */
static	char *next_opt = NULL;	/* pointer to next option char */
extern  char *Name;				/* the program Name */
extern  char *index();			/* find character in string */
char *Opt_flag;			/* first character is a flag */

int
Getopt(argc, argv, optstring)
	int argc;					/* number of arguments */
	char **argv;				/* array or arguments */
	char *optstring;			/* option string */
{
	int option;				/* current option found */
	char *match;			/* matched option in optstring */

	if( Optind == 0 ){
		/* set up the Name variable for error messages */
		Name = argv[0];
		Optind = 1;
	}
	if ( next_opt == NULL || *next_opt == '\0' ) {
		/* No more arguments left in current or initial string */
		if ( Optind >= argc ){
			return( EOF );
		}
		next_opt = argv[Optind];
		if( next_opt[0] != '-'
			&& (Opt_flag == 0 || index( Opt_flag, next_opt[0] ) == 0) ){
			/* we hit the last argument */
			return( EOF );
		}
		/*
		 * we have a '-' or a flag as first character
		 */
		if( next_opt[0] == '-' ){
			++next_opt;
		}
		/* Single '-', end of opts */
		if ( *next_opt == '\0' ){
			return( EOF );
		}
		Optind++;
	}
	option = *next_opt++;
	/*
	 * Case of '--',  Force end of options
	 */
	if ( option == '-' ){
		return( EOF );
	}
	/*
	 * See if option is in optstring
	 */
	if ( (match = index(optstring, option)) == NULL ) {
		if ( Opterr == 0 ){
			(void)fprintf(stderr, "%s: Illegal option '%c'\n", Name, option);
		}
		return( '?' );
	}
	/*
	 * Argument always follows this option
	 */
	if ( match[1] == ':' ) {
		/*
		 * Set Optarg to proper value
		 */
		if ( *next_opt != '\0' ){
			Optarg = next_opt;
		} else if ( Optind < argc ) {
			Optarg = argv[Optind++];
		} else {
			if ( Opterr == 0 ){
				(void)fprintf(stderr,
					"%s: missing argument for '%c'\n",Name,option);
				Optarg = NULL;
			}
		}
		if( Optarg != NULL && Optarg[0] == '-' ){
			if ( Opterr == 0 ){
				(void)fprintf(stderr,
					"%s: missing argument for '%c'\n",Name,option);
				Optarg = NULL;
			}
		}
		next_opt = NULL;
	}
	/*
	 * Argument sometimes follows this option
	 */
	if ( match[1] == '?' ) {
		/*
		 * Set Optarg to proper value
		 */
		if ( *next_opt != '\0' ){
			Optarg = next_opt;
		} else {
			Optarg = NULL;
		}
		next_opt = NULL;
	}
	return( option );
}

/***************************************************************************
 * Push_opt()
 * Some flags may have an optional argument.  The Push_opt is used to
 * push the argument that would normally be supplied back.  The assumption
 * is that the argument will start with a - sign, i.e.- be a flag,
 * and be the current value of Optind
 ***************************************************************************/
Push_opt()
{
	next_opt = 0;
	Optind = Optind - 1;
}
