/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: find_name.c
 * manages the Parms[] array entries.  Used by sender and receiver
 * file transfer functions of LPD.
 * The Parms[] array is maintained as a sorted list.
 * Find_name( char *name ): search the Parm[].filename entries for a match.
 *	returns: index if found, -1 if not;
 * Add_name( char *name ): search the Parm[].filename entries for a match.
 *	if not found, add the entry.
 *	returns: index where found or created.
 ***************************************************************************
 * Revision History: Created Sun Mar 13 10:29:54 CST 1988
 * $Log:	find_name.c,v $
 * Revision 3.1  88/06/18  09:34:11  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.1  88/05/09  10:08:05  papowell
 * PLP: Released Version
 * 
 * Revision 1.2  88/04/26  15:52:47  papowell
 * Fixed up a horribly silly bug in the add_files and File_name
 * routines;  sigh.  Would you believe an L (l) and a one (1) got mixed
 * up?
 * 
 * Revision 1.1  88/03/25  14:59:28  papowell
 * Initial revision
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: find_name.c,v 3.1 88/06/18 09:34:11 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint
#include "lp.h"

/***************************************************************************
 * Find_name( char *name)
 * The Parms[] array is used to hold the names of data and control files
 * corresponding to a job.  The Find_name will look through the list for
 * the job.
 ***************************************************************************/

Find_name( name )
	char *name;
{
	int i, j;

	j = -1;
	for( i = 0; i < Parmcount; ++i ){
		if( strcmp( Parms[i].filename, name) == 0 ){
			j = i;
			break;
		}
	}
	if(Debug>6)log(XLOG_DEBUG,"Find_name: %s, entry %d", name, j );
	return( j );
}

/***************************************************************************
 * Add_name(char *name)
 * Maintains the Parms[].filename entries in sorted order.
 * 1. See if in file. if it is, return index.
 * 2. If not,  you will find the entry where it should be inserted.
 * 3. Move all the entries up one position.
 * the job.
 ***************************************************************************/

int
Add_name( name )
	char *name;
{
	int i;

	if( (i = Find_name( name )) < 0 ){
		if( Parmcount < MAXPARMS ){
			i = Parmcount;
			++Parmcount;
			(void)bzero( (char *)&Parms[i], sizeof( struct parm ));
			(void)strcpy(Parms[i].filename, name );
		} else {
			i = -1;
		}
	}
	if(Debug>5)log(XLOG_DEBUG,"Add_name: %s, entry %d", name, i );
	return( i );
}
