/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: displayq.c
 * Display the status of a Printer queue
 ***************************************************************************
 * Revision History: Created Sat Jan  9 20:08:26 CST 1988
 * $Log:	displayq.c,v $
 * Revision 3.1  88/06/18  09:34:07  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.3  88/05/16  12:09:08  papowell
 * Added a queue printing, spooling message
 * 
 * Revision 2.2  88/05/14  10:17:57  papowell
 * Use long format for job file names;
 * Added 'fd', no forward flag;
 * Control file has to have hostname and origination agree.
 * 
 * Revision 2.1  88/05/09  10:07:58  papowell
 * PLP: Released Version
 * 
 * Revision 1.6  88/04/06  12:13:18  papowell
 * Minor updates, changes in error message formats.
 * Elimination of the AF_UNIX connections, use AF_INET only.
 * Better error messages.
 * 
 * Revision 1.5  88/03/25  14:59:21  papowell
 * Debugged Version:
 * 1. Added the PLP control file first transfer
 * 2. Checks for MX during file transfers
 * 3. Found and fixed a mysterious bug involving the SYSLOG facilities;
 * 	apparently they open files and then assume that they will stay
 * 	open.
 * 4. Made sure that stdin, stdout, stderr was available at all times.
 * 
 * Revision 1.4  88/03/12  10:03:25  papowell
 * *** empty log message ***
 * 
 * Revision 1.3  88/03/11  19:28:04  papowell
 * Minor Changes, Updates
 * 
 * Revision 1.2  88/03/05  15:01:25  papowell
 * Minor Corrections,  Lint Problems
 * 
 * Revision 1.1  88/03/01  11:08:21  papowell
 * Initial revision
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: displayq.c,v 3.1 88/06/18 09:34:07 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint

#include "lp.h"
static int header;
static int server;

/***************************************************************************
 * Displayq()
 *  1. get the printcap entries
 *  2. get the queue entries
 *  3. get the active server files and see if they are in queue
 *  4. print the queue status
 ***************************************************************************/

Displayq()
{
	int i;				/* ACME Integers, Inc. */
	struct queue *q;	/* job entry */
	char buf[BUFSIZ];	/* status message buffer */

	header = 0;
	/*
	 * get the printcap entry
	 */
	if(Get_pc_entry(Printer, Status_pc_vars, Status_pc_len) == 0){
		(void)fprintf(stdout, "Printer %s does not exist\n", Printer );
		(void)fflush(stdout);
		return;
	}
	if( SD == 0 || *SD == 0 ){
		if(Debug>0)log(XLOG_DEBUG,"Printer %s does not have a spool queue\n",
			Printer);
		return;
	}
	
	if(Debug>5)log(XLOG_DEBUG,"Displayq: doing %s", Printer );
	/*
	 * If you are running NFS, use the remote lpr
	 */
	if( RM && *RM && NW ){
		Remote_status();
		return;
	}
	/* chdir to spool directory */
	if (chdir(SD) < 0) {
		logerr_die( XLOG_NOTICE,"cannot chdir to %s", SD);
	}
	/*
	 * get the numbers of jobs here
	 */
	Jobcount = Getq();
	/*
	 * Checkactive checks for the active jobs
	 */
	server = Checkactive();
	buf[0] = 0;
	if( LO_statb.st_mode & DISABLE_QUEUE ){
		(void)strcat(buf, "no spooling" );
	}
	if( LO_statb.st_mode & DISABLE_PRINT ){
		if( buf[0] ){
			(void)strcat( buf, ", ");
		}
		(void)strcat(buf, "no printing" );
	}

	if( Short_format ){
		if( From == Host ){
			(void)fprintf(stdout,"%s: %d jobs", Printer, Jobcount );
		} else {
			(void)fprintf(stdout,"%s@%s: %d jobs", Printer, Host, Jobcount );
		}
		if( buf[0] ){
			(void)fprintf(stdout," (%s)", buf );
		}
		(void)fprintf(stdout,"\n");
	} else {
		if( From == Host ){
			if( SV == 0 || *SV == 0 ){
				(void)fprintf(stdout, "Printer '%s' (%s):", Printer, Host );
			} else {
				(void)fprintf(stdout, "Queue '%s' (%s):", Printer, Host );
			}
			if( buf[0] ){
				(void)fprintf(stdout," (%s)", buf );
			}
			(void)fprintf(stdout,"\n");
		} else {
			if( SV == 0 || *SV == 0 ){
			(void)fprintf(stdout, "Remote printer '%s' (%s):",Printer,Host);
			} else {
			(void)fprintf(stdout, "Remote queue '%s' (%s):", Printer, Host );
			}
			if( buf[0] ){
				(void)fprintf(stdout," (%s)", buf );
			}
			(void)fprintf(stdout,"\n");
		}
		/*
		 * show status files
		 */
		showstatus();
	}
	(void)fflush(stdout);
	/*
	 * run down list
	 */
	for( i = 0; i < Jobcount; ++i ){
		q = &Queue[i];
		if( Parmcount <= 0 || Match_entry( q ) ){
			showentry(i+1, q);
		}
	}
	if( RM && *RM ){
		Remote_status();
	}
	if( From == Host ){
		putchar('\n');
	}
}

/*****************************************************************************
 * showentry( int seq, struct queue *q )
 *  show status for entry
 * Rank   Owner      Pr Job  Host         Files                Size
 * active sutantha   Z  260  umn-cs       (stdin)              177744 bytes
 * 2      powell     Z    1  attila       junk, morejunk,...   32767 bytes
 *
 * if you have multiple servers, the first column will contain the name
 * of the server.
 * Rank   Owner      Pr Job  Host         Files                Size
 * sv1    sutantha   Z  260  umn-cs       (stdin)              177744 bytes
 * sv2    powell     Z    1  attila       junk, morejunk,...   32767 bytes
 *****************************************************************************/

static char hdr_format[] = "%6s %-11s %-2s %-3s %-11s %-20s %-6s %-s\n";
static char info_format[] = "%6s %-11s %-c  %-3d %-11s %-20s %-6d %s\n";

static char *
short_time( tvec )
	time_t tvec;		/* time */
{
	char *ctime();
	static char s[40];

	/*
	 *	012345678901234567890123456789
	 *	Mon May 30 20:53:27 CDT 1988
	 */
	(void)strcpy(s,ctime(&tvec));
	s[16] = 0;
	return( &s[4] );
}
showentry( seq, q )
	int seq;
	struct queue *q;
{
	char buf[10];
	char *suffix;
	char name[BUFSIZ];
	char date[BUFSIZ];

	if( Short_format ){
		(void)fprintf(stdout,"%d %s: %s\n", seq, q->q_name, q->q_user );
		(void)fflush(stdout);
		return;
	}
	if( header == 0 ){
		(void)fprintf(stdout, hdr_format,"Rank","Owner","Pr","Job",
			"Host","Files","Size","Date");
		header = 1;
	}
	if( q->q_daemon ){
		if( SV == 0 || *SV == 0 ){
			(void)strcpy( buf, "active" );
		} else {
			(void)strcpy( buf, q->q_server );
		}
	} else {
		switch( seq ){
		case 1: suffix = "st"; break;
		case 2: suffix = "nd"; break;
		case 3: suffix = "rd"; break;
		default: suffix = "th"; break;
		}
		(void)sprintf(buf, "%d%s", seq, suffix );
	}
	/*
	 * print short name
	 */
	(void)strcpy(name, &q->q_from );
	suffix = index( name, '.' );
	if( suffix ){
		*suffix = 0;
	}
	(void)fprintf(stdout, info_format, buf, q->q_user, q->q_priority, q->q_num,
		name,q->q_data, q->q_size, short_time(q->q_sp) );
	(void)fflush(stdout);
}

/*
 * show status:
 * show the status files for the server devices
 */
showstatus()
{
	static char server_name[BUFSIZ];	/* Name of server file */
	int active, pid;
	char buf[BUFSIZ];
	char *sp, *ep;			/* ACME Pointer */

	if( SV == 0 || *SV == 0 ){
		if( Jobcount > 0 && server == 0 ){
			(void)fprintf(stdout, "Warning: no server present\n" );
		}
		printstatus();
		return;
	}
	/*
	 * check for each of the servers
	 */
	(void)strcpy( server_name, SV );
	for( sp = server_name; sp; sp = ep ){
		if( ep = index( sp, ',' ) ){
			*ep = 0;
			++ep;
		}
		/*
		 * get the lock file and the status from the server
		 */
		if( Set_pc_entry( sp, Server_pc_vars, Server_pc_len ) == 0 ){
			fatal( XLOG_INFO, "no server entry for %s", sp );
		}
		buf[0] = 0;
		active = Checklockfile( sp, &pid,buf,sizeof(buf),&LO_statb );
		(void)fprintf(stdout, " server- %s", sp );
		if( LO_statb.st_mode & DISABLE_PRINT ){
			(void)fprintf(stdout, " disabled");
		} else {
			(void)fprintf(stdout, " enabled");
		}
		if( active ){
			(void)fprintf(stdout, ", server %d, processing %s",pid, buf );
		}
		putchar( '\n' );
		(void)fflush( stdout );
		printstatus();
	}
}

