/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: checkpc.c
 * Check out a print cap,  and create entries
 ***************************************************************************
 * Revision History: Created Tue Mar  1 07:56:38 CST 1988
 * $Log:	checkpc.c,v $
 * Revision 3.1  88/06/18  09:33:56  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.2  88/05/14  10:20:42  papowell
 * Modified -X flag handling
 * 
 * Revision 2.1  88/05/09  10:07:42  papowell
 * PLP: Released Version
 * 
 * Revision 1.6  88/04/15  13:06:27  papowell
 * Std_environ() call added, to ensure that fd 0 (stdin), 1 (stdout), 2(stderr)
 * have valid file descriptors;  if not open, then /dev/null is used.
 * 
 * Revision 1.5  88/04/07  12:30:22  papowell
 * 
 * Revision 1.4  88/03/25  14:59:05  papowell
 * Debugged Version:
 * 1. Added the PLP control file first transfer
 * 2. Checks for MX during file transfers
 * 3. Found and fixed a mysterious bug involving the SYSLOG facilities;
 * 	apparently they open files and then assume that they will stay
 * 	open.
 * 4. Made sure that stdin, stdout, stderr was available at all times.
 * 
 * Revision 1.3  88/03/12  10:03:28  papowell
 * *** empty log message ***
 * 
 * Revision 1.2  88/03/11  19:28:12  papowell
 * Minor Changes, Updates
 * 
 * Revision 1.1  88/03/01  11:08:16  papowell
 * Initial revision
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: checkpc.c,v 3.1 88/06/18 09:33:56 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint
/*
 * checkpc: check out the entries in the printcap,
 * checking to see that the default files and directories are present
 * or absent as are indicated by the printcap entry.
 *
 * checkpc [-l] [-s] [-a] [-o] [-f] [-Pprinter] [printcapfile]
 * The default is to create all the various files;
 * the following flags are used to disable automatic creation:
 * -l - no log file
 * -s - no status file
 * -o - no output device
 * -a - no accounting file
 * -f - fix, attempt to create with the desired perms
 * -P printer this printer only
 * printcapfile: name of the printcap file to be used; default is /etc/printcap
 */

#include "lp.h"

int	noout;			/* no output file */
int	nolog;			/* no log file */
int noout;			/* no output file */
int nostat;			/* no status file */
int noacct;			/* no accounting file */
int fix;			/* fix if bad or missing */
struct passwd *pwent, *getpwnam();	/* password entry */
int DU, DG;
int canchown;		/* can do chown */

main( argc, argv )
	int argc;
	char **argv;
{
	char **prlist;
	int option;

	/*
	 * Set fd 0, 1, 2 to /dev/null if not open
	 */
	Std_environ();
	/*
	 * set umask to avoid problems with user umask
	 */
	(void)umask(0);

#	ifdef XPERIMENT
		Setup_test();
#	endif XPERIMENT
	/*
     * set up the pathnames for information files
	 */
	fprintf( stdout, "before printcap  '%s'\n", Printcap );
	Tailor_names();
	fprintf( stdout, "after printcap  '%s'\n", Printcap );

    while ((option = Getopt( argc, argv, "D:afolsXP:" )) != EOF ){
        switch (option) {
        case 'D':       /* turn on Debugging */
			if( Optarg ){
				Debug = atoi( Optarg );
			}
            break;
		default:
			usage();
			break;
		case 'a':	/* no acct file */
			++noacct;
			break;
		case 'f':	/* no acct file */
			++fix;
			break;
		case 'o':	/* no output file */
			++noout;
			break;
		case 'l':	/* no log file */
			++nolog;
			break;
		case 's':	/* no status file */
			++nostat;
			break;
		case 'X':	/* Test version */
#	ifdef DEBUG
			Setup_test();
			Tailor_names();
#	else
			usage();
#	endif DEBUG
			break;
		case 'P':	/* printer */
			if( Optarg ){
				Printer = Optarg;
			} else {
				usage();
			}
			break;
		}
	}
	if( Optind < argc ){
		(void)strcpy(Printcap, argv[Optind]);
		++Optind;
	}
	if( Optind < argc ){
		usage();
	}

	canchown = (geteuid() == 0 );

	if( canchown == 0 ){
		(void)fprintf(stdout, "%s: not running root\n", Name );
		(void)fflush(stdout);
	}

	if((pwent = getpwnam(DAEMON) ) == NULL){
		logerr_die( XLOG_DEBUG, "getpwnam failed for daemon" );
	}
	DU = pwent->pw_uid;
	DG = pwent->pw_gid;
	(void)fprintf(stdout, "Printcap file: %s\n", Printcap );
		(void)fflush(stdout);
	if( Printcap[0] != '/' ){
		(void)fprintf(stdout, "Printcap file must be absolute path name\n");
		(void)fflush(stdout);
		exit(1);
	}

	if( Printer ){
		doprinter();
	} else {
		(void)fprintf(stdout, "Doing all printers\n" );
		(void)fflush(stdout);
		for(prlist = All_printers(); Printer = *prlist; ++prlist ){
			doprinter();
		}
	}
}

/*
 *	doprinter:
 *	1. get the printcap entry
 *	2. check the spool direcotry for ownership, etc.
 *  3. check the log, accounting, and lock file for existence.
 */
doprinter()
{
	if( Get_pc_entry(Printer, All_pc_vars, All_pc_len ) == 0){
		(void)fprintf(stdout,"no printer %s", Printer );
		(void)fflush(stdout);
		return;
	}
	(void)fprintf(stdout, "checking printer %s: ", Printer );
		(void)fflush(stdout);
	/*
	 * check to see if the spool directory exists
	 */
	(void)fprintf(stdout, "SD %s, ",SD);
		(void)fflush(stdout);
	(void)all_check( 0,S_IFDIR, SD, 0755, "daemon", "daemon" );
	if( chdir( SD ) < 0 ){
		logerr( XLOG_DEBUG, "cannot chdir to SD" );
		return;
	}
	if( noout == 0 && LP  && *LP ){
		(void)fprintf(stdout, "LP %s, ",LP);
		(void)fflush(stdout);
		(void)all_check( noout,S_IFREG, LP, 0644, "daemon", "daemon" );
	}
	if( nolog == 0 && LF && *LF ){
		(void)fprintf(stdout, "LF %s, ",LF);
		(void)fflush(stdout);
		(void)all_check( nolog,S_IFREG, LF, 0664, "daemon", "daemon" );
	}
	if( LO && *LO ){
		(void)fprintf(stdout, "LO %s, ",LO);
		(void)fflush(stdout);
		(void)all_check( 0,S_IFREG, LO, 0644, "daemon", "daemon" );
	}
	if( noacct || AF == 0 ||  *AF == 0 ){
		(void)fprintf(stdout, "no AF, ");
			(void)fflush(stdout);
	} else {
		(void)fprintf(stdout, "AF %s, ",AF);
			(void)fflush(stdout);
		(void)all_check( noacct,S_IFREG, AF, 0664, "daemon", "daemon" );
	}
	if( nostat == 0 && ST && *ST ){
		(void)fprintf(stdout, "ST %s, ",ST);
		(void)fflush(stdout);
		(void)all_check( nostat,S_IFREG, ST, 0664, "daemon", "daemon" );
	}
	if( PS && *PS ){
		(void)fprintf(stdout, "PS %s, ",PS);
		(void)fflush(stdout);
		(void)all_check( nostat,S_IFREG, PS, 0664, "daemon", "daemon" );
	}
	(void)fprintf(stdout, "\n" );
		(void)fflush(stdout);
}

/*
 * check and fix if necessary
 */
all_check(remove,type,path,perms, owner, group)
	int type;	/* S_IFDIR or S_IFREG */
	char *path;	/* pathname of thing */
	int perms;	/* perms for the file/directory */
	char *owner, *group;
{
	struct stat statbuf;
	char cmd[BUFSIZ];
	int status;
	int ok;

	ok = 1;
	if( stat( path, &statbuf ) < 0 ){
		logerr( XLOG_DEBUG, "%s cannot be stated", path);
		if( remove ){
			return 1;
		}
		if( fix ){
			fixup( type, path, perms, owner, group );
		}
		return(0);
	}
	if( remove ){
		(void)fprintf(stdout, "removing %s", path );
		(void)fflush(stdout);
		(void)sprintf( cmd, "rm -f %s", path );
		status = system(cmd);
		if(status){
			(void)fprintf(stdout, "fix: %s failed, try by hand\n", cmd);
		(void)fflush(stdout);
			exit(1);
		}
	}
	if( (statbuf.st_mode & type) == 0 ){
		(void)fprintf(stdout,"not a %s ",(type==S_IFDIR)?"directory":"file" );
		(void)fflush(stdout);
		return(0);
	}
	if( statbuf.st_uid != DU ){
		ok = 0;
		(void)fprintf(stdout, "not owner '%s' ",owner );
		(void)fflush(stdout);
		if( fix  && canchown ){
			fixup( type, path, perms, owner, group );
			return 0;
		}
	}
	if( statbuf.st_gid != DG ){
		ok = 0;
		(void)fprintf(stdout, "not group '%s' ",group );
		(void)fflush(stdout);
		if( fix  && canchown ){
			fixup( type, path, perms, owner, group );
			return 0;
		}
	}
	if( (statbuf.st_mode & 0777) != perms ){
		ok = 0;
		(void)fprintf(stdout, "perms are %o ", (statbuf.st_mode & 0777) );
		(void)fflush(stdout);
		if( fix ){
			fixup( type, path, perms, owner, group );
			return 0;
		}
	}
	putchar( '\n' );
	(void)fflush(stdout);
	return ( ok );
}

/*
 * fixup( type, path, perms, owner, group )
 * -- try to create the file/directory with the appropriate
 * permissions
 */
fixup( type, path, perms, owner, group )
	int type, perms;
	char *path, *owner, *group;
{
	int status;
	char cmd[BUFSIZ];
	struct stat statbuf;

	(void)fprintf(stdout, "trying to fix %s %s\n",(type==S_IFDIR)?"directory":"file",path);
		(void)fflush(stdout);
	if( type==S_IFDIR ){
		(void)sprintf( cmd, "mkdir %s", path );
	} else {
		(void)sprintf( cmd, "touch %s", path );
	}
	(void)fprintf(stdout, "fix: %s\n", cmd );
		(void)fflush(stdout);
	status = system( cmd );
	if( stat( path, &statbuf ) < 0 ){
		(void)fprintf(stdout, "cannot stat %s, you have to try by hand\n", path );
		(void)fflush(stdout);
	}
	/*
	 * fix up ownership and perms, you are root
	 */
	if( canchown ){
		(void)sprintf(cmd, "chown %s %s", owner, path );
		(void)fprintf(stdout, "fix: %s\n", cmd );
			(void)fflush(stdout);
		status = system( cmd );
		if(status){
			(void)fprintf(stdout, "fix: %s failed, try by hand\n", cmd);
		}
		(void)sprintf(cmd, "chgrp %s %s", group, path );
		(void)fprintf(stdout, "fix: %s\n", cmd );
			(void)fflush(stdout);
		status = system( cmd );
		if(status){
			(void)fprintf(stdout, "fix: %s failed, try by hand\n", cmd);
		}
	}
	(void)sprintf(cmd, "chmod %o %s", perms, path );
	(void)fprintf(stdout, "fix: %s\n", cmd );
		(void)fflush(stdout);
	status = system( cmd );
	if(status){
		(void)fprintf(stdout, "fix: %s failed, try by hand\n", cmd);
	}
}

usage()
{
	(void)fprintf(stdout,
	"use: %s [-aflso][-Pprinter] [printcapfile]", Name);
		(void)fflush(stdout);
	exit(1);
}

cleanup()
{ ; }
