/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: banner.c
 ***************************************************************************
 * Revision History: Fri Jan 15 12:13:50 CST 1988
 * $Log:	banner.c,v $
 * Revision 3.1  88/06/18  09:36:50  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 3.1  88/06/18  09:30:10  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.1  88/05/09  10:07:30  papowell
 * PLP: Released Version
 * 
 * Revision 1.5  88/05/05  20:09:07  papowell
 * Modified short banner format
 * 
 * Revision 1.4  88/04/21  21:51:21  papowell
 * Removed spurious line feeds
 * 
 * Revision 1.3  88/03/25  14:58:55  papowell
 * Debugged Version:
 * 1. Added the PLP control file first transfer
 * 2. Checks for MX during file transfers
 * 3. Found and fixed a mysterious bug involving the SYSLOG facilities;
 * 	apparently they open files and then assume that they will stay
 * 	open.
 * 4. Made sure that stdin, stdout, stderr was available at all times.
 * 
 * Revision 1.2  88/03/05  15:01:32  papowell
 * Minor Corrections,  Lint Problems
 * 
 * Revision 1.1  88/03/01  11:08:11  papowell
 * Initial revision
 * 
 * banner printing routine.
 * some of the code (the tables for the banner headers) was stolen from the
 * old LPD program.  But this in turn was snarfed from a banner
 * printing games program.  Which snarfed it from an old card deck... etc.
 *
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: banner.c,v 3.1 88/06/18 09:36:50 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint

#include "lp.h"

/*
 * Print a banner
 * The large character fonts have been stolen from the
 * BANNER program, which stole them from an old card deck...
 * 
 * banner( fd )
 * will print the banner
 * 1. form feed if needed
 * 2. print banner
 * 3. another form feed
 */
#define HEIGHT  9       /* height of representation of characters */
#define WIDTH   8       /* width of characters */
#define DROP    3       /* offset to drop characters with descenders */
#define BLAST   10      /* 10 lines to separate things */
#define SEP     3       /* 3 lines to separate BLAST from printing */

static int linecnt;
static int fail;
extern char chartable[][HEIGHT];
static char *bline;
static unsigned blen;
static int fd;

int
banner( pr )
	int pr;
{
	linecnt = 0;
	/*
	 * print the banner
	 */

	fd = pr;
	fail = 0;
	if( bline == 0 ){
		blen = BUFSIZ;
		if( (bline = malloc( blen )) == 0 ){
			logerr_die( XLOG_INFO, "banner: malloc failed" );
		}
	}
	if( blen < PW+1 ){
		blen = PW+2;
		if( (bline = realloc( bline, blen )) == 0 ){
			logerr_die( XLOG_INFO, "banner: realloc failed" );
		}
	}
	if( SB ) {
		shortbanner();
	} else {
		longbanner();
	}
	if(Debug>4)log( XLOG_DEBUG, "banner: printed, fail %d", fail);
	if( fail ){
		return( JFAIL );
	} else {
		return( JSUCC );
	}
}

/*
 * shortbanner
 * single line, has format:
 * adobe:shore  Job: test.data  Date: Tue Sep 18 16:22:33 1984
 */
shortbanner()
{
	(void)sprintf(bline, "%s:%s Job: %s Date: %s", LOGNAME, FROMHOST, JOBNAME, Time_str());
	Out_line();
}
/*
 * userinfo
 * just print the information
 */
userinfo()
{
	(void)sprintf(bline, "User: %s@%s", LOGNAME, FROMHOST);
	Out_line();
	(void)sprintf(bline, "Name: %s", BNRNAME);
	Out_line();
	(void)sprintf(bline, "Date: %s", Time_str());
	Out_line();
	(void)sprintf(bline, "Job: %s", JOBNAME );
	Out_line();
	(void)sprintf(bline, "Class: %s", CLASSNAME );
	Out_line();
}
/*
 * long banner
 * get fancy and print separators, etc.
 */
longbanner()
{
	int i;			/* ACME integers, INC */

	for( i = 0; i < BLAST; ++i ){
		breakline( '*');
	}
	for( i = 0; i < SEP; ++i ){
		breakline( 0 );
	}
	/*
	 * print the Name and Host in BIG letters
	 */
	bigprint( LOGNAME);
	bigprint( FROMHOST);
	userinfo();
	for( i = 0; i < SEP; ++i ){
		breakline( 0);
	}
	if( PL > 0 ){
		/* separator from banner */
		while( (linecnt + BLAST) % PL ){
			breakline( 0 );
		}
		/* page bottom marker */
		while(  linecnt % PL ){
			breakline( '*' );
		}
	}
}

breakline( c )
	int c;
{
	int	i;	/* ACME Integers, Inc. */

	i = 0;
	if( c ){
		for( i = 0; i < PW; ++i ){
			bline[i] = c;
		}
	}
	bline[i] = 0;
	Out_line();
}

/***************************************************************************
 * bigprint( char * line )
 * print the line in big characters 
 * for i = topline to bottomline do
 *  for each character in the line do
 *    get the scan line representation for the character
 *    foreach bit in the string do
 *       if the bit is set, print X, else print ' ';
 *	  endfor
 *  endfor
 * endfor
 ***************************************************************************/

bigprint( line )
	char *line;
{
	int i, j;		/* ACME Integers, Inc. */
	int cnt;		/* number of characters */

	if(Debug>5)log(XLOG_DEBUG,"bigprint: '%s'", line );
	cnt = strlen(line);
	i = PW/WIDTH;
	if( cnt > i ){
		cnt = i;
	}
	for( i = 0;  i < HEIGHT+DROP; ++i ){
		for( j = 0; j < cnt; ++j ){
			do_char( line[j], i, bline+(j*WIDTH) );
		}
		bline[j*WIDTH] = 0;
		Out_line();
	}
}

/***************************************************************************
 * do_char( c, line, buf )
 *  print out the raster line corresponding to character c, line l
 *  If a character is not a descender, you can use the direct mapping.
 *  If it is a descender,  you have to shift down by the descender amount.
 *  1.  for lines above the "top" of a descender line
 *      if the character is a descender, print a space
 *      otherwise print normally
 *  2.  for lines at and below the top of a descender
 *      if the character is a descender, print line
 *      otherwise print normally
 *  3.  for lines below the baseline
 *      if a descender, print line
 *      otherwise print blank
 ***************************************************************************/
static int
is_descender(c)
	char c;
{
	switch(c) {
	case '_': case ';': case ',': case 'g': case 'j': case 'p':
	case 'q': case 'y':
		return(1);
	default:
		break;
	}
	return (0);
}

do_char( c, line, buf )
	int c;		/* character */
	int line;
	char *buf;
{
	int i;					/* ACME Integer, Inc. */
	int position;			/* index into chartable */
	int rep;				/* representation of character scan line */

	if( !isprint( c ) ){
		c = ' ';
	}
	if(Debug>5)log(XLOG_DEBUG,"do_char: %c, line %d", c, line );
	position = c - ' ';
	if( is_descender(c) ){
		if( line >= DROP ){
			line = line - DROP;
		} else {
			position = 0;
			line = 0;
		}
	}
	if( line >= HEIGHT ){
		position = 0;
		line = 0;
	}

	rep = chartable[position][line];
	if(Debug>5)log(XLOG_DEBUG,"do_char: position %d, line %d, rep 0x%x",
		position, line, rep );
	for( i = 6; i >= 0; --i ){
		if( rep & (1 << i)){
			buf[6-i] = 'o';
		} else {
			buf[6-i] = ' ';
		}
	}
	for( i = 7; i < WIDTH; ++i ){
		buf[i] = ' ';
	}
}


/***************************************************************************
 * Out_line( char* buf )
 * write the buffer out to the file descriptor.
 * don;t do if fail is invalid.
 ***************************************************************************/
Out_line()
{
	int i;
	i = strlen(bline);

	if( fail == 0 ){
		if( (i > 0 && write( fd, bline, i) != i) || write( fd, "\n", 1) != 1){
			logerr( XLOG_INFO, "Out_line: write failed" );
			fail = 1;
		}
	}
	++linecnt;
}

#define c_______ 0
#define c______1 01
#define c_____1_ 02
#define c____1__ 04
#define c____11_ 06
#define c___1___ 010
#define c___1__1 011
#define c___1_1_ 012
#define c___11__ 014
#define c__1____ 020
#define c__1__1_ 022
#define c__1_1__ 024
#define c__11___ 030
#define c__111__ 034
#define c__111_1 035
#define c__1111_ 036
#define c__11111 037
#define c_1_____ 040
#define c_1____1 041
#define c_1___1_ 042
#define c_1__1__ 044
#define c_1_1___ 050
#define c_1_1__1 051
#define c_1_1_1_ 052
#define c_11____ 060
#define c_11_11_ 066
#define c_111___ 070
#define c_111__1 071
#define c_111_1_ 072
#define c_1111__ 074
#define c_1111_1 075
#define c_11111_ 076
#define c_111111 077
#define c1______ 0100
#define c1_____1 0101
#define c1____1_ 0102
#define c1____11 0103
#define c1___1__ 0104
#define c1___1_1 0105
#define c1___11_ 0106
#define c1__1___ 0110
#define c1__1__1 0111
#define c1__11_1 0115
#define c1__1111 0117
#define c1_1____ 0120
#define c1_1___1 0121
#define c1_1_1_1 0125
#define c1_1_11_ 0126
#define c1_111__ 0134
#define c1_1111_ 0136
#define c11____1 0141
#define c11___1_ 0142
#define c11___11 0143
#define c11_1___ 0150
#define c11_1__1 0151
#define c111_11_ 0166
#define c1111___ 0170
#define c11111__ 0174
#define c111111_ 0176
#define c1111111 0177

char chartable[][HEIGHT] =	/* this is relatively easy to modify */
			/* just look: */
{
	{ c_______,
	  c_______,
	  c_______,
	  c_______,
	  c_______,
	  c_______,
	  c_______,
	  c_______,
	  c_______ },			/*   */

	{ c__11___,
	  c__11___,
	  c__11___,
	  c__11___,
	  c__11___,
	  c_______,
	  c_______,
	  c__11___,
	  c__11___ },			/* ! */

	{ c_1__1__,
	  c_1__1__,
	  c_______,
	  c_______,
	  c_______,
	  c_______,
	  c_______,
	  c_______,
	  c_______ },			/* " */

	{ c_______,
	  c__1_1__,
	  c__1_1__,
	  c1111111,
	  c__1_1__,
	  c1111111,
	  c__1_1__,
	  c__1_1__,
	  c_______ },			/* # */

	{ c___1___,
	  c_11111_,
	  c1__1__1,
	  c1__1___,
	  c_11111_,
	  c___1__1,
	  c1__1__1,
	  c_11111_,
	  c___1___ },			/* $ */

 	{ c_1_____,
 	  c1_1___1,
 	  c_1___1_,
 	  c____1__,
 	  c___1___,
 	  c__1____,
 	  c_1___1_,
 	  c1___1_1,
 	  c_____1_ },			/* % */
 
 	{ c_11____,
 	  c1__1___,
 	  c1___1__,
 	  c_1_1___,
 	  c__1____,
 	  c_1_1__1,
 	  c1___11_,
 	  c1___11_,
 	  c_111__1 },			/* & */
 
 	{ c___11__,
 	  c___11__,
 	  c___1___,
 	  c__1____,
 	  c_______,
 	  c_______,
 	  c_______,
 	  c_______,
 	  c_______ },			/* ' */
 
 	{ c____1__,
 	  c___1___,
 	  c__1____,
 	  c__1____,
 	  c__1____,
 	  c__1____,
 	  c__1____,
 	  c___1___,
 	  c____1__ },			/* ( */
 
 	{ c__1____,
 	  c___1___,
 	  c____1__,
 	  c____1__,
 	  c____1__,
 	  c____1__,
 	  c____1__,
 	  c___1___,
 	  c__1____ },			/* ) */
 
 	{ c_______,
 	  c___1___,
 	  c1__1__1,
 	  c_1_1_1_,
 	  c__111__,
 	  c_1_1_1_,
 	  c1__1__1,
 	  c___1___,
 	  c_______ },			/* * */
 
 	{ c_______,
 	  c___1___,
 	  c___1___,
 	  c___1___,
 	  c1111111,
 	  c___1___,
 	  c___1___,
 	  c___1___,
 	  c_______ },			/* + */
 
 	{ c_______,
 	  c_______,
 	  c_______,
 	  c_______,
 	  c__11___,
 	  c__11___,
 	  c__1____,
 	  c_1_____,
 	  c_______ },			/* , */
 
 	{ c_______,
 	  c_______,
 	  c_______,
 	  c_______,
 	  c1111111,
 	  c_______,
 	  c_______,
 	  c_______,
 	  c_______ },			/* - */
 
 	{ c_______,
	  c_______,
	  c_______,
	  c_______,
	  c_______,
	  c_______,
	  c_______,
	  c__11___,
	  c__11___ },			/* . */

	{ c_______,
	  c______1,
	  c_____1_,
	  c____1__,
	  c___1___,
	  c__1____,
	  c_1_____,
	  c1______,
	  c_______ },			/* / */

	{ c_11111_,
	  c1_____1,
	  c1____11,
	  c1___1_1,
	  c1__1__1,
	  c1_1___1,
	  c11____1,
	  c1_____1,
	  c_11111_ },			/* 0 */

	{ c___1___,
	  c__11___,
	  c_1_1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c_11111_ },			/* 1 */

	{ c_11111_,
	  c1_____1,
	  c______1,
	  c_____1_,
	  c__111__,
	  c_1_____,
	  c1______,
	  c1______,
	  c1111111 },			/* 2 */

	{ c_11111_,
	  c1_____1,
	  c______1,
	  c______1,
	  c__1111_,
	  c______1,
	  c______1,
	  c1_____1,
	  c_11111_ },			/* 3 */

	{ c_____1_,
	  c____11_,
	  c___1_1_,
	  c__1__1_,
	  c_1___1_,
	  c1____1_,
	  c1111111,
	  c_____1_,
	  c_____1_ },			/* 4 */

	{ c1111111,
	  c1______,
	  c1______,
	  c11111__,
	  c_____1_,
	  c______1,
	  c______1,
	  c1____1_,
	  c_1111__ },			/* 5 */

	{ c__1111_,
	  c_1_____,
	  c1______,
	  c1______,
	  c1_1111_,
	  c11____1,
	  c1_____1,
	  c1_____1,
	  c_11111_ },			/* 6 */

	{ c1111111,
	  c1_____1,
	  c_____1_,
	  c____1__,
	  c___1___,
	  c__1____,
	  c__1____,
	  c__1____,
	  c__1____ },			/* 7 */

	{ c_11111_,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c_11111_,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c_11111_ },			/* 8 */

	{ c_11111_,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c_111111,
	  c______1,
	  c______1,
	  c1_____1,
	  c_1111__ },			/* 9 */

	{ c_______,
	  c_______,
	  c_______,
	  c__11___,
	  c__11___,
	  c_______,
	  c_______,
	  c__11___,
	  c__11___ },			/* : */


	{ c__11___,
	  c__11___,
	  c_______,
	  c_______,
	  c__11___,
	  c__11___,
	  c__1____,
	  c_1_____,
	  c_______ },			/* ; */

	{ c____1__,
	  c___1___,
	  c__1____,
	  c_1_____,
	  c1______,
	  c_1_____,
	  c__1____,
	  c___1___,
	  c____1__ },			/* < */

	{ c_______,
	  c_______,
	  c_______,
	  c1111111,
	  c_______,
	  c1111111,
	  c_______,
	  c_______,
	  c_______ },			/* = */

	{ c__1____,
	  c___1___,
	  c____1__,
	  c_____1_,
	  c______1,
	  c_____1_,
	  c____1__,
	  c___1___,
	  c__1____ },			/* > */

	{ c__1111_,
	  c_1____1,
	  c_1____1,
	  c______1,
	  c____11_,
	  c___1___,
	  c___1___,
	  c_______,
	  c___1___ },			/* ? */

	{ c__1111_,
	  c_1____1,
	  c1__11_1,
	  c1_1_1_1,
	  c1_1_1_1,
	  c1_1111_,
	  c1______,
	  c_1____1,
	  c__1111_ },			/* @ */

	{ c__111__,
	  c_1___1_,
	  c1_____1,
	  c1_____1,
	  c1111111,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c1_____1 },			/* A */

	{ c111111_,
	  c_1____1,
	  c_1____1,
	  c_1____1,
	  c_11111_,
	  c_1____1,
	  c_1____1,
	  c_1____1,
	  c111111_ },			/* B */

	{ c__1111_,
	  c_1____1,
	  c1______,
	  c1______,
	  c1______,
	  c1______,
	  c1______,
	  c_1____1,
	  c__1111_ },			/* C */

	{ c11111__,
	  c_1___1_,
	  c_1____1,
	  c_1____1,
	  c_1____1,
	  c_1____1,
	  c_1____1,
	  c_1___1_,
	  c11111__ },			/* D */

	{ c1111111,
	  c1______,
	  c1______,
	  c1______,
	  c111111_,
	  c1______,
	  c1______,
	  c1______,
	  c1111111 },			/* E */

	{ c1111111,
	  c1______,
	  c1______,
	  c1______,
	  c111111_,
	  c1______,
	  c1______,
	  c1______,
	  c1______ },			/* F */

	{ c__1111_,
	  c_1____1,
	  c1______,
	  c1______,
	  c1______,
	  c1__1111,
	  c1_____1,
	  c_1____1,
	  c__1111_ },			/* G */

	{ c1_____1,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c1111111,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c1_____1 },			/* H */

	{ c_11111_,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c_11111_ },			/* I */

	{ c__11111,
	  c____1__,
	  c____1__,
	  c____1__,
	  c____1__,
	  c____1__,
	  c____1__,
	  c1___1__,
	  c_111___ },			/* J */

	{ c1_____1,
	  c1____1_,
	  c1___1__,
	  c1__1___,
	  c1_1____,
	  c11_1___,
	  c1___1__,
	  c1____1_,
	  c1_____1 },			/* K */

	{ c1______,
	  c1______,
	  c1______,
	  c1______,
	  c1______,
	  c1______,
	  c1______,
	  c1______,
	  c1111111 },			/* L */

	{ c1_____1,
	  c11___11,
	  c1_1_1_1,
	  c1__1__1,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c1_____1 },			/* M */

	{ c1_____1,
	  c11____1,
	  c1_1___1,
	  c1__1__1,
	  c1___1_1,
	  c1____11,
	  c1_____1,
	  c1_____1,
	  c1_____1 },			/* N */

	{ c__111__,
	  c_1___1_,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c_1___1_,
	  c__111__ },			/* O */

	{ c111111_,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c111111_,
	  c1______,
	  c1______,
	  c1______,
	  c1______ },			/* P */

	{ c__111__,
	  c_1___1_,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c1__1__1,
	  c1___1_1,
	  c_1___1_,
	  c__111_1 },			/* Q */

	{ c111111_,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c111111_,
	  c1__1___,
	  c1___1__,
	  c1____1_,
	  c1_____1 },			/* R */

	{ c_11111_,
	  c1_____1,
	  c1______,
	  c1______,
	  c_11111_,
	  c______1,
	  c______1,
	  c1_____1,
	  c_11111_ },			/* S */

	{ c1111111,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___ },			/* T */

	{ c1_____1,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c_11111_ },			/* U */

	{ c1_____1,
	  c1_____1,
	  c1_____1,
	  c_1___1_,
	  c_1___1_,
	  c__1_1__,
	  c__1_1__,
	  c___1___,
	  c___1___ },			/* V */

	{ c1_____1,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c1__1__1,
	  c1__1__1,
	  c1_1_1_1,
	  c11___11,
	  c1_____1 },			/* W */

	{ c1_____1,
	  c1_____1,
	  c_1___1_,
	  c__1_1__,
	  c___1___,
	  c__1_1__,
	  c_1___1_,
	  c1_____1,
	  c1_____1 },			/* X */

	{ c1_____1,
	  c1_____1,
	  c_1___1_,
	  c__1_1__,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___ },			/* Y */

	{ c1111111,
	  c______1,
	  c_____1_,
	  c____1__,
	  c___1___,
	  c__1____,
	  c_1_____,
	  c1______,
	  c1111111 },			/* Z */

	{ c_1111__,
	  c_1_____,
	  c_1_____,
	  c_1_____,
	  c_1_____,
	  c_1_____,
	  c_1_____,
	  c_1_____,
	  c_1111__ },			/* [ */

	{ c_______,
	  c1______,
	  c_1_____,
	  c__1____,
	  c___1___,
	  c____1__,
	  c_____1_,
	  c______1,
	  c_______ },			/* \ */

	{ c__1111_,
	  c_____1_,
	  c_____1_,
	  c_____1_,
	  c_____1_,
	  c_____1_,
	  c_____1_,
	  c_____1_,
	  c__1111_ },			/* ] */

	{ c___1___,
	  c__1_1__,
	  c_1___1_,
	  c1_____1,
	  c_______,
	  c_______,
	  c_______,
	  c_______ },			/* ^ */

	{ c_______,
	  c_______,
	  c_______,
	  c_______,
	  c_______,
	  c_______,
	  c_______,
	  c1111111,
	  c_______ },			/* _ */

	{ c__11___,
	  c__11___,
	  c___1___,
	  c____1__,
	  c_______,
	  c_______,
	  c_______,
	  c_______,
	  c_______ },			/* ` */

	{ c_______,
	  c_______,
	  c_______,
	  c_1111__,
	  c_____1_,
	  c_11111_,
	  c1_____1,
	  c1____11,
	  c_1111_1 },			/* a */

	{ c1______,
	  c1______,
	  c1______,
	  c1_111__,
	  c11___1_,
	  c1_____1,
	  c1_____1,
	  c11___1_,
	  c1_111__ },			/* b */

	{ c_______,
	  c_______,
	  c_______,
	  c_1111__,
	  c1____1_,
	  c1______,
	  c1______,
	  c1____1_,
	  c_1111__ },			/* c */

	{ c_____1_,
	  c_____1_,
	  c_____1_,
	  c_111_1_,
	  c1___11_,
	  c1____1_,
	  c1____1_,
	  c1___11_,
	  c_111_1_ },			/* d */

	{ c_______,
	  c_______,
	  c_______,
	  c_1111__,
	  c1____1_,
	  c111111_,
	  c1______,
	  c1____1_,
	  c_1111__ },			/* e */

	{ c___11__,
	  c__1__1_,
	  c__1____,
	  c__1____,
	  c11111__,
	  c__1____,
	  c__1____,
	  c__1____,
	  c__1____ },			/* f */

	{ c_111_1_,
	  c1___11_,
	  c1____1_,
	  c1____1_,
	  c1___11_,
	  c_111_1_,
	  c_____1_,
	  c1____1_,
	  c_1111__ },			/* g */

	{ c1______,
	  c1______,
	  c1______,
	  c1_111__,
	  c11___1_,
	  c1____1_,
	  c1____1_,
	  c1____1_,
	  c1____1_ },			/* h */

	{ c_______,
	  c___1___,
	  c_______,
	  c__11___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c__111__ },			/* i */

	{ c____11_,
	  c_____1_,
	  c_____1_,
	  c_____1_,
	  c_____1_,
	  c_____1_,
	  c_____1_,
	  c_1___1_,
	  c__111__ },			/* j */

	{ c1______,
	  c1______,
	  c1______,
	  c1___1__,
	  c1__1___,
	  c1_1____,
	  c11_1___,
	  c1___1__,
	  c1____1_ },			/* k */

	{ c__11___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c__111__ },			/* l */

	{ c_______,
	  c_______,
	  c_______,
	  c1_1_11_,
	  c11_1__1,
	  c1__1__1,
	  c1__1__1,
	  c1__1__1,
	  c1__1__1 },			/* m */

	{ c_______,
	  c_______,
	  c_______,
	  c1_111__,
	  c11___1_,
	  c1____1_,
	  c1____1_,
	  c1____1_,
	  c1____1_ },			/* n */

	{ c_______,
	  c_______,
	  c_______,
	  c_1111__,
	  c1____1_,
	  c1____1_,
	  c1____1_,
	  c1____1_,
	  c_1111__ },			/* o */

	{ c1_111__,
	  c11___1_,
	  c1____1_,
	  c1____1_,
	  c11___1_,
	  c1_111__,
	  c1______,
	  c1______,
	  c1______ },			/* p */

	{ c_111_1_,
	  c1___11_,
	  c1____1_,
	  c1____1_,
	  c1___11_,
	  c_111_1_,
	  c_____1_,
	  c_____1_,
	  c_____1_ },			/* q */

	{ c_______,
	  c_______,
	  c_______,
	  c1_111__,
	  c11___1_,
	  c1______,
	  c1______,
	  c1______,
	  c1______ },			/* r */

	{ c_______,
	  c_______,
	  c_______,
	  c_1111__,
	  c1____1_,
	  c_11____,
	  c___11__,
	  c1____1_,
	  c_1111__ },			/* s */

	{ c_______,
	  c__1____,
	  c__1____,
	  c11111__,
	  c__1____,
	  c__1____,
	  c__1____,
	  c__1__1_,
	  c___11__ },			/* t */

	{ c_______,
	  c_______,
	  c_______,
	  c1____1_,
	  c1____1_,
	  c1____1_,
	  c1____1_,
	  c1___11_,
	  c_111_1_ },			/* u */

	{ c_______,
	  c_______,
	  c_______,
	  c1_____1,
	  c1_____1,
	  c1_____1,
	  c_1___1_,
	  c__1_1__,
	  c___1___ },			/* v */

	{ c_______,
	  c_______,
	  c_______,
	  c1_____1,
	  c1__1__1,
	  c1__1__1,
	  c1__1__1,
	  c1__1__1,
	  c_11_11_ },			/* w */

	{ c_______,
	  c_______,
	  c_______,
	  c1____1_,
	  c_1__1__,
	  c__11___,
	  c__11___,
	  c_1__1__,
	  c1____1_ },			/* x */

	{ c1____1_,
	  c1____1_,
	  c1____1_,
	  c1____1_,
	  c1___11_,
	  c_111_1_,
	  c_____1_,
	  c1____1_,
	  c_1111__ },			/* y */

	{ c_______,
	  c_______,
	  c_______,
	  c111111_,
	  c____1__,
	  c___1___,
	  c__1____,
	  c_1_____,
	  c111111_ },			/* z */

	{ c___11__,
	  c__1____,
	  c__1____,
	  c__1____,
	  c_1_____,
	  c__1____,
	  c__1____,
	  c__1____,
	  c___11__ },			/* } */

	{ c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___,
	  c___1___ },			/* | */

	{ c__11___,
	  c____1__,
	  c____1__,
	  c____1__,
	  c_____1_,
	  c____1__,
	  c____1__,
	  c____1__,
	  c__11___ },			/* } */

	{ c_11____,
	  c1__1__1,
	  c____11_,
	  c_______,
	  c_______,
	  c_______,
	  c_______,
	  c_______,
	  c_______ },			/* ~ */

	{ c_1__1__,
	  c1__1__1,
	  c__1__1_,
	  c_1__1__,
	  c1__1__1,
	  c__1__1_,
	  c_1__1__,
	  c1__1__1,
	  c__1__1_ }			/* rub-out */
};
