.ig
$Header: 07.t,v 1.1 88/05/21 18:39:43 papowell Locked $
$log$
..
.bp
.NH 1
Filter Support
.PP
The filter programs are started by a queue server
in order to support specialized unspooling operations.
While the server process runs SUID 
.L root ,
and the filter process will also run SUID
.L daemon .
The ownerships of files,
etc.,
which have to be manipulated by filter programs should
have the appropriate permissions for the
.L daemon
userid.
.PP
There are a set of template filters supplied with the PLP software
that can be easily modified to meet most common requirements.
A common method of incorporating new filters is to use a shell
script as a filter,
and have the shell script invoke a specialized program with the
appropriate parameters.
This techique has a slight penalty in performance,
but is very quick to implement.
.PP
.NH 2
Filter Program Invocation and Actions
.PP
Output filters are invoked by the queue server daemon,
and take their input from stdin
(file descriptor 0),
have stdout (file descriptor 1) connected to the output device,
and stderr (file descriptor 2) connected either to
.B lf
(log file) or to a data sink (/dev/null).
Normal completion of the filter results when
it reads EOF on stdin,
and should exit with user status 0 if there were no errors.
It should ignore any SIGPIPE signals.
A user status 1 indicates that the job did not complete
normally and should be reprinted,
and any other status will cause the job to be discarded.
The filter should also check for successful writes to stdout.
.PP
A filter process runs setuid 
.I daemon
and is in the same process group as its creating server process.
This allows
.IR killpg \|(2)
to kill both the queue server process and any filters it has created.
For example,
.I lprm
terminates a running queue handler by
sending a SIGINT signal to the queue servers process group using
.I killpg.
This signal can be trapped by filters which need
to perform cleanup operations such as
deleting temporary files.
.NH 2
Filter Parameters and Invocation
.PP
Filters are invoked with a set of parameters determined by the
entries in the printcap,
their intended purpose,
and other actions.
Figure 7.1 is an example of a filter specification.
.KF
.in +1i
.nf
.DT
.L
.SM
# Versatec Printer, Lind 33
# Patrick Powell, 3 Nov 87
#   Uses the new filters
versatec\||\|versatec_lind33:\e
	:fx=flpdt:mx#2000:\e
	:lp=/dev/va0:sd=/usr/spool/versatec_lind33:\e
	:af=/usr/adm/vaacct:\e
	:of=/usr/lib/vpf -v3 -m '-K prefix \e013\e015':
.LG
.in -1i
.R
.ce
Figure 7.1. Filter Specification Example
.KE
.PP
A filter is invoked with the parameters in Figure 7.2,
which may be present or missing,
and in any order.
The accounting file (if present) will always be the last parameter,
and is the only one without a
.B \-
prefix.
.KF
.nf
.DT
.L
.SM
.in +1i
filtername arguments \e
	-Pprinter -wwidth -llength -xwidth -ylength [-c] [-iindent] \e
	[-Zoptions] [-Cclass] [-Jjob] [-Raccntname] -nlogin -hHost \e
	-Fformat [affile]
.R
.in -1i
.LG
.ce
Figure 7.2  Filter Arguments
.KE
.PP
The
.I filtername
and
.I arguments
values are provided in the printcap filter information.
Arguments can be quoted and will be passed as a single argument to the
filter program,
similar to the method used by the Bourne shell.
Note that the escape sequences in Figure 7.1 will be translated into
a single character value,
and the resulting string will be an arguement for the filter.
.PP
The
.B \-P
(printer) option is used to pass the printcap entry printer name.
The
.B \-w
and
.B \-l
options specify the horizontal and vertical page
size in characters and lines (obtained from the
.B pw
and
.B pl
printcap entries).
Note that the
.L "lpr -wNNN"
value will be passed if it has been specified by a user as the
.B \-w
option value.
The
.B \-x
and
.B \-y
options specify the horizontal and vertical page
size in pixels (from the
.B px
and
.B py
printcap entries).
The
.B \-F
(format)
option specifies the format that this filter is being used for.
.PP
The above parameters are provided for all filters,
including the OF filter and
BP and EP banner printing filters.
The OF filter must detect the character sequence ESC\ ^A
(\e031, \e001),
flush its output,
and suspend itself using \fIkill\fP\|(\fIgetpid\fP(),\ SIGSTOP).
The server will then start up other filters,
and use them to print jobs.
After the job has been printed,
the server will signal the OF filter to continue using
SIGCONT.
.PP
All filters are invoked with the above parameters,
and the additional ones may be provided depending on functionality.
The
.B \-c
(literal) flag is optional,
and is specified for literal or
.B \-l
output being printed using the
.B IF
filter.
The
.B \-i
(indent)
value is optional,
and is the value specified by the
.B \-i
option of
.I lpr .
The
.B \-Z
(extra parameters) are parameters passed to the filter by the
.I lpr
.B \-Z
option.
The
.B \-C
(class or priority)
and
.B \-J
(job name)
are optional and generated by
.IR lpr .
The
.B \-n
and
.B \-h
parameters specify the login name and host name respectively of the
originator of the job.
.PP
The last (optional) entry is the name of the
accounting file,
taken from the
.B af
printcap entry.
This may be a default value,
or specified by the user.
If the accounting file does not exist or is unable to be opened in
append mode,
then accounting action is suppressed.
.NH 2
Banner Printing Filters
.PP
The
.B bp
(banner printer BP)
and
.B ep
(end printer EP)
entries specify a banner and end printing program that is invoked
at the start and end of a job.
The BP and EP filters are invoked with the same parameters as the
IF filter,
and with the
.B -Ff
format option.
Special flags and parameters for these filters may be specified 
in the printcap entry.
.PP
The banner printing programs will have
their standard input
(file descriptor 0) set to
.L /dev/null ,
standard output
(file descriptor 1) to the output device,
and standard error
(file descriptor 2)
to the error logging file.
They must exit with 0 user status for successful completion;
any other value indicates unsuccessful completion and the
and an error reported.
.NH 2
Accounting Information
.PP
Accounting information is appended to the accounting file by the
appropriate output filter.
Rather than have a complex binary accounting database,
this version assumes that accounting information will be simple and easy
to maintain and understand.
The
.I pac
program has been supplied to make accounting information easily managable,
but most accounting procedures can be carried out with a simple
shell script,
and a hearty use of
.I sort ,
.I sed ,
and
.I awk .
In order to keep track of accounting information,
it must be maintained in a consistent manner.
Entries in the raw accounting file should have the form
illustrated in
Figure 7.3.
.KF
.L
.SM
.in +1i
.nf
host              user printer       format pages date
attila.cs.umn.edu root imagen_lind22 n      5     Fri May 20 21:29:22 CDT 1988
.R
.LG
.in -1i
.ce
Figure 7.3 Accounting File Entry
.KE
.PP
The host,
user,
printer,
and format
information
can be obtained from the parameters passed to the filter.
The page entry is the number of billable pages.
When the
.I pac
program produces a summary,
the summary file has the format as in
Figure 7.4.
.KF
.L
.SM
.in +1i
.nf
host              user printer       format pages  jobs
attila.cs.umn.edu root imagen_lind22 n      5      1
attila.cs.umn.edu root imagen_lind22 l      220    7
.R
.LG
.in -1i
.ce
Figure 7.4 Summary File Entry
.KE
.PP
Experience has indicated that most sites use a differing approaches
to accounting,
with little requirement commonality.
Thus,
these accounting procedures and information may be
added or modified as required.
Note that the accounting is done by the filter programs,
and not by the PLP software.
.NH 2
Prefilters
.PP
The 
.I lpr 
program can use
.I prefilters
to process the text before spooling.
The prefilters are invoked with the the following arguments,
which are the same as specified for the output filter.
.DS
.DT
.SM
.L
filtername arguments \e
	-Pprinter -wwidth -llength -xwidth -ylength [-c] [-iindent] \e
	[-Zoptions] [-Cclass] [-Jjob] [-Raccntname] -nlogin -hHost \e
	-Fformat file [files]
.R
.DE
.PP
The options are specified in exactly the same manner
as for the filter for the specified format.
The file names are either those specified to
.I lpr
by the user,
or a copy of the input from stdin.
The prefilter must copy these files to stdout,
performing whatever filter functions are neccessary.
.PP
If successful,
the prefilter should exit with a 0 user status;
anything else will indicate failure and the user job will be discarded.
Errors written to
.L stderr
will be directed to the
.I lpr
.L stderr
output.
.NH 2
Adapting Existing Filters and Writing Filters
.PP
If you have an existing set of filters for the Berkeley LPD
daemon,
you can use the
.L compat
program supplied with this package to adapt them to use with PLP.
This program invokes an OF, IF,
or other filter with the old Berkeley style of parameters.
For example,
the following entry printcap
.B if
entry will invoke the
.L imfilter
program to be used as the IF filter.
.ti +.5i
.L "if=/usr/local/lib/compat /usr/local/lib/imfilter"
.PP
If a new filter is needed,
you can start with the 
programs supplied with this distribution,
found in the
.I filters
directory.
A sample filter would consist of an application independent
.L main
routine which parses the command line input flags
and calls a user supplied
.L filter()
function,
and support functions.
These are available in the
.L filter/main.c
file.
The 
.I suspend()
support routine
suspends the filter when the appropriate string is detected in the input.
Error message and termination routines are provided.
