.ig
$Header: 06.t,v 1.1 88/05/21 18:39:41 papowell Locked $
$log$
..
.NH 1
Local Spool Queues and Servers
.PP
The 
.I lpd
process
handles the unspooling process for local and remote spool queues in
much the same manner.
.I Lpd
forks a server process to unspool entries from a queue.
The server (or unspooler) process checks the spool queue lock file to see if
unspooling is enabled,
sorts jobs according to priority,
and then takes printing actions as specified by the
printcap entry for the spool queue.
In order to provide fine control over the printing process,
the unspooler forks a set of filter processes
based on information in the printcap entry to handle specialized printer
requirements.
These filter processes are used to:
.IP 1). 3
Provide control over device dependencies,
above that allowed by the simple serial line control functions.
.IP 2). 3
Print banners or job separator information.
.IP 3). 3
Provide specific processing for a particular job format.
.IP 4). 3
Provide accounting information.
.PP
Different classes of output devices require different amounts or kinds of
filter support.
The following sections outline the different options
and the filter support provided for them.
.NH 2
Job Format and Filter Selection
.PP
Associated with each data file of a job is a unspooling format.
When unspooling a job,
the server uses this format to select a filter to be used to process
the data file.
By convention,
the format used for printing a job is specified by
a lower case letter (a\-z),
and the corresponding filter for the format is specified by
the printcap field
x\c
.B f,
where x represents the format.
This is not uniformly true,
as the
.B af
(accounting file name),
.B lf
(log file name),
and
.B ff
(form feed string)
entries are used for other purposes.
In Figure 6.1,
.B af
specifies the accounting file,
.B lf
is the log file,
and
.B of ,
.B if ,
and
.B tf
are filter programs.
.KF
.DT
.nf
.SM
.L
.in +1i
# Versatec Printer, Lind 33
#   Uses the new filters
versatec_lind33\||\|versatec:\e
	:fx=flpdt:mx#2000:\e
	:lp=/dev/va0:sd=/usr/spool/versatec_lind33:\e
	:af=vaacct:\e
	:lf=logfile:\e
	:of=/usr/lib/vpf:\e
	:if=/usr/lib/vpf:\e
	:df=/usr/lib/vpf:\e
	:tf=/usr/lib/rvcat:
.in -1i
.LG
.R
.ce
Figure 6.1.  Local Printer Printcap Entry
.KE
.NH 2
No Filter Support Specified
.PP
If no output filters are specified,
the server opens the output device,
sets the serial line characteristics if it is a serial line,
and prints directly to the output device.
.NH 2
Banners and Separators
.PP
By default,
jobs are separated by a banner page or separator page that is generated by the
server process.
The default banner is a single page,
with the user name and job information printed in large letters.
The
.B sb
(short banner)
option specifies a single line banner of the following form:
.nf
.ti +5
.L "[user]:[host] Job: [jobname] Date: [date]"
.ti +5
.L "papowell:attila.cs.umn.edu Job: (stdin) Date: Fri May 20 11:29:05 1988"
.fi
.PP
The
.B sh
(suppress header)
flag suppress banner printing.
The
.I lpr
no header option 
(\-h)
allows the user to request no header or banner for the job;
the
.B ab
(always print banner) printcap flag
causes the server to ignore the no banner request.
.PP
Consecutive printer jobs are normally separated by a form feed;
the default (c
.B \ef )
can be changed by specifying a value for the
.B ff
(form feed string) field.
The
.B sf
(suppress form feeds)
can be used to suppress any printing of form feeds between jobs.
When the printer is started,
it may be necessary to initialize the printer by sending some additional
information.
The
.B fo
(form feed on open) flag specifies that the
.B ff
string is printed before the first job,
and the
.B fq
(form feed on quitting)
flag specifies that a form feed is printed after the last job.
In addition,
.B ld
(leader on open) specifies a string to be printed before the
(optional) intial form feed
and the
.B tr
(trailer) specifies a string to be printed after the
the (optional) final form feed.
The
.B ld
and
.B tr
strings are useful for specifying an escape sequence that sets up
form length, etc.
.PP
In addition to the built in banner printer,
the
.B bp
(banner printer)
and
.B ep
(end printer)
fields can be used to specify banner and trailer printing programs.
These programs are invoked to print banners or other information after the
built in banner or separator has been printed.
Custom banner printing may be done by suppressing built in banners with
.B sh
and
.B sf
and using the
.B bp
and
.B ep
entries.
.NH 2
Simple OF and IF Filter Support
.PP
The
.B OF
(output filter)
specified by the
.B of
field is used by the server to
print banners and provide a simple filter action for devices that
need a minmum amount of control.
The OF filter
is not intended to perform accounting since it is started only once
and no provision is made for passing
owners' login name,
identifying the begining and ending of jobs,
etc.
.PP
The OF filter is started when the server discovers that it has a
job to print.
The server will open the output device,
do any line control operations,
and then start the OF filter.
Banner and job separator strings will be sent to the
OF filter,
which filters them and sends them to the output device.
In order to use other filters,
the server will request the OF
filter to suspend itself by sending it the two character sequence
\e031\e001 or ESC ^A.
The OF filter should then suspend itself by using a
.L "kill(0,SIGSTOP)" .
The server will wait for this event,
and then start up other filters.
After they have completed,
the server will signal the OF filter to continue by using
.L "kill(OF_pid,SIGCONT)" .
.PP
The IF filter
specified by the
.B if
field is used to format jobs with the
.B f
format,
which is for ordinary textual output.
The
.I lpr
program will use 
.B f
format by default if no format is specified,
and also for printing literal output
(lpr \-l option)
or
.I pr
output (lpr \-p option).
The IF filter is expected to do formatting and update an accounting file.
If there is no IF filter and an
.B f
format job is printed,
it is filtered through the
.B OF
filter.
If there is no OF filter,
then the printer will copy the file directly to the output device.
.NH 2
Non-standarstandard Formats and Filters
.PP
The
.B lpr
program allows the user to specify a job format;
the
.B f
format is the default format for text files.
The
.B fx
printcap field specifies the formats allowed on the printer;
the default permitted formats are
.L "f, l,"
and
.L "p" .
The
.B lpr
program checks to see if the requested format is allowed when
it spools a job.
Each format must have a corresponding filter,
which is used to process data files of the specified format.
Note that these filters may be invoked once per data file,
or the entire set of data files may be combined into a single file
and passed through a single invocation of the filter.
Usually the effects of doing this are indistinguishable,
but some filters will cause an alignment of printer media
to be done for each invocation.
This is an implementation dependent phenomina.
.PP
The commonly available set of formats is specified in the
.I lpr
man page.
The
.I "f"
(default),
.I "l"
(literal),
and
.I p
(use the ``pr'' program to format output)
formats are printed using the
.B if
output filter.
The
.I lpr
\-f option is used to specify printing with a filter that
handles FORTRAN formats;
this flag is translated by
.I lpr
into printing with the
.B r
format.
The
.I "a, i, l,"
and
.I "o"
formats are unavailable,
as their filter names
(\c
.L af,
.L if,
.L lf
and
.L of )
are used for other purposes.
.NH 2
Prefilters
.PP
The 
.I lpr
program can pre-filter files before spooling them.
The
.B Xe
field is used to specify that format
.B X
files are to processed by the specified prefilter.
The prefilter specification consists of the pathname and arguments of the
prefilter program,
followed by the format that is to be used for spooling the output.
.KF
.DT
.L
.SM
.nf
.in +1i
# Versatec Printer, Lind 33
#   Uses a prefilter for f format
versatec_lind33\||\|versatec:\e
	:fx=flpdt:mx#2000:\e
	:lp=/dev/va0:sd=/usr/spool/versatec_lind33:\e
	:af=/usr/adm/vaacct:\e
	:of=/usr/lib/vpf:\e
	:if=/usr/lib/vpf:\e
	:df=/usr/lib/vpf:\e
	:tf=/usr/lib/rvcat:\e
	:fe=/usr/local/lib/vprintup -X w4,f:
.R
.LG
.in -1i
.ce
Figure 6.2 Prefilter Printcap Entry
.KE
For example,
the printcap entry in Figure 6.2 specifies that
.B f
format files are prefiltered through
.I vprintup
and the output is in the
.I f
format.
.NH 2
Special Queue Handlers
.PP
If the user does not like the way that the PLP server handles files,
the printcap can be used to specify a queue handler program
to handle processing of the job and data files.
This is useful when you are sending files to a remote machine
using a special protocol or a remote procedure call.
The printcap queue handler field
.B qh
specifies a program which will be responsible
for handling the job.
.KF
.DT
.L
.SM
.nf
.in +1i
.ta 4n +4n +4n +4n +4n +4n +4n +4n +4n +4n +4n 8i
# Special queue entry, used for bizzare purposes
# The queue_handler program will take care of everything
special:\e
	:lp=/dev/null:\e
	:qh=/usr/local/lib/queue_handler:
.R
.LG
.in -1i
.ce
Figure 6.3 Queue Handler Printcap Entry
.KE
.PP
The queue handler is invoked once per queue entry,
and exits with a 0 (successful),
1 (unsuccessful, retry),
or other (give up and delete entry) status.
Error messages printed on
.I stderr
(file descriptor 2) will be placed in the spool queue log file.
.NH 2
Multiple Servers For a Spool Queue
.PP
If a spool queue has multiple servers,
they are specified using the
.B sv
(servers) parameter,
which contains a comma separated list of server entries in the printcap file.
The printcap entry for a server contains a
.B ss
(serves) parameter which contains the name of the spool queue that it
serves.
.PP
Printcap entries for the server are determined in the following manner.
When the spool queue server starts up,
it reads the spool queue printcap entry,
and determines that there are multiple servers for the queue.
It then forks a printer server process for each name in the
.B sv
list.
.PP
The individual printer server process reads the printcap entry for the
individual printer,
overwriting or adding any existing values read from printcap for the
spool queue.
Since server entries use the
the spool directory of the spool queue,
their individual log and other files should have
distinct names.
Common information can be put in the spool queue printcap entry,
and entries that differ for each printer,
such as the output device,
need to appear the individual printer printcap entry.
