/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: setstatus.c
 * Set the lpd status into a status file
 ***************************************************************************
 * Revision History: Created Sat Jan  9 14:49:44 CST 1988
 * $Log:	setstatus.c,v $
 * Revision 3.1  88/06/18  09:35:43  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.1  88/05/09  10:10:21  papowell
 * PLP: Released Version
 * 
 * Revision 1.3  88/04/06  12:13:37  papowell
 * Minor updates, changes in error message formats.
 * Elimination of the AF_UNIX connections, use AF_INET only.
 * Better error messages.
 * 
 * Revision 1.2  88/03/12  10:03:36  papowell
 * *** empty log message ***
 * 
 * Revision 1.1  88/03/01  11:09:18  papowell
 * Initial revision
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: setstatus.c,v 3.1 88/06/18 09:35:43 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint

#include "lp.h"

/*VARARGS1*/
setstatus(msg, a1, a2, a3, a4, a5)
	char *msg;
{
	int fd, i;		/* ACME Buggy Whip and Integers, Inc. */
	char buf[BUFSIZ];

	if( ST && *ST ){
		if( (fd = Exlockcf( ST )) < 0 ){
			logerr(XLOG_INFO, "setstatus: cannot open %s", ST);
		} else {
			(void)sprintf(buf, msg, a1, a2, a3, a4, a5);
			(void)strcat(buf, "\n" );
			i = strlen(buf);
			if( write( fd, buf, i ) != i ){
				logerr(XLOG_INFO, "setstatus: write error %s", ST);
			}
			(void)close(fd);
		}
	}
}
