/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: lpr.h
 * Header file for LPR Program
 ***************************************************************************
 * $Header: lpr.h,v 3.1 88/06/18 09:34:49 papowell Exp $
 * Revision History: Created Sat Jan 30 19:39:13 CST 1988
 * $Log:	lpr.h,v $
 * Revision 3.1  88/06/18  09:34:49  papowell
 * Version 3.0- Distributed Sat Jun 18 1988
 * 
 * Revision 2.2  88/05/29  13:10:14  papowell
 * Added Header string for RCS purposes
 * 
 * Revision 2.1  88/05/09  10:10:55  papowell
 * PLP: Released Version
 * 
 * Revision 1.3  88/05/05  20:09:02  papowell
 * Added a NOHEADER option that allows user to suppress banner
 * 
 * Revision 1.2  88/03/25  15:00:20  papowell
 * Debugged Version:
 * 1. Added the PLP control file first transfer
 * 2. Checks for MX during file transfers
 * 3. Found and fixed a mysterious bug involving the SYSLOG facilities;
 * 	apparently they open files and then assume that they will stay
 * 	open.
 * 4. Made sure that stdin, stdout, stderr was available at all times.
 * 
 * Revision 1.1  88/03/01  12:44:04  papowell
 * Initial revision
 * 
 ***************************************************************************/
#include "lp.h"

extern int Format;		/* Job Format */
extern int Copies;		/* Number of Copies */
extern int Binary;		/* Binary files */
extern int Use_links;	/* Make a symbolic link to the file */
extern int Remove;		/* Remove file after spooling */
extern int Noheader;	/* No header is to be printed */
extern char **Temp_file;	/* Names of temp files */
extern int Temp_count;	/* current number of temp files */
extern int Temp_max;	/* maximum number of temp files */
extern int Exper;		/* use the Xpert version */
extern int Priority;	/* priority */
extern int Job_number;	/* job sequence number */
extern char *Add_temp();	/* add a file to the temporary list */
extern char *Get_tmp_data();	/* create a temporary data file name */
extern char *Get_home();	/* get the home directory */
extern char *Get_cf();		/* create a temporary control file name */
extern char *Make_cf();		/* rename the temporary control file as real  */
extern char *Read_stdin;	/* name of temp file holding stdin */
extern int Open_SD(); 	/* Open the file in the spool directory */
extern char *Filter_out;	/* name of temp file for filter output */
extern char *Copy_file();	/* copy file to a temp file */
extern char *Get_cwd();		/* get the current working directory */
extern char *Full_path();	/* get the full path from the CWD */
extern int Do_prefilter();	/* do prefilter and return length */
