#ifndef	lint
/*
 * Updated LPR software;
 * Original Version (Copyright) 1983 Regents of the Univeristy of California
 * This is a derivative work,
 * and the original copyright is still valid.  Covered by the
 * 4BSD Licensing Agreement;  this is NOT public domain software.
 * Mon Nov 23 09:23:23 CST 1987 Patrick Powell, U. Minnesota
 */
#ifndef __INDENT_INCL
static char id_str1[] =
	"Revised LPR, Patrick Powell, U. Waterloo, April 10, 1984";
static char id_str2[] =
	"Re-revised LPR, Patrick Powell, U. Minnesota, 23 Nov 1987";
#define __INDENT_INCL 1
#endif __INDENT_INCL
#endif lint
/*
 * Prefilter main and setup.
 *	A prefilter is invoked with the following parameters:
 *
 *
 * filter -wwidth -llength -xwidth -ylength [-c]  [-iindent]
 *		-Zoptions -Cclass -Jjob -nlogin -hhost -Fx [files]
 * 
 *	if the [files] are missing, input is from stdin
 *
 *	The following variables are set up
 *
 * name		- name of filter			PRINTCAP ENTRY
 * width	- default 132				pl
 * length	- default 66				pw
 * xwidth	- default 0				px
 * ylength	- default 0				py
 * literal	- default 0 [-c flag]
 * indent	- default 0
 * zopts	- NULL	[lpr]
 * class	- NULL [lpr]
 * job		- NULL [lpr]
 * login	- NULL [lpr]
 * host		- NULL [lpr]
 * format	- set from -F
 * last		- set for last file
 * file		- current file (NULL if stdin)
 *
 *	The list of files is opened, and the file descriptor is set to 0
 *	with a dup2.  The "last" flag is set when the last file is opened.
 *	The name of the current file is available in "file".
 *	Then the "prefilter" function is called.
 *	The program exits with a 0 (successful), 1 (unsuccessful, retry)
 *	and anything else indicates unsuccessful, no retry.
 *	The prefilter() function should return a similar status.
 *	The functions fatal(), logerr(), and logerr_die() can be used to report
 *	status. The variable errorcode can be set by the user before calling
 *	these functions, and will be the exit value of the program. Its default
 *	value will be 2.
 *	The fatal function reports a fatal message, and terminates
 *	logerr() will report a message, append information indicated by errno
 *	(see perror(2) for details), and then returns.
 *	logerr_die() will call logerr(), and then will exit with errorcode
 *	status.
 *	In case of an error, the "cleanup()" function will be called.
 *	This can be used to do any error functions.
 *
 */

#include <stdio.h>
#include <sys/file.h>

int errorcode = 2;

char *name;		/* name of filter */
int width = 132;	/* default 132	*/
int length;	/* default 66	*/
int xwidth;	/* default 0	*/
int ylength;	/* default 0	*/
int literal;	/* default 0 [-c flag]*/
int indent;	/* default 0 */
char *zopts;	/* NULL	[lpr]*/
char *class;	/* NULL [lpr]*/
char *job;	/* NULL [lpr]*/
char *login;	/* NULL [lpr]*/
char *host;	/* NULL [lpr]*/
int format;	/* set from -F*/
int last;	/* set for last file*/
char *file;	/* current file (NULL if stdin)*/

main( argc, argv )
	int argc;
	char **argv;
    {
	char * arg;
	int i;

	name = argv[0];
	++argv;

	/*
	 * process the flagged arguments
	 */
	while( --argc > 0 ){
		if( **argv != '-' )
			break;
		arg = 1 + *argv++;	/* arg ^s to the option letter */
		switch( *arg++ ){	/* arg now ^s to the option value */
		case 'w':
			if( (i = atoi(arg))< 0 ){
			fatal("argument for %c out of range",arg[-1]);
			} else if( i > 0 ){
				width = i;
			}
			break;
		case 'l':
			if( (i = atoi(arg))< 0 ){
			fatal("argument for %c out of range",arg[-1]);
			} else if( i > 0 ){
				length = i;
			}
			break;
		case 'x':
			if( (i = atoi(arg))< 0 ){
			fatal("argument for %c out of range",arg[-1]);
			} else if( i > 0 ){
				xwidth = i;
			}
			break;
		case 'y':
			if( (i = atoi(arg))< 0 ){
			fatal("argument for %c out of range",arg[-1]);
			} else if( i > 0 ){
				ylength = i;
			}
			break;
		case 'c':
			literal = 1;
			break;
		case 'i':
			if( (i = atoi(arg))< 0 ){
			fatal("argument for %c out of range",arg[-1]);
			} else if( i > 0 ){
				indent = i;
			}
			break;
		case 'Z':
			zopts = arg;
			break;
		case 'C':
			class = arg;
			break;
		case 'J':
			job = arg;
			break;
		case 'n':
			login = arg;
			break;
		case 'h':
			host = arg;
			break;
		case 'F':
			format = *arg;
			break;
		}
	}
	/*
	 * now assume the rest of the arguments are filenames
	 */
	dofiles( argc, argv );
    }


/*
 * Now do the files.  Open each as fd 0 (stdin), and read each one.
 */
dofiles( argc, argv )
	int argc;	/* # of items in 'argv' */
	char **argv;
    {
	int fd;

	if( argc > 0 ){
		while( --argc >= 0 ){
			file = *argv++;
			if( argc == 0 ){
				last = 1;
			}
			if( (fd = open(file,O_RDONLY,0)) < 0 ) {
				logerr_die( "cannot open %s ", file );
			}
			if( fd != 0 ){
				if(dup2( fd, 0 ) < 0){
				errorcode = 1;
				logerr_die( "dup2 failed" );
				}
				(void)close( fd );
			}
			prefilter();
			(void)clearerr( stdin );
			(void)close(0);
		    }
	} else {
		last = 1;
		prefilter();
	}
	exit(0);
    }

/*VARARGS1*/
log(msg, a1, a2, a3)
	char *msg;
{
	(void)fprintf(stderr, "%s: ", name);
	(void)fprintf(stderr, msg, a1, a2, a3);
	(void)putc('\n', stderr);
	(void)fflush(stderr);
}


/*VARARGS1*/
fatal(msg, a1, a2, a3)
	char *msg;
{
	log(msg, a1, a2, a3);
	cleanup();
	exit(errorcode);
}


/*VARARGS1*/
logerr(msg, a1, a2, a3)
	char *msg;
{
	extern int errno, sys_nerr;
	extern char *sys_errlist[];
	register int err = errno;

	(void)fprintf(stderr, "%s: ", name);
	if (msg){
		(void)fprintf(stderr, msg, a1, a2, a3);
		(void)fputs( "- ", stderr);
	}
	(void)fputs(err<sys_nerr ?sys_errlist[err] :"Unknown error", stderr);
	(void)putc('\n', stderr);
	(void)fflush();
}

/*VARARGS1*/
logerr_die(msg, a1, a2, a3)
	char *msg;
{
	logerr(msg, a1, a2, a3);
	cleanup();
	exit(errorcode);
}

#ifdef DEBUG
cleanup() {}

prefilter()
    {
	int c;

	if( file ){
		log( "file %s", file );
	} else {
		log( "file %s", "(stdin)" );
	}
	while( (c = getchar()) != EOF ){
		putchar(c);
	}
    }
#endif DEBUG
