.ig
$Header: 11.t,v 1.1 88/05/21 18:39:52 papowell Locked $
$log$
..
.bp
.NH 1
Installation and Testing
.PP
The following is a summary of the installation
and test procedures for the PLP software.
.NH 2
Source Files
.PP
As distributed,
all source and related files for the software have been
collected under a common directory
$(PLP),
The $(PLP) directory has the following structure.
.DS
.DT
.ta 12m +4n +4n
.L
.SM
README	-- brief summary
Makefile	-- calls {bin, filters, utilities}/Makefile
bin/	-- directory for binaries and executables
bin/Makefile	-- Makefile for executables
doc/	-- documentation source, this document
filters/	-- output filters
lint/	-- directory for lint output
man/	-- man pages
src/	-- source for lpd, lpr, lpc, etc.
test/	-- test programs and files
utilities/	-- source for pr, cpr and other handy print formatters.
printcap/	-- a method to organize printcap entries
.DE
.NH 2
Printcap And Printer Permissions Files
.PP
The PLP software uses a different organization of printcap and permissions
files than the Berkeley LPD.
All of the PLP related control and informations files are gathered in
.L /usr/spool/lpd .
For example:
.DS
.nf
.SM
.L
.ta 15n +4n +4n +4n 8i
.vs -2
.R
.LG
/usr/spool/lpd/printcap.<host>	# printcap for <host>
/usr/spool/lpd/printer_perms.<host>	# printer permissions for <host>
/usr/spool/lpd/lpd.lock.<host>	# lpd daemon lock for <host>
/usr/spool/lpd/log.<host>	# lpd daemon log for <host>
.vs +2
.LG
.R
.DE
In a networked base file system,
this allows a single spool directory to be shared among all the
systems using PLP.
In addition,
only system which are performing unspooling operations will need to
have an LPD daemon running.
Finally,
care has been taken to ensure that all accesses to the shared files are
done by
user id
.L daemon .
.PP
In order to update an existing system,
all that needs to be done is to create a spool directory and
provide the above files.
The file
.L $(PLP)/test/printer_perms.all
is a prototype printer permissions file that does not provide
many restrictions.
.KF
.in +1i
.nf
.DT
.L
.SM
.vs -2
.ta 4n +4n +4n +4n +4n +4n +4n +4n +4n +4n +4n 8i
#!/bin/csh
# Creating the /usr/spool/lpd directory
set h=<<<<host>>>>;	# specify your host name
mkdir /usr/spool/lpd
ln -s /etc/printcap /usr/spool/lpd/printcap.${h}
cp $(PLP)/test/printer_perms.all /usr/spool/lpd/printer_perms.${h}
.vs +2
.sp .5v
.R
.LG
.in -1i
.ce
Figure 11.1  Creating Directories
.KE
.NH 2
Compilation and Installation
.PP
The
.L bin
directory is used to hold binaries.
During the initial installation procedure,
you should copy the
.L Makefile
from the
.L src directory,
and set any system  dependent flags in the Makefile.
The flags
.L IS_<system>
are used to specify the system type,
and cause conditional compilation of
entries in the
.L src/lp.h
file.
After checking the flags and their implications,
.L "make all"
can be used
to compile and link the programs.
.PP
As distributed,
the
.L XPERIMENT
compilation flag is set in the Makefile,
and causes a test verion of the PLP softwar to be generated.
It is strongly suggested you try the test or experimental version first,
i.e.- compile with the XPERIMENT option enabled,
and then try a fully functional version.
.NH 2
Test Version
.PP
A test version of the spooling software can be generated
by compiling with the XPERIMENT flag set.
This causes
.L /tmp/printcap.<host>,
.L /tmp/printer_perms.<host>,
and a non-priviledged INET port
to be used,
rather than
.L /usr/spool/lpd/printcap.<host>,
and the priviledged TCP/IP printer server port.
.PP
The PLP distribution
.B test
directory contains prototype or debugging versions of printcap,
printer_perms,
and other files;
.B test/Makefile
will generate and install the necessary directories,
etc.,
and
will install the necessary filters.
The test devices have their spool directories in /tmp,
and should be trivial to install.
Run the tests listed below
to ensure that the various programs are working.
Note that all the functionality of the PLP software can be checked out
as an ordinary user,
and you do NOT need to run as ROOT.
.PP
In summary,
to make the test verions,
do the following.
.IP 1).
Create a bin directory,
copy the Makefile from src,
edit the Makefile and set the various system dependencies.
.IP 2).
Run
.L "make all" .
At this point you will have all of your binaries in the bin
directory,
where you should leave them.
Set up your shell $path or $PATH to use
$(PLP)/bin directory ahead of /usr/ucb,
otherwise you will use the existing LPD programs.
.IP 3).
Go to the
.L test
directory,
read the
.L test/README
file,
edit the
.L test/Makefile
according to directions,
and do
.L "make bin" .
in the
.L test
directory.
This generates some executables and places them in the /tmp
directory,
as well as installing a test version of the printer permission file.
.IP 4).
Now you should take a nap,
play rogue,
or whatever you do to relax.
The next part is not fun.
.NH 3
Test 1\- LPC, LPR, LPQ
.PP
To run the first tests,
change to the
.L test
directory and do
.L "make test1" .
This installs the printcap file of Figure 11.2 in /tmp/printcap:
.KF
.in +1i
.nf
.DT
.L
.SM
.vs -2
.ta 4n +4n +4n +4n +4n +4n +4n +4n +4n +4n +4n 8i
#
# TEST VERSION OF PRINTCAP FILE:
# Test 1: simple lpr functions
#
test:\e
	:fx=flpdnt:ex:\e
	:pw#75:pl#66:rw:\e
	:br#9600:fs#040:fc#011:\e
	:ty=new 19200 even -tabs tandem:\e
	:lp=output:\e
	:if=/tmp/filter -delay30:\e
	:of=/tmp/lpf -D5:\e
	:sd=/tmp/test:
.vs +2
.sp .5v
.R
.LG
.in -1i
.ce
Figure 11.2  Test 1 Printcap File
.KE
.PP
You should look at the code for the
.L filter
and the
.L lpf
programs which were created by the
.L "make bin" .
The
.L filter
program is a handy dandy debugging filter.
The
.L lpf
filter simply copies stdin to stdout,
and suspends itself when it detects the stop string.
The
.L lpf
filter source is the skeleton for any new filters that are needed.
.PP
You can test the functionality of the
lpq,
and lpr
programs by using the illustrated commands.
Sample output has been provided.
.nf
.vs -2
.DT
.SM
.L
.ta 12n +4n +4n +4n +4n +4n +4n +4n
%>lpq -D5	#should display queue (empty)
lpq: pid=4233, LOG_DEBUG, First_printer: simple at Fri May 20 17:02:08 1988
lpq: simple- pid=4233, LOG_DEBUG, Get_Printer: First_printer 'simple' at Fri May 20 17:02:08 1988
lpq: simple- pid=4233, LOG_DEBUG, Get_printer: using Printer simple at Fri May 20 17:02:08 1988
lpq: simple- pid=4233, LOG_DEBUG, Readlockfile: lockfile 'lock' at Fri May 20 17:02:08 1988
lpq: simple- pid=4233, LOG_DEBUG, Readlockfile: lock, perms 0100644 at Fri May 20 17:02:08 1988
lpq: simple- pid=4233, LOG_DEBUG, Readlockfile: 'lock' pid 0 len 0 at Fri May 20 17:02:08 1988
lpq: simple- pid=4233, LOG_DEBUG, Checklockfile: lock server 0 at Fri May 20 17:02:08 1988
lpq: simple- pid=4233, LOG_DEBUG, printstatus: ST status at Fri May 20 17:02:08 1988
Printer 'simple' (attila.cs.umn.edu):
  work done at Wed May 18 09:38:59 1988

%>lpr xx	#place job in queue
lpr: Warning- File 'xx' not printed: cannot access it
lpr: Fatal error- nothing to print

%>echo hi | lpr	#place job in queue
lpr: simple- Startserver: host 'attila.cs.umn.edu' server for 'simple'
	not started - Connection refused at Fri May 20 17:08:51 1988

%>lpq	#should display queue one entry
Printer 'simple' (attila.cs.umn.edu):
Warning: no server present
  Rank Owner       Pr Job Host        Files                Size
   1st papowell    Z  13  attila      (stdin)              3

%>lpc	#play with lpc
>status
Queue          Jobs    Queueing     Printing
simple            1    enabled      enabled (no server)

>disable simple
simple: queueing disabled
>status
Queue          Jobs    Queueing     Printing
simple            1    disabled     enabled (no server)
>quit
.R
.LP
.NH 3
Test 2\- LPD Functionality
.PP
Use the commands:
.ti +.5i
.L "echo >/tmp/error"
.ti +.5i
.L "lpd  -D5 -L /tmp/error; tail -f /tmp/error"
.br
to create the error log file and to start up ldp.
It is best to do this at one terminal,
and then do the remaining tests at another terminal.
Lucky windowing system users will,
of course,
simply open another window.
You will be amused to watch the lpd spring into action,
trying to create servers,
etc.
The
.L simple
server will log into the
.L /tmp/simple/log
file.
.PP
You can remove /tmp/test/log,
and see the interaction of the lpd daemon and the printer server
little clearer.
To kill the lpd daemon,
do the following:
.DS
.DT
.L
.SM
lpc lpd		##- prints the lpd daemon id
kill <pid>	# kill off the daemon
rm /tmp/test/log	# remove the log file
echo >/tmp/error
lpd -D5 -L /tmp/error
tail -f /tmp/error
.R
.DE
.PP
If you are curious,
try starting multiple
.L "lpd"
programs;
when
.L lpd
is started,
it checks for a running daemon,
print a message,
and then exits.
.PP
You can examine the conditions of the servers and other
activites by using
.I lpq .
Note that the lpq status report includes a chatty informational piece about
the job progress.
.PP
The OF filter has been carefully created to print out
various pieces of information.
You can see what this is if you look at /tmp/test/output,
where the output is going.
You will notice that the IF filter is a shell script,
and will do a sleep for a while.
You can now test out the various lpq,
lpr,
and lpc functions.
.NH 3
Test 3 \- Remote Servers
.PP
These tests check out the functionality of inter host spooling functions.
They have been written so that they will use the local host intitially,
but can be extended to the remote host.
.PP
In the
.L test
direcotory, do
.L "make test2"
to install the second form of the printcap file.
You will not have to kill the lpd to do this.
Now try
.ti +.5i
.L "lpq -Premote"
.br
and examine the output.
The lpq program will print out the local queue,
and then send a message to the remote host (which is the local host)
using the INET protocol.
This will check out the functionality of the network communication.
You can play with lpr,
lpc,
etc. and check this out.
Try the
.I remote
functions of the
.I lpc
program.
.PP
If you have two hosts available,
install the PLP software on both of them.
Edit the printcap files so that one of them has the local test,
and the other the remote test entry.
Don't forget to install and modify the printer_perms file so that the
remote host can access the test spool queue.
Try the communications out.
.NH 3
Test 4 \- Multiple Servers
.PP
This will demonstrate how to have multiple servers for a single spool
queue.
Install the printcap file by doing
make test3.
Use lpq to check the status of the spool queue.
Now use lpr to send a slog (10 or more) jobs to the multi queue.
You can use
.ti +.5i
.L "lpq +10 -a"
.br
to monitor what happens.
.NH 3
Test 5 \- Serial Line Control
.PP
If you have a printer,
attach it to a suitable serial line,
and modify the test printcap entry so that it is set up
for the printer.
I have found that the following procedure works pretty good.
.PP
Set the
.B sh
(suppress headers or banners)
in the printcap entry,
and remove the
.B of
entry.
Set up a new entry for if,
.B "if=/tmp/serial -d30"
and edit the filter program to print out the stty settings.
You can now run lpr to try and send things out to the printer.
You will either have lots of problems or no problems in communicating
with the printer.
.PP
Watch out for parity;
you may have to fool around with the printer parity settings.
I strongly suggest a NO parity setting.
Tandem flow control is another tricky area.
You may have to open the printer RW using
.B rw
to get tandem flow control.
This has been a problem with several installations.
.NH 2
Installing a Working Version
.PP
Before you install a the PLP software,
you should make a copy of the existing print spooler software.
There is a set of programs in the
.L backup
directory of the PLP distribution that have proven to be very useful.
.IP 1).
Edit the
.L bin/Makefile ,
and disable the XPERIMENT flag.
Do a
.L "make clean; make all"
to regenerate the working version.
.IP 2).
Create a printer permissions file.
You can base this on the version in the
.L test
directory.
The version
in Figure 12.3 is useful for initial installations,
and can be found in
.L test/printer_perms.all .
.KF
.nf
.SM
.L
.vs -2
# Printer permissions data base
# host user printerqueue maxpriority maxpages currentpages
# * is a wildcard
#host   user      printer     perms  pr maxpages pages
*       root      *           *      *  0        0  #root on any system
*       *         *           R      G  0        0 #anybody can do remote
.vs +2
.LG
.R
.sp .5v
.ce
Figure 11.3  Sample Printer Permissions File
.KE
.IP 3).
Do a
.L "make install"
and check that permissions have been set correctly.
.IP 4).
Using the same tests as outlined above,
make sure that lpr,
lpc,
and lpq
are functional.
.IP 5).
Start lpd
and check that files are unspooled and transferred correctly.
When sending files to remote sites,
both must be running PLP versions.
.NH 2
Organization of Printcap Information
.PP
If you are working in an environment with a large number of
different sites and different printers,
you may find the programs in the
.L printcap
directory handy to manage printcap files.
The organization and management is based on the following structure.
.PP
Each printer has a physical location name and a set of aliases.
For our sample printer,
.L printer_loc ,
There is a
.L printer_loc.local
file which contains a printcap entry suitable for the host which has the device
attached,
a
.L printer_loc.remote
file which contains a printcap entry suitable for a host
which can communicate directly to the remote host,
and a 
.L printer_loc.forward
file which contains a printcap entry suitable for a host
which forwards jobs to either a local or remote host.
For example,
here are typical entries for the 3 files.
These files are stored in the directory
.L printcap/devices .
Figure 12.4 is a sample of several of them.
.KF
.TS
center box;
lw(2.5) |  lw(2.5i) .
.L
.SM
dg1_lind23.local	dg1_lind23.remote
_
T{
.nf
dg1_lind23.local|dg1:\e
    :sd=/usr/spool/dg1_lind23:\e
    :lp=/dev/tty09:sy=9600 -even -odd:
T}	T{
.nf
dg1_lind23.local|dg1:\e
    :sd=/usr/spool/dg1_lind23:\e
    :rm=attila:rp=dg1_lind23:
T}
.TE
.TS
center box;
lw(2.5i) .
.L
.SM
dg1_lind23.forward
_
T{
.nf
dg1_lind23.local|dg1:\e
    :sd=/usr/spool/dg1_lind23:\e
    :rm=attila:rp=dg1_lind23:
T}
.TE
.ce
Figure 11.4  Sample Printcap Files
.KE
.PP
Each host will have a file containing the names of the entries in
the printcap file.
The
.L genpc
program will generate a printcap file from the named printer file
by concatenating the printcap information and placing it in a
.L host.printcap
file.
This file can then be copied to the desired destination.
.NH 2
Checking Out Exisitng Printcaps and Filters
.PP
If you have an exisiting printcap file,
you can check it out by using the XPERIMENTAL form
of PLP before you commit to the actual form.
.IP 1). 3
First,
copy the original
.L /etc/printcap
file to
.L /tmp/printcap.<host> .
.IP 2). 3
Modify the 
.L /tmp/printcap.<host>
file so that the
.L /usr/spool
directories in it are modified to be
.L /tmp
directories.
.IP 3). 3
Compile the test version of the PLP software;
there is an entry in the makefile,
.L "make test"
which will do this in an efficient manner.
.IP 4). 3
Set your 
.L $path
to use  the test version,
and run
.L "checkpc -f"
to create the spool direcotories needed by the
.L /tmp/printcap.<host>
version.
.IP 4). 3
You can now run a parallel version of the PLP software,
and check out the behaviour of devices and filters.
